# __init__.py for dataset
from ._figshare_downloader import FigshareDownloader

from ._figshare_downloads import (
    LARRY_timepoint_interpoltion as timepoint_interpolation,
    LARRY_fate_prediction as fate_prediction,
    LARRY_spliced_unspliced_reads as spliced_unspliced_reads,
)



# from ._dimension_reduction import DimensionReduction
from ._directory_manager import mkdir
from ._url_path_interfaces import (
    inVitroURLPaths,
    inVivoURLPaths,
    CytokinePerturbationURLPaths,
)
from ._load_expr_matrix import load_expr_matrix

from ._data import (
    inVitroData,
    inVivoData,
    CytokinePerturbationData,
)


from .klein_lab_pp_recipe import (
    RunningQuantile,
    cell_cycle_genes,
    vscores,
    highly_variable_genes,
    remove_cell_cycle_correlated_genes,
)

from ._split_data import (
    split_for_timepoint_recovery_task,
    split_for_fate_prediction_task,
    split_for_transfer_learning_task,
    SplitDataForTask,
)

from . import _dataset_utils as utils #  import Messages

from ._anndata_configuration import AnnDataConfiguration
from ._anndata_path_manager import AnnDataPathManager
