"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const pdk_nag_1 = require("aws-prototyping-sdk/pdk-nag");
const application_stage_1 = require("./application-stage");
const pipeline_stack_1 = require("./pipeline-stack");
const app = pdk_nag_1.PDKNag.app();
const pipelineStack = new pipeline_stack_1.PipelineStack(app, 'PipelineStack', {
    env: {
        account: process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_DEFAULT_REGION,
    },
});
const devStage = new application_stage_1.ApplicationStage(app, 'Dev', {
    env: {
        account: process.env.CDK_DEFAULT_ACCOUNT,
        region: process.env.CDK_DEFAULT_REGION, // Replace with Dev region
    },
});
pipelineStack.pipeline.addStage(devStage);
// Add additional stages here i.e. Prod
pipelineStack.pipeline.buildPipeline(); // Needed for CDK Nag
app.synth();
//# sourceMappingURL=data:application/json;base64,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