/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.jsondiagram.JsonDiagram;
import net.sourceforge.plantuml.jsondiagram.StyleExtractor;
import net.sourceforge.plantuml.yaml.SimpleYamlParser;

public class YamlDiagramFactory
extends PSystemAbstractFactory {
    public YamlDiagramFactory() {
        super(DiagramType.YAML);
    }

    @Override
    public Diagram createSystem(ThemeStyle style, UmlSource source, ISkinSimple skinParam) {
        ArrayList<String> highlighted = new ArrayList<String>();
        JsonValue yaml = null;
        StyleExtractor styleExtractor = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            styleExtractor = new StyleExtractor(source.iterator2());
            Iterator<String> it = styleExtractor.getIterator();
            it.next();
            while (true) {
                String line = it.next();
                if (!it.hasNext()) break;
                if (line.startsWith("#highlight ")) {
                    highlighted.add(line.substring("#highlight ".length()).trim());
                    continue;
                }
                list.add(line);
            }
            yaml = new SimpleYamlParser().parse(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonDiagram result = new JsonDiagram(style, source, UmlDiagramType.YAML, yaml, highlighted);
        if (styleExtractor != null) {
            styleExtractor.applyStyles(result.getSkinParam());
            String title = styleExtractor.getTitle();
            if (title != null) {
                result.setTitle(DisplayPositioned.single(Display.getWithNewlines(title), HorizontalAlignment.CENTER, VerticalAlignment.CENTER));
            }
        }
        return result;
    }
}

