/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class DriverTextAsPathG2d
implements UDriver<UText, Graphics2D> {
    private final EnsureVisible visible;
    private final StringBounder stringBounder;

    public DriverTextAsPathG2d(EnsureVisible visible, StringBounder stringBounder) {
        this.visible = visible;
        this.stringBounder = stringBounder;
    }

    private static void printFont() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        int j = fontNames.length;
        for (int i = 0; i < j; ++i) {
            Log.info("Available fonts: " + fontNames[i]);
        }
    }

    @Override
    public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        int ypos;
        Color extended;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        UFont font = fontConfiguration.getFont();
        Dimension2D dim = this.stringBounder.calculateDimension(font, shape.getText());
        double height = Math.max(10.0, dim.getHeight());
        double width = dim.getWidth();
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (extended = mapper.toColor(fontConfiguration.getExtendedColor())) != null) {
            g2d.setColor(extended);
            g2d.setBackground(extended);
            g2d.fill(new Rectangle2D.Double(x, y - height + 1.5, width, height));
        }
        this.visible.ensureVisible(x, y - height + 1.5);
        this.visible.ensureVisible(x + width, y + 1.5);
        g2d.setFont(font.getUnderlayingFont());
        g2d.setColor(mapper.toColor(fontConfiguration.getColor()));
        TextLayout t = TextBlockUtils.createTextLayout(font, shape.getText());
        g2d.translate(x, y);
        g2d.fill(t.getOutline(null));
        g2d.translate(-x, -y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            HColor extended2 = fontConfiguration.getExtendedColor();
            if (extended2 != null) {
                g2d.setColor(mapper.toColor(extended2));
            }
            ypos = (int)(y + 2.5);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            int ypos2 = (int)(y + 2.5) - 1;
            HColor extended3 = fontConfiguration.getExtendedColor();
            if (extended3 != null) {
                g2d.setColor(mapper.toColor(extended3));
            }
            int i = (int)x;
            while ((double)i < x + width - 5.0) {
                g2d.drawLine(i, ypos2 - 0, i + 3, ypos2 + 1);
                g2d.drawLine(i + 3, ypos2 + 1, i + 6, ypos2 - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            FontMetrics fm = g2d.getFontMetrics(font.getUnderlayingFont());
            ypos = (int)(y - (double)fm.getDescent() - 0.5);
            HColor extended4 = fontConfiguration.getExtendedColor();
            if (extended4 != null) {
                g2d.setColor(mapper.toColor(extended4));
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + width), ypos);
            g2d.setStroke(new BasicStroke());
        }
    }
}

