/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UImageSvg
implements UShape {
    private final String svg;
    private final double scale;

    public UImageSvg(String svg, double scale) {
        this.svg = Objects.requireNonNull(svg);
        this.scale = scale;
    }

    public String getMD5Hex() {
        return SignatureUtils.getMD5Hex(this.svg);
    }

    public boolean containsXlink() {
        return this.svg.contains("xmlns:xlink=\"http://www.w3.org/1999/xlink\"");
    }

    public String getSvg(boolean raw) {
        String background;
        String style;
        int idx;
        String result = this.svg;
        if (raw) {
            return result;
        }
        if (result.startsWith("<?xml")) {
            idx = result.indexOf("<svg");
            result = result.substring(idx);
        }
        if (result.startsWith("<svg")) {
            idx = result.indexOf(">");
            result = "<svg>" + result.substring(idx + 1);
        }
        if ((style = this.extractSvgStyle()) != null && (background = this.extractBackground(style)) != null) {
            result = result.replaceFirst("<g>", "<g><rect fill=\"" + background + "\" style=\"" + style + "\" /> ");
        }
        if (!result.startsWith("<svg>")) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private String extractBackground(String style) {
        Pattern p = Pattern.compile("background:([^;]+)");
        Matcher m = p.matcher(style);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String extractSvgStyle() {
        Pattern p = Pattern.compile("(?i)\\<svg[^>]+style=\"([^\">]+)\"");
        Matcher m = p.matcher(this.svg);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public int getData(String name) {
        Pattern p = Pattern.compile("(?i)<svg[^>]+" + name + "\\W+(\\d+)");
        Matcher m = p.matcher(this.svg);
        if (m.find()) {
            String s = m.group(1);
            return Integer.parseInt(s);
        }
        Pattern p2 = Pattern.compile("viewBox[= \"']+([0-9.]+)[\\s,]+([0-9.]+)[\\s,]+([0-9.]+)[\\s,]+([0-9.]+)");
        Matcher m2 = p2.matcher(this.svg);
        if (m2.find()) {
            if ("width".equals(name)) {
                String s = m2.group(3);
                int width = (int)Double.parseDouble(s);
                return width;
            }
            if ("height".equals(name)) {
                String s = m2.group(4);
                int result = (int)Double.parseDouble(s);
                return result;
            }
        }
        throw new IllegalStateException("Cannot find " + name);
    }

    public int getHeight() {
        return this.getData("height");
    }

    public int getWidth() {
        return this.getData("width");
    }

    public double getScale() {
        return this.scale;
    }
}

