/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.AbstractEntityImageBorder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageStateBorder
extends AbstractEntityImageBorder {
    private final SName sname;

    public EntityImageStateBorder(ILeaf leaf, ISkinParam skinParam, Cluster stateParent, Bibliotekon bibliotekon, SName sname) {
        super(leaf, skinParam, stateParent, bibliotekon, FontParam.STATE);
        this.sname = sname;
    }

    private StyleSignatureBasic getSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname);
    }

    private boolean upPosition() {
        if (this.parent == null) {
            return false;
        }
        Point2D clusterCenter = this.parent.getClusterPosition().getPointCenter();
        SvekNode node = this.bibliotekon.getNode(this.getEntity());
        return node.getMinY() < clusterCenter.getY();
    }

    @Override
    public final void drawU(UGraphic ug) {
        HColor borderColor;
        double y = 0.0;
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x = 0.0 - (dimDesc.getWidth() - 12.0) / 2.0;
        y = this.upPosition() ? (y -= 12.0 + dimDesc.getHeight()) : (y += 12.0);
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
            borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            if (backcolor == null) {
                backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
            }
        } else {
            borderColor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder);
            if (backcolor == null) {
                backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
            }
        }
        ug = ug.apply(this.getUStroke()).apply(borderColor);
        ug = ug.apply(backcolor.bg());
        this.entityPosition.drawSymbol(ug, this.rankdir);
    }

    private UStroke getUStroke() {
        return new UStroke(1.5);
    }
}

