/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolCard
extends USymbol {
    private final SkinParameter skinParameter;

    public USymbolCard(SkinParameter skinParameter) {
        this.skinParameter = skinParameter;
    }

    @Override
    public SName getSName() {
        return SName.card;
    }

    @Override
    public SkinParameter getSkinParameter() {
        return this.skinParameter;
    }

    private void drawCard(UGraphic ug, double width, double height, double shadowing, double top, double roundCorner) {
        URectangle shape = new URectangle(width, height).rounded(roundCorner);
        shape.setDeltaShadow(shadowing);
        ug.draw(shape);
        if (top != 0.0) {
            ug.apply(UTranslate.dy(top)).draw(ULine.hline(width));
        }
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 3.0, 3.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolCard.this.drawCard(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), 0.0, symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolCard.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCard.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                USymbolCard.this.drawCard(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), dimTitle.getHeight() + dimStereo.getHeight() + 4.0, symbolContext.getRoundCorner());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 2.0)));
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

