/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.MinMax;

public class Sea {
    private double currentX;
    private final Map<Atom, Position> positions = new HashMap<Atom, Position>();
    private final StringBounder stringBounder;

    public Sea(StringBounder stringBounder) {
        this.stringBounder = Objects.requireNonNull(stringBounder);
    }

    public void add(Atom atom) {
        Dimension2D dim = atom.calculateDimension(this.stringBounder);
        double y = 0.0;
        Position position = new Position(this.currentX, 0.0, dim);
        this.positions.put(atom, position);
        this.currentX += dim.getWidth();
    }

    public Position getPosition(Atom atom) {
        return this.positions.get(atom);
    }

    public void doAlign() {
        for (Map.Entry<Atom, Position> ent : new HashMap<Atom, Position>(this.positions).entrySet()) {
            Position pos = ent.getValue();
            Atom atom = ent.getKey();
            double height = atom.calculateDimension(this.stringBounder).getHeight();
            Position newPos = pos.translateY(-height + atom.getStartingAltitude(this.stringBounder));
            this.positions.put(atom, newPos);
        }
    }

    public void translateMinYto(double newValue) {
        double delta = newValue - this.getMinY();
        for (Map.Entry<Atom, Position> ent : new HashMap<Atom, Position>(this.positions).entrySet()) {
            Position pos = ent.getValue();
            Atom atom = ent.getKey();
            this.positions.put(atom, pos.translateY(delta));
        }
    }

    public void exportAllPositions(Map<Atom, Position> destination) {
        destination.putAll(this.positions);
    }

    public double getMinY() {
        if (this.positions.size() == 0) {
            throw new IllegalStateException();
        }
        double result = Double.MAX_VALUE;
        for (Position pos : this.positions.values()) {
            if (!(result > pos.getMinY())) continue;
            result = pos.getMinY();
        }
        return result;
    }

    public double getMaxY() {
        if (this.positions.size() == 0) {
            throw new IllegalStateException();
        }
        double result = -1.7976931348623157E308;
        for (Position pos : this.positions.values()) {
            if (!(result < pos.getMaxY())) continue;
            result = pos.getMaxY();
        }
        return result;
    }

    public double getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public MinMax update(MinMax minMax) {
        for (Position position : this.positions.values()) {
            minMax = position.update(minMax);
        }
        return minMax;
    }

    public final double getWidth() {
        return this.currentX;
    }
}

