# SpatialCorr: Analyzing spatially varying correlation 
  
![PyPI Version](https://img.shields.io/pypi/v/spatialcorr)
![Read the Docs](https://readthedocs.org/projects/spatialcorr/badge/?version=latest)

## About

SpatialCorr is a set of statistical methods for identifying genes whose correlation structure changes across a spatial transcriptomics sample. Along with a set of statistical tests, SpatialCorr also offers a number of methods for visualizing spatially varying correlation.

Here is a schematic overview of the analyses performed by SpatialCorr:

![alt text](https://raw.githubusercontent.com/mbernste/spatialcorr/main/imgs/Overview_MainFigure_V3-01.png)

For more details regarding the underlying method, see the paper:  
[Bernstein, M.N., Ni, Z., Prasad, A., Brown, J., Mohanty, C., Stewart, R., Newton, M.A., Kendziorski, C. (2022). SpatialCorr: Identifying gene sets with spatially varying correlation structure. *Cell Reports Methods*.](https://doi.org/10.1016/j.crmeth.2022.100369)

## Installation

To install SpatialCorr using Pip, run the following command:

`pip install spatialcorr`

## Usage

#### Documentation

For SpatialCorr's API manual, please visit the [documentation](https://spatialcorr.readthedocs.io/en/latest/index.html).

#### Tutorial

For a tutorial on running SpatialCorr, please see the [tutorial](https://github.com/mbernste/spatialcorr/blob/main/tutorial/SpatialCorr_tutorial.ipynb). This tutorial can also be run via [Google Colab](https://colab.research.google.com/drive/199gpNyyM6Jj8k9LLn1d71l_pX16yko60?usp=sharing).
