# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_ssot_aristacv',
 'nautobot_ssot_aristacv.api',
 'nautobot_ssot_aristacv.diffsync',
 'nautobot_ssot_aristacv.diffsync.fromcv',
 'nautobot_ssot_aristacv.diffsync.tocv',
 'nautobot_ssot_aristacv.migrations',
 'nautobot_ssot_aristacv.tests']

package_data = \
{'': ['*'], 'nautobot_ssot_aristacv': ['static/nautobot_ssot_aristacv/*']}

install_requires = \
['cloudvision>=1.0.0,<2.0.0', 'diffsync>=1.3.0,<2.0.0', 'nautobot-ssot==1.0.0']

setup_kwargs = {
    'name': 'nautobot-ssot-aristacv',
    'version': '1.0.2',
    'description': 'Nautobot SSoT Arista CloudVision',
    'long_description': '# Nautobot to Arista CloudVision Sync\n\nA plugin for [Nautobot](https://github.com/nautobot/nautobot) that allows synchronization of data directly between CloudVision and Nautobot. It synchronizes user device tags from Nautobot into CloudVision while using devices and system tags from CloudVision to ensure device synchronization and populate device metadata.  Here is a table showing the data mappings when syncing from CloudVision.\n\n| CloudVision System Tags | Nautobot Device Custom Field |\n|-------------------------|------------------------------|\n| topology_network_type   | Topology Network Type        |\n| mlag                    | mlag                         |\n| mpls                    | mpls                         |\n| model                   | Device Platform*             |\n| systype                 | systype                      |\n| serialnumber            | Device Serial Number         |\n| pimbidir                | pimbidir                     |\n| sflow                   | sFlow                        |\n| eostrain                | EOS Train                    |\n| tapagg                  | TAP Aggregation              |\n| pim                     | pim                          |\n| bgp                     | bgp                          |\n| terminattr              | TerminAttr Version           |\n| ztp                     | ztp                          |\n| eos                     | EOS Version                  |\n| topology_type           | Topology Type                |\n> The model system tag is mapped to the device platform model in Nautobot.\n\nWhen syncing User tags from Nautobot to CloudVision the data mappings are as follows:\n\n| Nautobot | CloudVision |\n|----------|-------------|\n| Tags     | Device Tags |\n\n> This plugin is an extension of the [Nautobot Single Source of Truth (SSoT)](https://github.com/nautobot/nautobot-plugin-ssot) and you must have that plugin installed before installing this extension.\n\n## Screenshots\n\nThis screenshot shows the CloudVision to Nautobot home page. This contains a list of all the system tags from CloudVision and how they map to custom fields in Nautobot. This also displays current plugin configuration and sync history.\n\n![cv_to_naut](https://user-images.githubusercontent.com/38091261/124859726-03557800-df76-11eb-9622-af4c29ba8d40.PNG)\n\nThis screenshow shows the Nautobot to CloudVision home page. It also contains data mappings, plugin configuration and sync history.\n\n![naut_to_cv](https://user-images.githubusercontent.com/38091261/124859903-55969900-df76-11eb-87c4-64ca2616bffe.PNG)\n\n## Installation\n\nThe plugin is available as a Python package in pypi and can be installed with pip\n\n```shell\npip install nautobot_ssot_aristacv\n```\n\n> The plugin is compatible with Nautobot 1.0.0 and higher\n\nTo ensure Nautobot to Arista CloudVision Sync is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot_ssot_aristacv` package:\n\n```no-highlight\n# echo nautobot_ssot_aristacv >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `nautobot_configuration.py` and plugin settings need to be defined.\n\n```python\n# In your configuration.py\nPLUGINS = ["nautobot_ssot", "nautobot_ssot_aristacv"]\n\n# PLUGINS_CONFIG = {\n#   "nautobot_ssot" : {\n#     ADD YOUR SETTINGS HERE\n#   }\n#   "nautobot_ssot_aristacv": {\n#     "cvaas_token": "",\n#     "cvp_host": "",\n#     "cvp_user": "",\n#     "cvp_password": "",\n#     "insecure": "",\n#     "from_cloudvision_default_site": "",\n#     "from_cloudvision_default_device_role": "",\n#     "from_cloudvision_default_device_role_color": "",\n#     "from_cloudvision_default_device_status": "",\n#     "from_cloudvision_default_device_status_color": "",\n#     "delete_devices_on_sync": "",\n#     "apply_import_tag": ""\n#   }\n# }\n```\n\n> All plugin settings are defined in the picture above as an example. Only some will be needed as described below.\n\nUpon installation, this plugin creates the following custom fields in Nautobot:\n\n- `arista_bgp`\n- `arista_eos`\n- `arista_eostrain`\n- `arista_mlag`\n- `arista_mpls`\n- `arista_pim`\n- `arista_pimbidir`\n- `arista_sflow`\n- `arista_systype`\n- `arista_tapagg`\n- `arista_terminattr`\n- `arista_topology_network_type`\n- `arista_topology_type`\n- `arista_ztp`\n\n> While these contain the prefix "arista" in the custom field admin portal, when looking at them on a device the prefix is removed.\n\nOther custom fields may need to be created by the user. When a sync is ran and a system tag for a device in CloudVision is found without a corresponding custom field, the sync log will display a message. In order to have that data synced, a custom field must be created in the Admin UI using the given name in the message.\n\n![Custom_Fields_Arista](https://user-images.githubusercontent.com/38091261/133857343-94ee262c-87ca-4e64-a3b2-c3d410755098.PNG)\n\nThe plugin can connect to either on-premise or a cloud instance of CloudVision. To connect to an on-premise instance, you must set the following variables in the Nautobot configuration file.\n\n| Configuration Variable | Type    | Usage                                                                                            |\n|------------------------|---------|--------------------------------------------------------------------------------------------------|\n| cvp_host               | string  | Hostname or ip address of the onprem instance of CloudVision.                                    |\n| cvp_user               | string  | The username used to connect to the onprem instance of CloudVision.                              |\n| cvp_password           | string  | The password used by the user specified above.                                                   |\n| insecure               | boolean | If true, the plugin will download the certificate from CloudVision and trust it for gRPC calls.  |\n\nTo connect to a cloud instance of CloudVision you must set the following variable:\n\n| Configuration Variable | Type   | Usage                                                         | Default            |\n|------------------------|--------|---------------------------------------------------------------|--------------------|\n| cvaas_url              | string | URL used to connect to your CvaaS instance.                   | www.arista.io:443  |\n| cvaas_token            | string | Token to be used when connecting to CloudVision as a Service. | No default set     |\n\nWhen syncing from CloudVision, this plugin will create new Arista devices that do not exist in Nautobot. When creating new devices in Nautobot, a site, device role, device role color, device status, and device are required. You may define which values to use by configuring the following values in your nautobot config file. If you define a `default_device_role` and `default_device_status` that already exist, the default color value for both of those will be ignored as it will pull that information from Nautobot.\n\n| Configuration Variable                       | Type   | Usage                                                      | Default              |\n|----------------------------------------------|--------|------------------------------------------------------------|----------------------|\n| from_cloudvision_default_site                | string | Default site created when syncing new devices to Nautobot. | cloudvision_imported |\n| from_cloudvision_default_device_role         | string | Default role created when syncing new devices to Nautobot. | network              |\n| from_cloudvision_default_device_role_color   | string | Default role color used for default role.                  | ff0000               |\n| from_cloudvision_default_device_status       | string | Default status used when syncing new devices to Nautobot.  | cloudvision_imported |\n| from_cloudvision_default_device_status_color | string | Default status color used for default status.              | ff0000               |\n\n> When these variables are not defined in the plugin settings, the plugin will use the default values mentioned.\n\nWhen an Arista device exists in Nautobot but not in CloudVision, this plugin can either delete or leave the device in Nautobot. That behavior can be set with the following variable in the nautobot config file.\n\n| Configuration Variable           | Type    | Usage                                                                                                                                                              | Default |\n|----------------------------------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|\n| delete_devices_on_sync | boolean | If true, devices in Nautobot with device type manufacturer name set to Arista that do not exist in CloudVision but do exist in Nautobot upon sync will be deleted. | False   |\n\n> When this variable is not defined in the plugin settings, the plugin will default to using `False`.\n\nLastly, an import tag with the name `cloudvision_imported` can be applied to devices that are imported from CloudVision.\n\n| Configuration Variable                       | Type    | Usage                                                      | Default              |\n|----------------------------------------------|---------|------------------------------------------------------------|----------------------|\n| apply_import_tag                             | boolean | Apply import tag to devices imported from CloudVision.     | False                |\n\n> If apply_import_tag is set to True, the tag value that is applied to devices is `cloudvision_imported`.\n\n## Usage\n\nThis extension can sync data both `to` and `from` Nautobot. Once the plugin has been installed succesfully two new options are available under the [Nautobot Single Source of Truth (SSoT)](https://github.com/nautobot/nautobot-plugin-ssot) plugin.\n\n![Arista Extension](https://user-images.githubusercontent.com/38091261/124857275-9a6c0100-df71-11eb-8ace-2ddf67a2471f.PNG)\n\n### Syncing From CloudVision\n\n> When loading Nautobot data, this tool only loads devices with a device type that has a manufacturer of "Arista"\n\nWhen syncing data from CloudVision to Nautobot, system tags as well as devices are synced.  When a device exists in CloudVision that doesn\'t exist in Nautobot, this tool creates the device in Nautobot with the default values specified in the configuration file.\nWhen a device exists in Nautobot that does not exist in CloudVision, this tool can be configured to either delete or skip that device.\nYou can watch the below video for an example.\n\n![fromcv_sync](https://user-images.githubusercontent.com/38091261/126499331-e41946c4-4e61-4b5e-8b7f-73efb9cd8d3f.gif)\n\nWhen syncing data from Nautobot to CloudVision, the tag data in Nautobot is copied into User Tags in CloudVision. You can watch the video below for an example.\n\n![tocv_sync](https://user-images.githubusercontent.com/38091261/126499484-2e4c4feb-0492-4dc6-abb6-a092701c81ed.gif)\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### Development Environment\n\nThe development environment can be used in 2 ways. First, with a local poetry environment if you wish to develop outside of Docker. Second, inside of a docker container.\n\n#### Invoke tasks\n\nThe [PyInvoke](http://www.pyinvoke.org/) library is used to provide some helper commands based on the environment.  There are a few configuration parameters which can be passed to PyInvoke to override the default configuration:\n\n- `nautobot_ver`: the version of Nautobot to use as a base for any built docker containers (default: develop-latest)\n- `project_name`: the default docker compose project name (default: aristacv-sync)\n- `python_ver`: the version of Python to use as a base for any built docker containers (default: 3.6)\n- `local`: a boolean flag indicating if invoke tasks should be run on the host or inside the docker containers (default: False, commands will be run in docker containers)\n- `compose_dir`: the full path to a directory containing the project compose files\n- `compose_files`: a list of compose files applied in order (see [Multiple Compose files](https://docs.docker.com/compose/extends/#multiple-compose-files) for more information)\n\nUsing PyInvoke these configuration options can be overridden using [several methods](http://docs.pyinvoke.org/en/stable/concepts/configuration.html).  Perhaps the simplest is simply setting an environment variable `INVOKE_ARISTACV-SYNC_VARIABLE_NAME` where `VARIABLE_NAME` is the variable you are trying to override.  The only exception is `compose_files`, because it is a list it must be overridden in a yaml file.  There is an example `invoke.yml` in this directory which can be used as a starting point.\n\n#### Local Poetry Development Environment\n\n1. Copy `development/creds.example.env` to `development/creds.env` (This file will be ignored by git and docker)\n2. Uncomment the `POSTGRES_HOST`, `REDIS_HOST`, and `NAUTOBOT_ROOT` variables in `development/creds.env`\n3. Create an invoke.yml with the following contents at the root of the repo:\n\n```shell\n---\naristacv_sync:\n  local: true\n  compose_files:\n    - "docker-compose.requirements.yml"\n```\n\n4. Run the following commands:\n\n```shell\npoetry shell\npoetry install\nexport $(cat development/dev.env | xargs)\nexport $(cat development/creds.env | xargs)\n```\n\n5. You can now run nautobot-server commands as you would from the [Nautobot documentation](https://nautobot.readthedocs.io/en/latest/) for example to start the development server:\n\n```shell\nnautobot-server runserver 0.0.0.0:8080 --insecure\n```\n\nNautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).\n\n#### Docker Development Environment\n\nThis project is managed by [Python Poetry](https://python-poetry.org/) and has a few requirements to setup your development environment:\n\n1. Install Poetry, see the [Poetry Documentation](https://python-poetry.org/docs/#installation) for your operating system.\n2. Install Docker, see the [Docker documentation](https://docs.docker.com/get-docker/) for your operating system.\n\nOnce you have Poetry and Docker installed you can run the following commands to install all other development dependencies in an isolated python virtual environment:\n\n```shell\npoetry shell\npoetry install\ninvoke start\n```\n\nNautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`.\n\nEach command can be executed with `invoke <command>`. Environment variables `INVOKE_ARISTACV-SYNC_PYTHON_VER` and `INVOKE_ARISTACV-SYNC_NAUTOBOT_VER` may be specified to override the default versions. Each command also has its own help `invoke <command> --help`\n\n#### Docker dev environment\n\n```no-highlight\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  restart          Restart Nautobot and its dependencies.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility\n\n```no-highlight\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n\n#### Testing\n\n```no-highlight\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  flake8           This will run flake8 for the specified name and Python version.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint           Run pylint code analysis.\n  tests            Run all tests for this plugin.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).\nSign up [here](http://slack.networktocode.com/)\n',
    'author': 'Network to Code, LLC',
    'author_email': 'info@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nautobot/nautobot-plugin-ssot-aristacv',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
