<div
<p align="center">
  <em>👷‍♀️ <b>Under Construction</b> 👷</em>
  <img src="https://raw.githubusercontent.com/datajoint/pharus/master/under_contruction.png" alt="construction_fig"/>
</p>
</div>

> ⚠️ The Pharus project is still early in its life and the maintainers are currently actively developing with a priority of addressing first critical issues directly related to the deliveries of [Alpha](https://github.com/datajoint/pharus/milestone/1) and [Beta](https://github.com/datajoint/pharus/milestone/2) milestones. Please be advised that while working through our milestones, we may restructure/refactor the codebase without warning until we issue our [Official Release](https://github.com/datajoint/pharus/milestone/3) currently planned as `0.1.0` on `2021-03-31`.

# Pharus

A generic REST API server backend for DataJoint pipelines built on top of `flask`, `datajoint`, and `pyjwt`.

Usage and API documentation currently available within method docstrings. See Python's `help(...)` utility.

## Requirements for Preferred Setup

- [Docker](https://docs.docker.com/get-docker/  )
- [Docker Compose](https://docs.docker.com/compose/install/)

## Run Locally w/ Docker

- Copy a `*-docker-compose.yaml` file corresponding to your usage to `docker-compose.yaml`. This file is untracked so feel free to modify as necessary.
- Check the first comment which will provide best instruction on how to start the service.

> ⚠️ Deployment options currently being considered are [Docker Compose](https://docs.docker.com/compose/install/) and [Kubernetes](https://kubernetes.io/docs/tutorials/kubernetes-basics/).

## Run Locally w/ Python

- Set environment variables for port assignment (`PHARUS_PORT`, defaults to 5000) and API route prefix (`PHARUS_PREFIX` e.g. `/api`, defaults to empty string).
- For development, use CLI command `pharus`. This method supports hot-reloading so probably best coupled with `pip install -e ...`.
- For production, use `gunicorn --bind 0.0.0.0:${PHARUS_PORT} pharus.server:app`.

## Run Tests for Development w/ Docker

- Create a `.env` as appropriate for your setup:
  ```shell
  PY_VER=3.8    # Python version: 3.6|3.7|3.8
  IMAGE=djtest  # Image type:     djbase|djtest|djlab|djlabhub
  DISTRO=alpine # Distribution:   alpine|debian
  AS_SCRIPT=    # If 'TRUE', will not keep container alive but run tests and exit
  ```
- Navigate to `test-docker-compose.yaml` and check first comment which will provide best instruction on how to start the service. Yes, the command is a bit long...

## Run Tests for Development w/ Pytest and Flake8

- Set `pharus` testing environment variables:
  ```shell
  PKG_DIR=/opt/conda/lib/python3.8/site-packages/pharus # path to pharus installation
  TEST_DB_SERVER=example.com:3306 # testing db server address
  TEST_DB_USER=root # testing db server user (needs CRUD on schemas, tables, users)
  TEST_DB_PASS=unsecure # testing db server password
  ```
- For syntax tests, run `flake8 ${PKG_DIR} --count --select=E9,F63,F7,F82 --show-source --statistics`
- For pytest integration tests, run `pytest -sv --cov-report term-missing --cov=${PKG_DIR} /main/tests`
- For style tests, run `flake8 ${PKG_DIR} --count --max-complexity=20 --max-line-length=95 --statistics`

## References

- DataJoint LabBook (a companion frontend)
  - https://github.com/datajoint/datajoint-labbook
- Under construction image credits
  - https://www.pngfind.com/mpng/ooiim_under-construction-tape-png-under-construction-transparent-png/
