"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
class CloudFrontToMediaStore extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: core_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${core_1.Aws.PARTITION}:mediastore:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:container/${core_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    StringEquals: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                                    },
                                    Bool: {
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        [this.cloudFrontWebDistribution, this.cloudFrontLoggingBucket, this.cloudFrontOriginRequestPolicy, this.cloudFrontFunction]
            = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders);
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "1.117.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQWdCQSwyREFBMkQ7QUFDM0Qsd0NBQThDO0FBYzlDLE1BQWEsc0JBQXVCLFNBQVEsZ0JBQVM7Ozs7Ozs7OztJQVNuRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWtDO1FBQzFFLEtBQUssQ0FBRSxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDbEIsUUFBUSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUUzQixJQUFJLDJCQUEyQixHQUFHLEtBQUssQ0FBQywyQkFBMkIsQ0FBQztRQUVwRSxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsRUFBRTtZQUN4QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLDhCQUE4QixDQUFDO1NBQ2pFO2FBQU07WUFDTCxJQUFJLGVBQTZDLENBQUM7WUFFbEQsSUFBSSxLQUFLLENBQUMsd0JBQXdCLEVBQUU7Z0JBQ2xDLGVBQWUsR0FBRyxLQUFLLENBQUMsd0JBQXdCLENBQUM7YUFDbEQ7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLDhCQUE4QixHQUFHLFFBQVEsQ0FBQyw4QkFBOEIsQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFFcEYsZUFBZSxHQUFHO29CQUNoQixhQUFhLEVBQUUsVUFBRyxDQUFDLFVBQVU7b0JBQzdCLE1BQU0sRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO3dCQUNyQixPQUFPLEVBQUUsWUFBWTt3QkFDckIsU0FBUyxFQUFFLENBQUM7Z0NBQ1YsR0FBRyxFQUFFLHlCQUF5QjtnQ0FDOUIsTUFBTSxFQUFFLE9BQU87Z0NBQ2YsU0FBUyxFQUFFLEdBQUc7Z0NBQ2QsTUFBTSxFQUFFO29DQUNOLHNCQUFzQjtvQ0FDdEIsMkJBQTJCO2lDQUM1QjtnQ0FDRCxRQUFRLEVBQUUsT0FBTyxVQUFHLENBQUMsU0FBUyxlQUFlLFVBQUcsQ0FBQyxNQUFNLElBQUksVUFBRyxDQUFDLFVBQVUsY0FBYyxVQUFHLENBQUMsVUFBVSxJQUFJO2dDQUN6RyxTQUFTLEVBQUU7b0NBQ1QsWUFBWSxFQUFFO3dDQUNaLGVBQWUsRUFBRSxJQUFJLENBQUMsOEJBQThCLENBQUMsd0JBQXdCO3FDQUM5RTtvQ0FDRCxJQUFJLEVBQUU7d0NBQ0oscUJBQXFCLEVBQUUsTUFBTTtxQ0FDOUI7aUNBQ0Y7NkJBQ0YsQ0FBQztxQkFDSCxDQUFDO2lCQUNILENBQUM7Z0JBRUYsTUFBTSxlQUFlLEdBQTJCO29CQUM5QyxZQUFZLEVBQUUsSUFBSSxDQUFDLDhCQUE4QixDQUFDLHdCQUF3QjtpQkFDM0UsQ0FBQztnQkFFRixJQUFJLDJCQUEyQixFQUFFO29CQUMvQiwyQkFBMkIsQ0FBQyxhQUFhLEdBQUcsZUFBZSxDQUFDO2lCQUM3RDtxQkFBTTtvQkFDTCwyQkFBMkIsR0FBRzt3QkFDNUIsYUFBYSxFQUFFLGVBQWU7cUJBQy9CLENBQUM7aUJBQ0g7YUFDRjtZQUVELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxRQUFRLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLGVBQWUsQ0FBQyxDQUFDO1NBQ2hGO1FBRUQsQ0FBQyxJQUFJLENBQUMseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QixFQUFFLElBQUksQ0FBQyw2QkFBNkIsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUM7Y0FDdkgsUUFBUSxDQUFDLG1DQUFtQyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsMkJBQTJCLEVBQUUsS0FBSyxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDakosQ0FBQzs7QUFwRUgsd0RBcUVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjEgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCAqIGFzIG1lZGlhc3RvcmUgZnJvbSAnQGF3cy1jZGsvYXdzLW1lZGlhc3RvcmUnO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCAqIGFzIGRlZmF1bHRzIGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIEF3c30gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBDbG91ZEZyb250VG9NZWRpYVN0b3JlUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZXhpc3RpbmdNZWRpYVN0b3JlQ29udGFpbmVyT2JqPzogbWVkaWFzdG9yZS5DZm5Db250YWluZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1lZGlhU3RvcmVDb250YWluZXJQcm9wcz86IG1lZGlhc3RvcmUuQ2ZuQ29udGFpbmVyUHJvcHM7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNsb3VkRnJvbnREaXN0cmlidXRpb25Qcm9wcz86IGNsb3VkZnJvbnQuRGlzdHJpYnV0aW9uUHJvcHMgfCBhbnk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGluc2VydEh0dHBTZWN1cml0eUhlYWRlcnM/OiBib29sZWFuO1xufVxuXG5leHBvcnQgY2xhc3MgQ2xvdWRGcm9udFRvTWVkaWFTdG9yZSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBjbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uOiBjbG91ZGZyb250LkRpc3RyaWJ1dGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IG1lZGlhU3RvcmVDb250YWluZXI6IG1lZGlhc3RvcmUuQ2ZuQ29udGFpbmVyO1xuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWRGcm9udExvZ2dpbmdCdWNrZXQ6IHMzLkJ1Y2tldDtcbiAgcHVibGljIHJlYWRvbmx5IGNsb3VkRnJvbnRPcmlnaW5SZXF1ZXN0UG9saWN5OiBjbG91ZGZyb250Lk9yaWdpblJlcXVlc3RQb2xpY3k7XG4gIHB1YmxpYyByZWFkb25seSBjbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHk/OiBjbG91ZGZyb250Lk9yaWdpbkFjY2Vzc0lkZW50aXR5O1xuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWRGcm9udEZ1bmN0aW9uPzogY2xvdWRmcm9udC5GdW5jdGlvbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENsb3VkRnJvbnRUb01lZGlhU3RvcmVQcm9wcykge1xuICAgIHN1cGVyIChzY29wZSwgaWQpO1xuICAgIGRlZmF1bHRzLkNoZWNrUHJvcHMocHJvcHMpO1xuXG4gICAgbGV0IGNsb3VkRnJvbnREaXN0cmlidXRpb25Qcm9wcyA9IHByb3BzLmNsb3VkRnJvbnREaXN0cmlidXRpb25Qcm9wcztcblxuICAgIGlmIChwcm9wcy5leGlzdGluZ01lZGlhU3RvcmVDb250YWluZXJPYmopIHtcbiAgICAgIHRoaXMubWVkaWFTdG9yZUNvbnRhaW5lciA9IHByb3BzLmV4aXN0aW5nTWVkaWFTdG9yZUNvbnRhaW5lck9iajtcbiAgICB9IGVsc2Uge1xuICAgICAgbGV0IG1lZGlhU3RvcmVQcm9wczogbWVkaWFzdG9yZS5DZm5Db250YWluZXJQcm9wcztcblxuICAgICAgaWYgKHByb3BzLm1lZGlhU3RvcmVDb250YWluZXJQcm9wcykge1xuICAgICAgICBtZWRpYVN0b3JlUHJvcHMgPSBwcm9wcy5tZWRpYVN0b3JlQ29udGFpbmVyUHJvcHM7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLmNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eSA9IGRlZmF1bHRzLkNsb3VkRnJvbnRPcmlnaW5BY2Nlc3NJZGVudGl0eSh0aGlzKTtcblxuICAgICAgICBtZWRpYVN0b3JlUHJvcHMgPSB7XG4gICAgICAgICAgY29udGFpbmVyTmFtZTogQXdzLlNUQUNLX05BTUUsXG4gICAgICAgICAgcG9saWN5OiBKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgICAgICBWZXJzaW9uOiAnMjAxMi0xMC0xNycsXG4gICAgICAgICAgICBTdGF0ZW1lbnQ6IFt7XG4gICAgICAgICAgICAgIFNpZDogJ01lZGlhU3RvcmVEZWZhdWx0UG9saWN5JyxcbiAgICAgICAgICAgICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgICAgICAgICAgICBQcmluY2lwYWw6ICcqJyxcbiAgICAgICAgICAgICAgQWN0aW9uOiBbXG4gICAgICAgICAgICAgICAgJ21lZGlhc3RvcmU6R2V0T2JqZWN0JyxcbiAgICAgICAgICAgICAgICAnbWVkaWFzdG9yZTpEZXNjcmliZU9iamVjdCdcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgUmVzb3VyY2U6IGBhcm46JHtBd3MuUEFSVElUSU9OfTptZWRpYXN0b3JlOiR7QXdzLlJFR0lPTn06JHtBd3MuQUNDT1VOVF9JRH06Y29udGFpbmVyLyR7QXdzLlNUQUNLX05BTUV9LypgLFxuICAgICAgICAgICAgICBDb25kaXRpb246IHtcbiAgICAgICAgICAgICAgICBTdHJpbmdFcXVhbHM6IHtcbiAgICAgICAgICAgICAgICAgICdhd3M6VXNlckFnZW50JzogdGhpcy5jbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHkub3JpZ2luQWNjZXNzSWRlbnRpdHlOYW1lXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBCb29sOiB7XG4gICAgICAgICAgICAgICAgICAnYXdzOlNlY3VyZVRyYW5zcG9ydCc6ICd0cnVlJ1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfV1cbiAgICAgICAgICB9KVxuICAgICAgICB9O1xuXG4gICAgICAgIGNvbnN0IHVzZXJBZ2VudEhlYWRlcjogUmVjb3JkPHN0cmluZywgc3RyaW5nPiA9IHtcbiAgICAgICAgICAnVXNlci1BZ2VudCc6IHRoaXMuY2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5Lm9yaWdpbkFjY2Vzc0lkZW50aXR5TmFtZVxuICAgICAgICB9O1xuXG4gICAgICAgIGlmIChjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHMpIHtcbiAgICAgICAgICBjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHMuY3VzdG9tSGVhZGVycyA9IHVzZXJBZ2VudEhlYWRlcjtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHMgPSB7XG4gICAgICAgICAgICBjdXN0b21IZWFkZXJzOiB1c2VyQWdlbnRIZWFkZXJcbiAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIHRoaXMubWVkaWFTdG9yZUNvbnRhaW5lciA9IGRlZmF1bHRzLk1lZGlhU3RvcmVDb250YWluZXIodGhpcywgbWVkaWFTdG9yZVByb3BzKTtcbiAgICB9XG5cbiAgICBbdGhpcy5jbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uLCB0aGlzLmNsb3VkRnJvbnRMb2dnaW5nQnVja2V0LCB0aGlzLmNsb3VkRnJvbnRPcmlnaW5SZXF1ZXN0UG9saWN5LCB0aGlzLmNsb3VkRnJvbnRGdW5jdGlvbl1cbiAgICAgID0gZGVmYXVsdHMuQ2xvdWRGcm9udERpc3RyaWJ1dGlvbkZvck1lZGlhU3RvcmUodGhpcywgdGhpcy5tZWRpYVN0b3JlQ29udGFpbmVyLCBjbG91ZEZyb250RGlzdHJpYnV0aW9uUHJvcHMsIHByb3BzLmluc2VydEh0dHBTZWN1cml0eUhlYWRlcnMpO1xuICB9XG59XG4iXX0=