"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsRuleToKinesisStreams = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const aws_eventbridge_kinesisstreams_1 = require("@aws-solutions-constructs/aws-eventbridge-kinesisstreams");
class EventsRuleToKinesisStreams extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the EventsRuleToKinesisStreams class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {EventsRuleToKinesisStreamsProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new EventbridgeToKinesisStreams instead of EventsRuleToKinesisStreams)
        const wrappedConstruct = new aws_eventbridge_kinesisstreams_1.EventbridgeToKinesisStreams(this, `${id}W`, convertedProps);
        this.kinesisStream = wrappedConstruct.kinesisStream;
        this.eventsRule = wrappedConstruct.eventsRule;
        this.eventsRole = wrappedConstruct.eventsRole;
        this.cloudwatchAlarms = wrappedConstruct.cloudwatchAlarms;
        this.eventBus = wrappedConstruct.eventBus;
    }
}
exports.EventsRuleToKinesisStreams = EventsRuleToKinesisStreams;
_a = JSII_RTTI_SYMBOL_1;
EventsRuleToKinesisStreams[_a] = { fqn: "@aws-solutions-constructs/aws-events-rule-kinesisstreams.EventsRuleToKinesisStreams", version: "1.173.0" };
//# sourceMappingURL=data:application/json;base64,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