# ДАННЫЙ ПРИМЕР ПОСИМВОЛЬНО ВЫВОДИТ СТРОКУ:         #
# (нажимайте или удерживайте кнопки клавиатуры)     #
                                                    #
from pyiArduinoI2Ckeyboard import *                 #   Подключаем библиотеку для работы с клавиатурой I2C-flash.
kbd = pyiArduinoI2Ckeyboard(0x09,4,2)               #   Объявляем объект kbd для работы с функциями и методами библиотеки pyiArduinoI2Ckeyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                    #   Если объявить объект без указания адреса (pyiArduinoI2Ckeyboard kbd(false,4,2) ), то адрес будет найден автоматически.
kbd.setEncoding("abcd0123")                         # * Присваиваем символы всем кнопкам клавиатуры. По умолчанию кнопкам присвоены символы "12345678".
kbd.setEncoding(4,1,'f')                            # * Символ можно присвоить каждой кнопке по отдельности (присвоить 4 кнопке, в 1 ряду, символ 'f').
kbd.setEncoding(4,2,'\n')                           # * Символ можно присвоить каждой кнопке по отдельности (присвоить 4 кнопке, в 2 ряду, символ '\n' - перенос строки).
#  Определяем скорость повтора нажатой кнопки:      #
kbd.setDelay(1000)                                  # * Указываем что удержание кнопки наступает через 1000 мс после её нажатия. Допускаются значения от 100мс до 25'500мс (по умолчанию 500 мс).
kbd.setPeriod(10)                                   # * Указываем что при удержании кнопки, её символы должны повторться каждые 10 мс. Допускаются значения от 10мс до 2'550мс (по умолчанию 50 мс).
                                                    #
while True:                                         #
    #  Получаем и выводим символы с клавиатуры:     #
    if kbd.available():                             #   Если в буфере истории нажатий кнопок есть символы, то ...
        print(kbd.readChar())                       #   Выводим очередной символ из буфера истории нажатий кнопок.
                                                    #
#  ПРИМЕЧАНИЕ:                                      #
#  Задержка до удержания кнопки setDelay() и        #
#  скорость повтора setPeriod() сохраняются в       #
#  энергонезависимой памяти модуля клавиатуры.      #


