# ДАННЫЙ ПРИМЕР ОТОБРАЖАЕТ СОСТОЯНИЯ КЛАВИШ НА ИХ СВЕТОДИОДАХ:      #
# (нажимайте удерживайте и отпускайте кнопки клавиатуры)            #
                                                                    #
from pyiArduinoI2Ckeyboard import *                                 #   Подключаем библиотеку для работы с клавиатурой I2C-flash.
kbd = pyiArduinoI2Ckeyboard(0x09,4,2)                               #   Объявляем объект kbd для работы с функциями и методами библиотеки pyiArduinoI2Ckeyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                                    #   Если объявить объект без указания адреса (pyiArduinoI2Ckeyboard kbd(false,4,2) ), то адрес будет найден автоматически.
kbd.setEncoding(4,2,'d')                                            # * Присваиваем 4 кнопке в 2 ряду символ 'd'.
                                                                    #
while True:                                                         #
    #  Выполняем действия по изменению состояния клавиш:            #
    kbd.setLed(1,1, kbd.getKey(1,1,KEY_PUSHED  )   )                #   Включаем 1 светодиод 1 ряда если его кнопка нажимается.
    kbd.setLed(2,1, kbd.getKey(2,1,KEY_RELEASED)   )                #   Включаем 2 светодиод 1 ряда если его кнопка отпускается.
    kbd.setLed(3,1, kbd.getKey(3,1,KEY_CHANGED )   )                #   Включаем 3 светодиод 1 ряда если его кнопка нажимается или отпускается.
    kbd.setLed(4,1, kbd.getKey(4,1,KEY_STATE   )   )                #   Включаем 4 светодиод 1 ряда пока его кнопка нажата.
    kbd.setLed(1,2, kbd.getKey(1,2,KEY_TRIGGER )   )                #   Включаем 1 светодиод 2 ряда по состоянию его кнопки в режиме переключателя.
    kbd.setLed(2,2, kbd.getKey(2,2,KEY_HOLD_05 )>0 )                #   Включаем 2 светодиод 2 ряда если его кнопка удерживается дольше 0,5 сек.
    kbd.setLed(3,2, kbd.getKey(3,2,KEY_HOLD_05 )>1 )                #   Включаем 3 светодиод 2 ряда если его кнопка удерживается дольше 1,0 сек.
    kbd.setLed('d', kbd.getKey('d',KEY_HOLD_05 )>2 )                #   Включаем 4 светодиод 2 ряда если его кнопка удерживается дольше 1,5 сек.
                                                                    #
#  ПРИМЕЧАНИЕ:                                                      #
#  Так как функцией setEncoding(), в коде Setup(), 4 кнопке 2 ряда  #
#  был присвоен символ 'd', то обращаться к кнопке и её светодиоду  #
#  можно либо по номеру и ряду, либо по привоенному ей символу.     #
#                                                                   #
#  Функция getKey() вызванная с параметром KEY_HOLD_05 возвращает   #
#  время удержания кнопки в 1/2 долях секунд (число от 0 до 7):     #
#  0 - кнопка не удерживается или удерживается менее 1/2 секунды.   #
#  1...7 - кнопка удерживается 1...7 * 1/2 секунд.                  #
#  Более точное время удержания можно получить функцией getTime()   #
