# ДАННЫЙ ПРИМЕР ОТОБРАЖАЕТ СОСТОЯНИЯ ВСЕХ КЛАВИШ НА ИХ СВЕТОДИОДАХ:# * Строки со звёздочкой являются необязательными.
# (нажимайте кнопки клавиатуры)                                    #
                                                                   #
from pyiArduinoI2Ckeyboard import *                                #   Подключаем библиотеку для работы с клавиатурой I2C-flash.
kbd = pyiArduinoI2Ckeyboard(0x09,4,2)                              #   Объявляем объект kbd для работы с функциями и методами библиотеки pyiArduinoI2Ckeyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                                   #   Если объявить объект без указания адреса (pyiArduinoI2Ckeyboard kbd(false,4,2) ), то адрес будет найден автоматически.
                                                                   #
while True:                                                        #
    i = kbd.getKey(KEY_ALL, KEY_STATE)                             #   Получаем флаги текущих состояний всех кнопок в переменную i.
    kbd.setLed(LED_ALL, i)                                         #   Устанавливаем работу всех светодиодов в соответствии с флагами в переменной i.
                                                                   #
#  ПРИМЕЧАНИЕ:                                                     #
#  Данный пример включает светодиоды в соответствии с состоянием   #
#  их клавиш.                                                      #
#  Попробуйте изменить тип получаемых данных о состоянии кнопок со #
#  значения KEY_STATE на одно из ниже перечисленных:               #
#  KEY_PUSHED   - вернуть 1 только при «нажимании» на клавишу.     #
#  KEY_RELEASED - вернуть 1 только при «отпускании» клавиши.       #
#  KEY_CHANGED  - вернуть 1 и при «нажимании», и при «отпускании». #
#  KEY_STATE    - вернуть состояние кнопки (1-нажата, 0-отпущена). #
#  KEY_TRIGGER  - вернуть состояние переключателя кнопки.          #
#  KEY_HOLD_05  - вернуть дискретное время удержания кнопки.       #
#                 время возвращается числом полусекунд от 0 до 7.  #
#                 время в секундах = полученное число * 0,5 сек.   #
#  Работа со всеми типами описана в примере setLed_KeyState.       #
