# ДАННЫЙ ПРИМЕР РЕАГИРУЕТ НА ИЗМЕНИНИЕ СОСТОЯНИЯ КЛАВИШ КЛАВИАТУРЫ:#
# (нажимайте или удерживайте кнопки клавиатуры)                    #
                                                                    #
from pyiArduinoI2Ckeyboard import *                                 #   Подключаем библиотеку для работы с клавиатурой I2C-flash.
kbd = pyiArduinoI2Ckeyboard(0x09, 4, 2, NO_BEGIN)                                 #   Объявляем объект kbd для работы с функциями и методами библиотеки pyiArduinoI2Ckeyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
from time import sleep
                                                                    #   Если объявить объект без указания адреса (pyiArduinoI2Ckeyboard kbd(false,4,2) ), то адрес будет найден автоматически.
sleep(.5)
while not kbd.begin():
    pass
                                                        #
while True:
#  Выполняем действия по изменению состояния любой клавиши:        #
    if kbd.getKey(KEY_ALL, KEY_CHANGED):                         #   Если изменилось состояние хотя бы одной кнопки, то ...
        i = kbd.getKey(KEY_ALL, KEY_STATE  )                            #   Получаем флаги текущего состояния кнопок.

        if(i):
            print("Нажаты кнопки: ", end='')        #   Выводим текст если установлен хотя бы 1 флаг.
        else:
            print("Все кнопки отпущены.")        #   Выводим текст если все флаги сброшены.

        if i & (1<<0): print("1,", end='')                          #   Если установлен 0 бит (флаг состояния 1 кнопки 1 ряда), то выводим текст.
        if i & (1<<1): print("2,", end='')                          #   Если установлен 1 бит (флаг состояния 2 кнопки 1 ряда), то выводим текст.
        if i & (1<<2): print("3,", end='')                          #   Если установлен 2 бит (флаг состояния 3 кнопки 1 ряда), то выводим текст.
        if i & (1<<3): print("4,", end='')                          #   Если установлен 3 бит (флаг состояния 4 кнопки 1 ряда), то выводим текст.
        if i & (1<<4): print("5,", end='')                          #   Если установлен 4 бит (флаг состояния 1 кнопки 2 ряда), то выводим текст.
        if i & (1<<5): print("6,", end='')                          #   Если установлен 5 бит (флаг состояния 2 кнопки 2 ряда), то выводим текст.
        if i & (1<<6): print("7,", end='')                          #   Если установлен 6 бит (флаг состояния 3 кнопки 2 ряда), то выводим текст.
        if i & (1<<7): print("8,", end='')                          #   Если установлен 7 бит (флаг состояния 4 кнопки 2 ряда), то выводим текст.
        print()                                        #
                                                                   #
#  ПРИМЕЧАНИЕ:                                                     #
#  Данный пример реагирует на событие KEY_CHANGED - изменилось     #
#  состояние любой клавиши клавиатуры.                             #
#  После чего считывает флаги состояния всех клавиш KEY_STATE в i. #
#  В примере не раскрыты следующие типы получаемых событий:        #
#  KEY_PUSHED   - реагировать только на «нажатие» клавиш.          #
#  KEY_RELEASED - реагировать только на «отпускание» клавиш.       #
#  KEY_TRIGGER  - вернуть состояние переключателя кнопки.          #
#  Попробуйте изменить KEY_STATE на любой из 3 перечисленных типов.#
#  В примере getKeyState показано как реагировать на состояния     #
#  не всех, а только указанных клавиш клавиатуры.                  #
