// ДАННЫЙ ПРИМЕР УПРАВЛЯЕТ ЯРКОСТЬЮ СВЕТОДИОДОВ:                    // * Строки со звёздочкой являются необязательными.
                                                                    //
#include "../iarduino_I2C_Keyboard.h"                                  //   Подключаем библиотеку для работы с клавиатурой I2C-flash.
#include "Serial.h"
iarduino_I2C_Keyboard kbd(0x09,4,2);                                //   Объявляем объект kbd для работы с функциями и методами библиотеки iarduino_I2C_Keyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                                    //   Если объявить объект без указания адреса (iarduino_I2C_Keyboard kbd(false,4,2);), то адрес будет найден автоматически.
void setup(){                                                       //
    delay(500);                                                     // * Ждём завершение переходных процессов связанных с подачей питания.
    kbd.begin();                                                    //   Инициируем работу с клавиатурой.
    kbd.setLight( 7 );                                              //   Устанавливаем максимальную яркость свечения светодиодов.
    kbd.setLed(KEY_ALL,0b11111111);                                 //   Включаем все светодиоды.
}                                                                   //
                                                                    //
void loop(){                                                        //
}                                                                   //
                                                                    //
//  ПРИМЕЧАНИЕ:                                                     //
//  Яркость светодиодов, устанавливаемая функцией setLight()        //
//  сохраняется в энергонезависимой памяти модуля клавиатуры.       //
//  Не используйте функию setLight() в циклах.                      //
int main()
{
	setup();
	for (;;) {
		loop();
	}
}
