// ДАННЫЙ ПРИМЕР УПРАВЛЯЕТ СВЕТОДИОДАМИ КНОПОК:                     // * Строки со звёздочкой являются необязательными.
                                                                    //
#include "../iarduino_I2C_Keyboard.h"                                  //   Подключаем библиотеку для работы с клавиатурой I2C-flash.
#include "Serial.h"
iarduino_I2C_Keyboard kbd(0x09,4,2);                                //   Объявляем объект kbd для работы с функциями и методами библиотеки iarduino_I2C_Keyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                                    //   Если объявить объект без указания адреса (iarduino_I2C_Keyboard kbd(false,4,2);), то адрес будет найден автоматически.
void setup(){                                                       //
    delay(500);                                                     // * Ждём завершение переходных процессов связанных с подачей питания.
    kbd.begin();                                                    //   Инициируем работу с клавиатурой.
    kbd.setEncoding(3,1,'s');                                       // * Присваиваем 3 кнопке в 1 ряду символ 's'.
}                                                                   //   (по умолчанию кнопкам присвоены символы "12345678").
                                                                    //
void loop(){                                                        //
//  Выполняем действия независимо от состояния клавиш:              //
    kbd.setLed(1,1,true);                        delay(500);        // Включаем светодиод 1 кнопки в 1 ряду.
    kbd.setLed(2,2,true); kbd.setLed(1,1,false); delay(500);        // Включаем светодиод 2 кнопки в 2 ряду и выключаем светодиод 1 кнопки в 1 ряду.
    kbd.setLed('s',true); kbd.setLed(2,2,false); delay(500);        // Включаем светодиод 3 кнопки в 1 ряду и выключаем светодиод 2 кнопки в 2 ряду.
    kbd.setLed(4,2,true); kbd.setLed(3,1,false); delay(500);        // Включаем светодиод 4 кнопки в 2 ряду и выключаем светодиод 3 кнопки в 1 ряду.
                          kbd.setLed(4,2,false); delay(500);        //                                        выключаем светодиод 4 кнопки в 2 ряду.
    kbd.setLed(LED_ALL,0b10100101);              delay(500);        // Управляем всеми светодиодами. Биты 0-3 управляют светодиодами 1-4 в 1 ряду, см. пример getAllKeyState.
    kbd.setLed(LED_ALL,0b01011010);              delay(500);        // Управляем всеми светодиодами. Биты 4-7 управляют светодиодами 1-4 в 2 ряду, см. пример getAllKeyState.
    kbd.setLed(LED_ALL,0b00000000);              delay(500);        // Выключаем все светодиоды.
    kbd.setLed(LED_ALL,0b11111111);              delay(500);        // Включаем  все светодиоды.
    kbd.setLed(LED_ALL,0b00000000);              delay(500);        // Выключаем все светодиоды.
}                                                                   //
                                                                    //
//  ПРИМЕЧАНИЕ:                                                     //
//  Так как функцией setEncoding(), в коде Setup(), 3 кнопке 1 ряда //
//  был присвоен символ 's', то обращаться к светодиоду этой кнопки //
//  можно либо по номеру и ряду, либо по привоенному ей символу.    //
int main()
{
	setup();
	for (;;) {
		loop();
	}
}
