// ДАННЫЙ ПРИМЕР ВЫВОДИТ СТРОКУ В МОНИТОР:           // * Строки со звёздочкой являются необязательными.
// (нажимайте кнопки и ждите их появления)           //
                                                     //
#include "../iarduino_I2C_Keyboard.h"                   //   Подключаем библиотеку для работы с клавиатурой I2C-flash.
#include "Serial.h"
iarduino_I2C_Keyboard kbd(0x09,4,2);                 //   Объявляем объект kbd для работы с функциями и методами библиотеки iarduino_I2C_Keyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                     //   Если объявить объект без указания адреса (iarduino_I2C_Keyboard kbd(false,4,2);), то адрес будет найден автоматически.
char myString[50];                                   //
                                                     //
void setup(){                                        //
    delay(500);                                      // * Ждём завершение переходных процессов связанных с подачей питания.
    Serial.begin(9600);                              //   Инициируем передачу данных по шине UART на скорости 9600 бит/сек.
    while(!Serial){;}                                // * Ждём завершения инициализации шины UART.
    kbd.begin();                                     //   Инициируем работу с клавиатурой.
    kbd.setEncoding("abcd012\n");                    // * Присваиваем символы всем кнопкам клавиатуры. По умолчанию кнопкам присвоены символы "12345678".
    kbd.setEncoding(4,1,'f');                        // * Символ можно присвоить каждой кнопке по отдельности (присвоить 4 кнопке, в 1 ряду, символ 'f').
}                                                    //
                                                     //
void loop(){                                         //
//  Получаем и выводим строку символов с клавиатуры: //
    if(kbd.available()){                             //   Если в буфере истории нажатий кнопок есть символы, то ...
       kbd.readString((uint8_t*)myString, sizeof(myString)-1); //   Читаем не более 49 символов из буфера истории нажатий кнопок в строку myString.
       Serial.print(myString);                       //   Выводим строку myString.
    }                                                //
//  Тут может быть код с большими задержками:        //
    delay(10000);                                    //   Пока Arduino "отдыхает", клавиатура мониторит нажатые клавиши и сохраняет их в свой буфер историй.
}                                                    //
                                                     //
//  ПРИМЕЧАНИЕ:                                      //
//  В качестве второго аргумента функции readString  //
//  указан размер строки myString - 1, т.к. функция  //
//  readString() по умолчанию добавляет к полученным //
//  данным символ конца строки.                      //
//                                                   //
//  Буфер историй нажатий кнопок находится в модуле  //
//  клавиатуры, память которого равна 255 байт.      //
//                                                   //
//  Функция available() возвращает количество        //
//  символов находящихся в буфере клавиатуры.        //
//  Буфер можно очистить функцией flush().           //
//                                                   //
//  В примере printChar данные из буфера читаются    //
//  не целой строкой, а посимвольно readChar().      //

int main()
{
	setup();
	for (;;) {
		loop();
	}
}
