// ДАННЫЙ ПРИМЕР РЕАГИРУЕТ НА НАЖАТИЕ КЛАВИШ КЛАВИАТУРЫ:            // * Строки со звёздочкой являются необязательными.
// (нажимайте кнопки клавиатуры)                                    //
                                                                    //
#include "Serial.h"
#include "../iarduino_I2C_Keyboard.h"                                  //   Подключаем библиотеку для работы с клавиатурой I2C-flash
iarduino_I2C_Keyboard kbd(0x09,4,2);                                //   Объявляем объект kbd для работы с функциями и методами библиотеки iarduino_I2C_Keyboard, указывая адрес модуля на шине I2C, количество кнопок в линии, количество линий с кнопками.
                                                                    //   Если объявить объект без указания адреса (iarduino_I2C_Keyboard kbd(false,4,2);), то адрес будет найден автоматически.
void setup(){                                                       //
    delay(500);                                                     // * Ждём завершение переходных процессов связанных с подачей питания.
    Serial.begin(9600);                                             //   Инициируем передачу данных по шине UART на скорости 9600 бит/сек.
    while(!Serial){;}                                               // * Ждём завершения инициализации шины UART.
    kbd.begin();                                                    //   Инициируем работу с клавиатурой.
    kbd.setEncoding(3,1,'f');                                       // * Присваиваем 3 кнопке в 1 ряду символ 'f'.
}                                                                   //   (по умолчанию кнопкам присвоены символы "12345678").
                                                                    //
void loop(){                                                        //
//  Выполняем действия по событию нажатия клавиши:                  //
    if(kbd.getKey(1,1,KEY_PUSHED  )){Serial.println("открыть"   );} //   Если 1 кнопка в 1 ряду нажимается, то выводим сообщение "открыть".
    if(kbd.getKey(2,1,KEY_PUSHED  )){Serial.println("включить"  );} //   Если 2 кнопка в 1 ряду нажимается, то выводим сообщение "включить".
    if(kbd.getKey('f',KEY_PUSHED  )){Serial.println("начать"    );} //   Если 3 кнопка в 1 ряду нажимается, то выводим сообщение "начать". К этой кнопке пожно обращаться не только по номеру и ряду, но и по символу присвоенному ей функцией setEncoding() в коде Setup().
    if(kbd.getKey(4,1,KEY_PUSHED  )){Serial.println("вперёд"    );} //   Если 4 кнопка в 1 ряду нажимается, то выводим сообщение "вперёд".
    if(kbd.getKey(1,2,KEY_PUSHED  )){Serial.println("закрыть"   );} //   Если 1 кнопка в 2 ряду нажимается, то выводим сообщение "закрыть".
    if(kbd.getKey(2,2,KEY_PUSHED  )){Serial.println("выключить" );} //   Если 2 кнопка в 2 ряду нажимается, то выводим сообщение "выключить".
    if(kbd.getKey(3,2,KEY_RELEASED)){Serial.println("остановить");} //   Эта строка кода реагирует не на нажатие 3 кнопки 2 ряда, а на её отпускание.
    if(kbd.getKey(4,2,KEY_PUSHED  )){Serial.println("назад"     );} //   Если 4 кнопка в 2 ряду нажимается, то выводим сообщение "назад".
}                                                                   //

int main() {
	setup();
	for (;;)
		loop();
}
                                                                    //
//  ПРИМЕЧАНИЕ:                                                     //
//  Данный пример реагирует на событие «нажатие» клавиш.            //
//  Если изменить тип получаемого события KEY_PUSHED на             //
//  KEY_RELEASED, то пример будет реагировать не на «нажатие», а    //
//  на «отпускание» клавиш (как это реализовано с 3 кнопкой 2 ряда).//
//  Есть еще несколько типов получаемых событий:                    //
//  KEY_CHANGED - реагировать и на «нажатие», и на «отпускание».    //
//  KEY_STATE   - вернуть состояние кнопки (1-нажата, 0-отпущена).  //
//  KEY_TRIGGER - вернуть состояние переключателя кнопки.           //
//  KEY_HOLD_05 - вернуть дискретное время удержания кнопки.        //
//                время возвращается числом полусекунд от 0 до 7.   //
//                время в секундах = полученное число * 0,5 сек.    //
//  Вместо номера кнопки в ряду и номера ряда, можно указать символ //
//  ранее присвоенный кнопке. По умолчанию кнопкам присвоены символы//
//  "1234" (для кнопок 1 ряда) и "5678" (для кнопок 2 ряда).        //
//  Если вместо символа кнопки указать KEY_ALL, то функция вернёт   //
//  число, каждый бит которого отвечает за состояние своей кнопки,  //
//  см. пример getAllKeyState.                                      //
