* [Skip to main content](#document-main)
* [Select language](#language)
* [Skip to search](#q)

[mozilla](//www.mozilla.org/) [Mozilla Developer Network](https://developer.mozilla.org/en-US/)

* [Web Technologies](https://developer.mozilla.org/en-US/docs/Web) Technologies
  - [HTML](https://developer.mozilla.org/en-US/docs/Web/HTML)
  - [CSS](https://developer.mozilla.org/en-US/docs/Web/CSS)
  - [JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
  - [Graphics](https://developer.mozilla.org/en-US/docs/Web/Guide/Graphics)
  - [HTTP](https://developer.mozilla.org/en-US/docs/Web/HTTP)
  - [APIs / DOM](https://developer.mozilla.org/en-US/docs/Web/API)
  - [WebExtensions](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions)
  - [MathML](https://developer.mozilla.org/en-US/docs/Web/MathML) References & Guides
  - [Learning web development](https://developer.mozilla.org/en-US/docs/Learn)
  - [Tutorials](https://developer.mozilla.org/en-US/docs/Web/Tutorials)
  - [References](https://developer.mozilla.org/en-US/docs/Web/Reference)
  - [Developer Guides](https://developer.mozilla.org/en-US/docs/Web/Guide)
  - [Accessibility](https://developer.mozilla.org/en-US/docs/Web/Accessibility)
  - [Game development](https://developer.mozilla.org/en-US/docs/Games)
  - [...more docs](https://developer.mozilla.org/en-US/docs/Web)
* [Mozilla Docs](https://developer.mozilla.org/en-US/docs/Zones)
  - [Add-ons](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons)
  - [Firefox](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox)
* [Developer Tools](https://developer.mozilla.org/en-US/docs/Tools)
* [Feedback](https://developer.mozilla.org/en-US/docs/MDN/Feedback)
  - [Get Firefox help](https://support.mozilla.org/)
  - [Get web development help](http://stackoverflow.com/)
  - [Join the MDN community](https://developer.mozilla.org/en-US/docs/MDN/Community)
  - [Report a content problem](https://bugzilla.mozilla.org/form.doc?bug_file_loc=https%3A//developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management)
  - [Report a bug](https://bugzilla.mozilla.org/form.mdn)

*
  - <bdi>[বাংলা (বাংলাদেশ) (bn-BD)](https://developer.mozilla.org/bn-BD/docs/Web/JavaScript/Memory_Management "Bengali (Bangladesh)")</bdi>
  - <bdi>[Deutsch (de)](https://developer.mozilla.org/de/docs/Web/JavaScript/Speicherverwaltung "German")</bdi>
  - <bdi>[Español (es)](https://developer.mozilla.org/es/docs/Web/JavaScript/Gestion_de_Memoria "Spanish")</bdi>
  - <bdi>[Français (fr)](https://developer.mozilla.org/fr/docs/Web/JavaScript/Gestion_de_la_m%C3%A9moire "French")</bdi>
  - <bdi>[Bahasa Indonesia (id)](https://developer.mozilla.org/id/docs/Web/JavaScript/Memory_Management "Indonesian")</bdi>
  - <bdi>[Italiano (it)](https://developer.mozilla.org/it/docs/Web/JavaScript/Gestione_della_Memoria "Italian")</bdi>
  - <bdi>[日本語 (ja)](https://developer.mozilla.org/ja/docs/Web/JavaScript/Memory_Management "Japanese")</bdi>
  - <bdi>[한국어 (ko)](https://developer.mozilla.org/ko/docs/Web/JavaScript/Memory_Management "Korean")</bdi>
  - <bdi>[Português (do Brasil) (pt-BR)](https://developer.mozilla.org/pt-BR/docs/Web/JavaScript/Memory_Management "Portuguese (Brazilian)")</bdi>
  - <bdi>[Русский (ru)](https://developer.mozilla.org/ru/docs/Web/JavaScript/Memory_Management "Russian")</bdi>
  - <bdi>[中文 (简体) (zh-CN)](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Memory_Management "Chinese (Simplified)")</bdi>
  - [Add a translation](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management$locales)
* [Edit](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management$edit)
* Advanced
  - [History](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management$history)
  - [Print this article](#)

1. [MDN](https://developer.mozilla.org/en-US)
2. [Web technology For developers](https://developer.mozilla.org/en-US/docs/Web)
3. [JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
4. Memory Management

Your Search Results

* [lleaff](https://developer.mozilla.org/en-US/profiles/lleaff "View profile: lleaff")
* [rudolfo](https://developer.mozilla.org/en-US/profiles/rudolfo "View profile: rudolfo")
* [beytek](https://developer.mozilla.org/en-US/profiles/beytek "View profile: beytek")
* [jontejada](https://developer.mozilla.org/en-US/profiles/jontejada "View profile: jontejada")
* [mbjordan](https://developer.mozilla.org/en-US/profiles/mbjordan "View profile: mbjordan")
* [ronyeh](https://developer.mozilla.org/en-US/profiles/ronyeh "View profile: ronyeh")
* [fscholz](https://developer.mozilla.org/en-US/profiles/fscholz "View profile: fscholz")
* [mishra](https://developer.mozilla.org/en-US/profiles/mishra "View profile: mishra")
* [macinnir](https://developer.mozilla.org/en-US/profiles/macinnir "View profile: macinnir")
* [RogerPoon](https://developer.mozilla.org/en-US/profiles/RogerPoon "View profile: RogerPoon")
* [xfq](https://developer.mozilla.org/en-US/profiles/xfq "View profile: xfq")
* [bigperm](https://developer.mozilla.org/en-US/profiles/bigperm "View profile: bigperm")
* [anirudh_venkatesh](https://developer.mozilla.org/en-US/profiles/anirudh_venkatesh "View profile: anirudh_venkatesh")
* [Agamemnus](https://developer.mozilla.org/en-US/profiles/Agamemnus "View profile: Agamemnus")
* [velvel53](https://developer.mozilla.org/en-US/profiles/velvel53 "View profile: velvel53")
* [hectorsan68](https://developer.mozilla.org/en-US/profiles/hectorsan68 "View profile: hectorsan68")
* [Nick_Pershin](https://developer.mozilla.org/en-US/profiles/Nick_Pershin "View profile: Nick_Pershin")
* [Sheppy](https://developer.mozilla.org/en-US/profiles/Sheppy "View profile: Sheppy")
* [RichardC](https://developer.mozilla.org/en-US/profiles/RichardC "View profile: RichardC")
* [ethertank](https://developer.mozilla.org/en-US/profiles/ethertank "View profile: ethertank")
* [maxatwork](https://developer.mozilla.org/en-US/profiles/maxatwork "View profile: maxatwork")
* [iskitz](https://developer.mozilla.org/en-US/profiles/iskitz "View profile: iskitz")
* [dbruant](https://developer.mozilla.org/en-US/profiles/dbruant "View profile: dbruant")

# Memory Management

## In This Article

1. [Introduction](#introduction)
2. [Memory life cycle](#memory-life-cycle)
  1. [Allocation in JavaScript](#allocation-in-javascript)
    1. [Value initialization](#value-initialization)
    2. [Allocation via function calls](#allocation-via-function-calls)
  2. [Using values](#using-values)
  3. [Release when the memory is not needed anymore](#release-when-the-memory-is-not-needed-anymore)
3. [Garbage collection](#garbage-collection)
  1. [References](#references)
  2. [Reference-counting garbage collection](#reference-counting-garbage-collection)
    1. [Example](#example)
    2. [Limitation: cycles](#limitation-cycles)
    3. [Real-life example](#real-life-example)
  3. [Mark-and-sweep algorithm](#mark-and-sweep-algorithm)
    1. [Cycles are not a problem anymore](#cycles-are-not-a-problem-anymore)
    2. [Limitation: objects need to be made explicitly unreachable](#limitation-objects-need-to-be-made-explicitly-unreachable)
4. [See also](#see-also)

## Introduction

Low-level languages, like C, have low-level memory management primitives like `malloc()` and `free()`. On the other hand, JavaScript values are allocated when things (objects, strings, etc.) are created and "automatically" freed when they are not used anymore. The latter process is called _garbage collection_. This "automatically" is a source of confusion and gives JavaScript (and high-level languages) developers the impression they can decide not to care about memory management. This is a mistake.

## Memory life cycle

Regardless of the programming language, memory life cycle is pretty much always the same:

1. Allocate the memory you need
2. Use the allocated memory (read, write)
3. Release the allocated memory when it is not needed anymore

The first and second parts are explicit in all languages. The last part is explicit in low-level languages, but is mostly implicit in high-level languages like JavaScript.

### Allocation in JavaScript

#### Value initialization

In order not to bother the programmer with allocations, JavaScript does it alongside with declaring values.

```js
var n = 123; // allocates memory for a number
var s = "azerty"; // allocates memory for a string
var o = {
  a: 1,
  b: null
}; // allocates memory for an object and contained values
// (like object) allocates memory for the array and
// contained values
var a = [1, null, "abra"];
function f(a){
  return a + 2;
} // allocates a function (which is a callable object)
// function expressions also allocate an object
someElement.addEventListener('click', function(){
  someElement.style.backgroundColor = 'blue';
}, false);
```

#### Allocation via function calls

Some function calls result in object allocation.

```js
var d = new Date(); // allocates a Date object
var e = document.createElement('div'); // allocates a DOM element
```

Some methods allocate new values or objects:

```js
var s = "azerty";
var s2 = s.substr(0, 3); // s2 is a new string
// Since strings are immutable value,
// JavaScript may decide to not allocate memory,
// but just store the [0, 3] range.
var a = ["ouais ouais", "nan nan"];
var a2 = ["generation", "nan nan"];
var a3 = a.concat(a2);
// new array with 4 elements being
// the concatenation of a and a2 elements
```

### Using values

Using value basically means reading and writing in allocated memory. This can be done by reading or writing the value of a variable or an object property or even passing an argument to a function.

### Release when the memory is not needed anymore

Most of memory management issues come at this phase. The hardest task here is to find when "the allocated memory is not needed any longer". It often requires for the developer to determine where in the program such piece of memory is not needed anymore and free it.

High-level languages embed a piece of software called "garbage collector" whose job is to track memory allocation and use in order to find when a piece of allocated memory is not needed any longer in which case, it will automatically free it. This process is an approximation since the general problem of knowing whether some piece of memory is needed is [undecidable](http://en.wikipedia.org/wiki/Decidability_%28logic%29) (can't be solved by an algorithm).

## Garbage collection

As stated above the general problem of automatically finding whether some memory "is not needed anymore" is undecidable. As a consequence, garbage collections implement a restriction of a solution to the general problem. This section will explain the necessary notions to understand the main garbage collection algorithms and their limitations.

### References

The main notion garbage collection algorithms rely on is the notion of _reference_. Within the context of memory management, an object is said to reference another object if the former has an access to the latter (either implicitly or explicitly). For instance, a JavaScript object has a reference to its [prototype](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Inheritance_and_the_prototype_chain) (implicit reference) and to its properties values (explicit reference).

In this context, the notion of "object" is extended to something broader than regular JavaScript objects and also contains function scopes (or the global lexical scope).

### Reference-counting garbage collection

This is the most naive garbage collection algorithm. This algorithm reduces the definition of "an object is not needed anymore" to "an object has no other object referencing to it". An object is considered garbage collectable if there is zero reference pointing at this object.

#### Example

```js
var o = {
  a: {
    b:2
  }
};
// 2 objects are created. One is referenced by the other as one of its properties.
// The other is referenced by virtue of being assigned to the 'o' variable.
// Obviously, none can be garbage-collected
var o2 = o; // the 'o2' variable is the second thing that
            // has a reference to the object
o = 1;      // now, the object that was originally in 'o' has a unique reference
            // embodied by the 'o2' variable
var oa = o2.a; // reference to 'a' property of the object.
               // This object has now 2 references: one as a property,
               // the other as the 'oa' variable
o2 = "yo"; // The object that was originally in 'o' has now zero
           // references to it. It can be garbage-collected.
           // However what was its 'a' property is still referenced by
           // the 'oa' variable, so it cannot be freed
oa = null; // what was the 'a' property of the object originally in o
           // has zero references to it. It can be garbage collected.
```

#### Limitation: cycles

There is a limitation when it comes to cycles. In the following example two objects are created and reference one another – thus creating a cycle. They will not get out of the function scope after the function call, so they are effectively useless and could be freed. However, the reference-counting algorithm considers that since each of both object is referenced at least once, none can be garbage-collected.

```js
function f(){
  var o = {};
  var o2 = {};
  o.a = o2; // o references o2
  o2.a = o; // o2 references o
  return "azerty";
}
f();
```

#### Real-life example

Internet Explorer 6 and 7 are known to have reference-counting garbage collectors for DOM objects. Cycles are a common mistake that can generate memory leaks:

```js
var div;
window.onload = function(){
  div = document.getElementById("myDivElement");
  div.circularReference = div;
  div.lotsOfData = new Array(10000).join("*");
};
```

In the above example, the DOM element "myDivElement" has a circular reference to itself in the "circularReference" property. If the property is not explicitly removed or nulled, a reference-counting garbage collector will always have at least one reference intact and will keep the DOM element in memory even if it was removed from the DOM tree. If the DOM element holds lots of data (illustrated in the above example with the "lotsOfData" property), the memory consumed by this data will never be released.

### Mark-and-sweep algorithm

This algorithm reduces the definition of "an object is not needed anymore" to "an object is unreachable".

This algorithm assumes the knowledge of a set of objects called _roots_ (In JavaScript, the root is the global object). Periodically, the garbage-collector will start from these roots, find all objects that are referenced from these roots, then all objects referenced from these, etc. Starting from the roots, the garbage collector will thus find all _reachable_ objects and collect all non-reachable objects.

This algorithm is better than the previous one since "an object has zero reference" leads to this object being unreachable. The opposite is not true as we have seen with cycles.

As of 2012, all modern browsers ship a mark-and-sweep garbage-collector. All improvements made in the field of JavaScript garbage collection (generational/incremental/concurrent/parallel garbage collection) over the last few years are implementation improvements of this algorithm, but not improvements over the garbage collection algorithm itself nor its reduction of the definition of when "an object is not needed anymore".

#### Cycles are not a problem anymore

In the first above example, after the function call returns, the 2 objects are not referenced anymore by something reachable from the global object. Consequently, they will be found unreachable by the garbage collector.

The same thing goes with the second example. Once the div and its handler are made unreachable from the roots, they can both be garbage-collected despite referencing each other.

#### Limitation: objects need to be made explicitly unreachable

Although this is marked as a limitation, it is one that is rarely reached in practice which is why no one usually cares that much about garbage collection.

## See also

* [IBM article on "Memory leak patterns in JavaScript" (2007)](http://www.ibm.com/developerworks/web/library/wa-memleak/)
* [Kangax article on how to register event handler and avoid memory leaks (2010)](http://msdn.microsoft.com/en-us/magazine/ff728624.aspx)
* [Performance](https://developer.mozilla.org/en-US/docs/Mozilla/Performance "https://developer.mozilla.org/en-US/docs/Mozilla/Performance")

## Document Tags and Contributors

**Tags:**

* [JavaScript](https://developer.mozilla.org/en-US/docs/tag/JavaScript)
* [memory](https://developer.mozilla.org/en-US/docs/tag/memory)
* [Performance](https://developer.mozilla.org/en-US/docs/tag/Performance)
* [performance](https://developer.mozilla.org/en-US/docs/tag/performance)

**Contributors to this page:** [lleaff](https://developer.mozilla.org/en-US/profiles/lleaff),
[rudolfo](https://developer.mozilla.org/en-US/profiles/rudolfo),
[beytek](https://developer.mozilla.org/en-US/profiles/beytek),
[jontejada](https://developer.mozilla.org/en-US/profiles/jontejada),
[mbjordan](https://developer.mozilla.org/en-US/profiles/mbjordan),
[ronyeh](https://developer.mozilla.org/en-US/profiles/ronyeh),
[fscholz](https://developer.mozilla.org/en-US/profiles/fscholz),
[mishra](https://developer.mozilla.org/en-US/profiles/mishra),
[macinnir](https://developer.mozilla.org/en-US/profiles/macinnir),
[RogerPoon](https://developer.mozilla.org/en-US/profiles/RogerPoon),
[xfq](https://developer.mozilla.org/en-US/profiles/xfq),
[bigperm](https://developer.mozilla.org/en-US/profiles/bigperm),
[anirudh_venkatesh](https://developer.mozilla.org/en-US/profiles/anirudh_venkatesh),
[Agamemnus](https://developer.mozilla.org/en-US/profiles/Agamemnus),
[velvel53](https://developer.mozilla.org/en-US/profiles/velvel53),
[hectorsan68](https://developer.mozilla.org/en-US/profiles/hectorsan68),
[Nick_Pershin](https://developer.mozilla.org/en-US/profiles/Nick_Pershin),
[Sheppy](https://developer.mozilla.org/en-US/profiles/Sheppy),
[RichardC](https://developer.mozilla.org/en-US/profiles/RichardC),
[ethertank](https://developer.mozilla.org/en-US/profiles/ethertank),
[maxatwork](https://developer.mozilla.org/en-US/profiles/maxatwork),
[iskitz](https://developer.mozilla.org/en-US/profiles/iskitz),
[dbruant](https://developer.mozilla.org/en-US/profiles/dbruant) **Last updated by:** [lleaff](https://developer.mozilla.org/en-US/profiles/lleaff),
<time>Aug 1, 2016, 1:06:43 PM</time> See also

1. [**_JavaScript_**](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
2. [**Tutorials:**](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Tutorials)
3. [JavaScript Guide](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide)
  1. [Introduction](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Introduction)
  2. [Grammar and types](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Grammar_and_Types)
  3. [Control flow and error handling](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Control_flow_and_error_handling)
  4. [Loops and iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Loops_and_iteration)
  5. [Functions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Functions)
  6. [Expressions and operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Expressions_and_Operators)
  7. [Numbers and dates](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Numbers_and_dates)
  8. [Text formatting](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Text_formatting)
  9. [Regular expressions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions)
  10. [Indexed collections](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Indexed_collections)
  11. [Keyed collections](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Keyed_collections)
  12. [Working with objects](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Working_with_Objects)
  13. [Details of the object model](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Details_of_the_Object_Model)
  14. [Iterators and generators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Iterators_and_generators)
  15. [Meta programming](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Meta_programming)
4. [Introductory](#)
  1. [JavaScript basics](https://developer.mozilla.org/en-US/Learn/Getting_started_with_the_web/JavaScript_basics)
  2. [JavaScript technologies overview](https://developer.mozilla.org/en-US/docs/Web/JavaScript/JavaScript_technologies_overview)
  3. [Introduction to Object Oriented JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Introduction_to_Object-Oriented_JavaScript)
5. [Intermediate](#)
  1. [A re-introduction to JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/A_re-introduction_to_JavaScript)
  2. [JavaScript data structures](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures)
  3. [Equality comparisons and sameness](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Equality_comparisons_and_sameness)
  4. [Closures](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Closures)
6. [Advanced](#)
  1. [Inheritance and the prototype chain](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Inheritance_and_the_prototype_chain)
  2. [Strict mode](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode)
  3. [JavaScript typed arrays](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Typed_arrays)
  4. [SIMD types](https://developer.mozilla.org/en-US/docs/Web/JavaScript/SIMD_types)
  5. [Memory Management](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Memory_Management)
  6. [Concurrency model and Event Loop](https://developer.mozilla.org/en-US/docs/Web/JavaScript/EventLoop)
7. **[References:](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference)**
8. [Built-in objects](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects)
  1. [Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array "The JavaScript Array object is a global object that is used in the construction of arrays; which are high-level, list-like objects.")
  2. [ArrayBuffer](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer "The ArrayBuffer object is used to represent a generic, fixed-length raw binary data buffer. You cannot directly manipulate the contents of an ArrayBuffer; instead, you create one of the typed array objects or a DataView object which represents the buffer in a specific format, and use that to read and write the contents of the buffer.")
  3. [Atomics](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Atomics "The Atomics object provides atomic operations as static methods. They are used with SharedArrayBuffer objects.")
  4. [Boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean "The Boolean object is an object wrapper for a boolean value.")
  5. [DataView](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DataView "The DataView view provides a low-level interface for reading and writing multiple number types in an ArrayBuffer irrespective of the platform's endianness.")
  6. [Date](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date "Creates a JavaScript Date instance that represents a single moment in time. Date objects are based on a time value that is the number of milliseconds since 1 January, 1970 UTC.")
  7. [Error](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error "The Error constructor creates an error object. Instances of Error objects are thrown when runtime errors occur. The Error object can also be used as a base object for user-defined exceptions. See below for standard built-in error types.")
  8. [EvalError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/EvalError "The EvalError object indicates an error regarding the global eval() function. This exception is not thrown by JavaScript anymore, however the EvalError object remains for compatibility.")
  9. [Float32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float32Array "The Float32Array typed array represents an array of 32-bit floating point numbers (corresponding to the C float data type) in the platform byte order. If control over byte order is needed, use DataView instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  10. [Float64Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64Array "The Float64Array typed array represents an array of 64-bit floating point numbers (corresponding to the C double data type) in the platform byte order. If control over byte order is needed, use DataView instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  11. [Function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function "The Function constructor creates a new Function object. In JavaScript every function is actually a Function object.")
  12. [Generator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Generator "The Generator object is returned by a generator function and it conforms to both the iterable protocol and the iterator protocol.")
  13. [GeneratorFunction](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/GeneratorFunction "The GeneratorFunction constructor creates a new generator function object. In JavaScript every generator function is actually a GeneratorFunction object.")
  14. [Infinity](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Infinity "The global Infinity property is a numeric value representing infinity.")
  15. [Int16Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int16Array "The Int16Array typed array represents an array of twos-complement 16-bit signed integers in the platform byte order. If control over byte order is needed, use DataView instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  16. [Int32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32Array "The Int32Array typed array represents an array of twos-complement 32-bit signed integers in the platform byte order. If control over byte order is needed, use DataView instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  17. [Int8Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int8Array "The Int8Array typed array represents an array of twos-complement 8-bit signed integers. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  18. [InternalError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/InternalError "The InternalError object indicates an error that occurred internally in the JavaScript engine. For example: "InternalError: too much recursion".")
  19. [Intl](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl "The Intl object is the namespace for the ECMAScript Internationalization API, which provides language sensitive string comparison, number formatting, and date and time formatting. The constructors for Collator, NumberFormat, and DateTimeFormat objects are properties of the Intl object. This page documents these properties as well as functionality common to the internationalization constructors and other language sensitive functions.")
  20. [Intl.Collator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Collator "The Intl.Collator object is a constructor for collators, objects that enable language sensitive string comparison.")
  21. [Intl.DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat "The Intl.DateTimeFormat object is a constructor for objects that enable language sensitive date and time formatting.")
  22. [Intl.NumberFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat "The Intl.NumberFormat object is a constructor for objects that enable language sensitive number formatting.")
  23. [Iterator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Iterator "The Iterator function returns an object which implements legacy iterator protocol and iterates over enumerable properties of an object.")
  24. [JSON](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON "The JSON object contains methods for parsing JavaScript Object Notation (JSON) and converting values to JSON. It can't be called or constructed, and aside from its two method properties it has no interesting functionality of its own.")
  25. [Map](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map "The Map object is a simple key/value map. Any value (both objects and primitive values) may be used as either a key or a value.")
  26. [Math](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math "Math is a built-in object that has properties and methods for mathematical constants and functions. Not a function object.")
  27. [NaN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NaN "The global NaN property is a value representing Not-A-Number.")
  28. [Number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number "The Number JavaScript object is a wrapper object allowing you to work with numerical values. A Number object is created using the Number() constructor.")
  29. [Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object "The Object constructor creates an object wrapper.")
  30. [ParallelArray](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ParallelArray "The goal of ParallelArray was to enable data-parallelism in web applications. The higher-order functions available on ParallelArray attempted to execute in parallel, though they may fall back to sequential execution if necessary. To ensure that your code executes in parallel, it is suggested that the functions should be limited to the parallelizable subset of JS that Firefox supports.")
  31. [Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise "The Promise object is used for asynchronous computations. A Promise represents an operation that hasn't completed yet, but is expected in the future.")
  32. [Proxy](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Proxy "The Proxy object is used to define custom behavior for fundamental operations (e.g. property lookup, assignment, enumeration, function invocation, etc).")
  33. [RangeError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RangeError "The RangeError object indicates an error when a value is not in the set or range of allowed values.")
  34. [ReferenceError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ReferenceError "The ReferenceError object represents an error when a non-existent variable is referenced.")
  35. [Reflect](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect "Reflect is a built-in object that provides methods for interceptable JavaScript operations. The methods are the same as those of proxy handlers. Reflect is not a function object, so it's not constructible.")
  36. [RegExp](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp "The RegExp constructor creates a regular expression object for matching text with a pattern.")
  37. [SIMD](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SIMD "SIMD (pronounced "sim-dee") is short for Single Instruction/Multiple Data which is one classification of computer architectures. SIMD operations perform the same computation on multiple data points resulting in data level parallelism and thus performance gains, for example for 3D graphics and video processing, physics simulations or cryptography, and other domains.")
  38. [SIMD.Bool16x8](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Bool16x8 "The SIMD.Bool16x8 data type is a 128-bit vector divided into 8 lanes storing boolean values.")
  39. [SIMD.Bool32x4](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Bool32x4 "The SIMD.Bool32x4 data type is a 128-bit vector divided into 4 lanes storing boolean values.")
  40. [SIMD.Bool64x2](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Bool64x2 "The SIMD.Bool64x2 data type is a 128-bit vector divided into 2 lanes storing boolean values.")
  41. [SIMD.Bool8x16](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Bool8x16 "The SIMD.Bool8x16 data type is a 128-bit vector divided into 16 lanes storing boolean values.")
  42. [SIMD.Float32x4](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float32x4 "The SIMD.Float32x4 data type is a 128-bit vector divided into 4 lanes storing single precision floating point values.")
  43. [SIMD.Float64x2](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64x2 "The SIMD.Float64x2 data type is a 128-bit vector divided into 2 lanes storing double precision floating point values.")
  44. [SIMD.Int16x8](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int16x8 "The SIMD.Int16x8 data type is a 128-bit vector divided into 8 lanes storing 16-bit signed integer values.")
  45. [SIMD.Int32x4](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32x4 "The SIMD.Int32x4 data type is a 128-bit vector divided into 4 lanes storing 32-bit signed integer values.")
  46. [SIMD.Int8x16](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int8x16 "The SIMD.Int8x16 data type is a 128-bit vector divided into 16 lanes storing 8-bit signed integer values.")
  47. [SIMD.Uint16x8](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint16x8 "The SIMD.Uint16x8 data type is a 128-bit vector divided into 8 lanes storing 16-bit unsigned integer values.")
  48. [SIMD.Uint32x4](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint32x4 "The SIMD.Uint32x4 data type is a 128-bit vector divided into 4 lanes storing 32-bit unsigned integer values.")
  49. [SIMD.Uint8x16](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint8x16 "The SIMD.Uint8x16 data type is a 128-bit vector divided into 16 lanes storing 8-bit unsigned integer values.")
  50. [Set](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set "The Set object lets you store unique values of any type, whether primitive values or object references.")
  51. [SharedArrayBuffer](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer "The SharedArrayBuffer object is used to represent a generic, fixed-length raw binary data buffer, similar to the ArrayBuffer object, but in a way that they can be used to create views on shared memory. Unlike an ArrayBuffer, a SharedArrayBuffer cannot become detached.")
  52. [StopIteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/StopIteration "The StopIteration object is used to tell the end of the iteration in the legacy iterator protocol.")
  53. [String](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String "The String global object is a constructor for strings, or a sequence of characters.")
  54. [Symbol](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol "A symbol is a unique and immutable data type and may be used as an identifier for object properties. The Symbol object is an implicit object wrapper for the symbol primitive data type.")
  55. [SyntaxError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SyntaxError "The SyntaxError object represents an error when trying to interpret syntactically invalid code.")
  56. [TypeError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypeError "The TypeError object represents an error when a value is not of the expected type.")
  57. [TypedArray](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray "A TypedArray object describes an array-like view of an underlying binary data buffer. There is no global property named TypedArray, nor is there a directly visible TypedArray constructor.  Instead, there are a number of different global properties, whose values are typed array constructors for specific element types, listed below. On the following pages you will find common properties and methods that can be used with any typed array containing elements of any type.")
  58. [URIError](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/URIError "The URIError object represents an error when a global URI handling function was used in a wrong way.")
  59. [Uint16Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint16Array "The Uint16Array typed array represents an array of 16-bit unsigned integers in the platform byte order. If control over byte order is needed, use DataView instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  60. [Uint32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint32Array "The Uint32Array typed array represents an array of 32-bit unsigned integers in the platform byte order. If control over byte order is needed, use DataView instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  61. [Uint8Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint8Array "The Uint8Array typed array represents an array of 8-bit unsigned integers. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  62. [Uint8ClampedArray](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Uint8ClampedArray "The Uint8ClampedArray typed array represents an array of 8-bit unsigned integers clamped to 0-255; if you specified a value that is out of the range of [0,255], 0 or 255 will be set instead. The contents are initialized to 0. Once established, you can reference elements in the array using the object's methods, or using standard array index syntax (that is, using bracket notation).")
  63. [WeakMap](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap "The WeakMap object is a collection of key/value pairs in which the keys are weakly referenced.  The keys must be objects and the values can be arbitrary values.")
  64. [WeakSet](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakSet "The WeakSet object lets you store weakly held objects in a collection.")
  65. [decodeURI()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURI "The decodeURI() function decodes a Uniform Resource Identifier (URI) previously created by encodeURI or by a similar routine.")
  66. [decodeURIComponent()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURIComponent "The decodeURIComponent() function decodes a Uniform Resource Identifier (URI) component previously created by encodeURIComponent or by a similar routine.")
  67. [encodeURI()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURI "The encodeURI() function encodes a Uniform Resource Identifier (URI) by replacing each instance of certain characters by one, two, three, or four escape sequences representing the UTF-8 encoding of the character (will only be four escape sequences for characters composed of two "surrogate" characters).")
  68. [encodeURIComponent()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent "The encodeURIComponent() function encodes a Uniform Resource Identifier (URI) component by replacing each instance of certain characters by one, two, three, or four escape sequences representing the UTF-8 encoding of the character (will only be four escape sequences for characters composed of two "surrogate" characters).")
  69. [escape()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/escape "The deprecated escape() function computes a new string in which certain characters have been replaced by a hexadecimal escape sequence. Use encodeURI or encodeURIComponent instead.")
  70. [eval()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/eval "The eval() function evaluates JavaScript code represented as a string.")
  71. [isFinite()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isFinite "The global isFinite() function determines whether the passed value is a finite number. If needed, the parameter is first converted to a number.")
  72. [isNaN()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isNaN "The isNaN() function determines whether a value is NaN or not. Note: coercion inside the isNaN function has interesting rules; you may alternatively want to use Number.isNaN(), as defined in ECMAScript 6, or you can use typeof to determine if the value is Not-A-Number.")
  73. [null](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/null "The value null represents the intentional absence of any object value. It is one of JavaScript's primitive values.")
  74. [parseFloat()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseFloat "The parseFloat() function parses a string argument and returns a floating point number.")
  75. [parseInt()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseInt "The parseInt() function parses a string argument and returns an integer of the specified radix (the base in mathematical numeral systems).")
  76. [undefined](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined "The global undefined property represents the primitive value undefined. It is one of JavaScript's primitive types.")
  77. [unescape()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/unescape "The deprecated unescape() function computes a new string in which hexadecimal escape sequences are replaced with the character that it represents. The escape sequences might be introduced by a function like escape. Because unescape is deprecated, use decodeURI or decodeURIComponent instead.")
  78. [uneval()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/uneval "The uneval() function creates a string representation of the source code of an Object.")
  79. [Array.from()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from "The Array.from() method creates a new Array instance from an array-like or iterable object.")
  80. [Array.isArray()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray "The Array.isArray() determines whether the passed value is an Array.")
  81. [Array.observe()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/observe "The Array.observe() method was used for asynchronously observing changes to Arrays, similar to Object.observe() for objects. It provided a stream of changes in order of occurrence. It's equivalent to Object.observe() invoked with the accept type list ["add", "update", "delete", "splice"]. However, this API has been deprecated and removed from Browsers. You can use the more general Proxy object instead.")
  82. [Array.of()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/of "The Array.of() method creates a new Array instance with a variable number of arguments, regardless of number or type of the arguments.")
  83. [Array.prototype](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/prototype "The Array.prototype property represents the prototype for the Array constructor.")
  84. [Array.prototype.concat()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/concat "The concat() method returns a new array comprised of the array on which it is called joined with the array(s) and/or value(s) provided as arguments.")
  85. [Array.prototype.copyWithin()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/copyWithin "The copyWithin() method shallow copies part of an array to another location in the same array and returns it, without modifying its size.")
  86. [Array.prototype.entries()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/entries "The entries() method returns a new Array Iterator object that contains the key/value pairs for each index in the array.")
  87. [Array.prototype.every()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/every "The every() method tests whether all elements in the array pass the test implemented by the provided function.")
  88. [Array.prototype.fill()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/fill "The fill() method fills all the elements of an array from a start index to an end index with a static value.")
  89. [Array.prototype.filter()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter "The filter() method creates a new array with all elements that pass the test implemented by the provided function.")
  90. [Array.prototype.find()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find "The find() method returns a value in the array, if an element in the array satisfies the provided testing function. Otherwise undefined is returned.")
  91. [Array.prototype.findIndex()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findIndex "The findIndex() method returns an index in the array, if an element in the array satisfies the provided testing function. Otherwise -1 is returned.")
  92. [Array.prototype.forEach()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach "The forEach() method executes a provided function once per array element.")
  93. [Array.prototype.includes()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes "The includes() method determines whether an array includes a certain element, returning true or false as appropriate.")
  94. [Array.prototype.indexOf()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf "The indexOf() method returns the first index at which a given element can be found in the array, or -1 if it is not present.")
  95. [Array.prototype.join()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/join "The join() method joins all elements of an array into a string.")
  96. [Array.prototype.keys()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/keys "The keys() method returns a new Array Iterator that contains the keys for each index in the array.")
  97. [Array.prototype.lastIndexOf()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/lastIndexOf "The lastIndexOf() method returns the last index at which a given element can be found in the array, or -1 if it is not present. The array is searched backwards, starting at fromIndex.")
  98. [Array.prototype.map()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map "The map() method creates a new array with the results of calling a provided function on every element in this array.")
  99. [Array.prototype.pop()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/pop "The pop() method removes the last element from an array and returns that element.")
  100. [Array.prototype.push()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/push "The push() method adds one or more elements to the end of an array and returns the new length of the array.")
  101. [Array.prototype.reduce()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/Reduce "The reduce() method applies a function against an accumulator and each value of the array (from left-to-right) to reduce it to a single value.")
  102. [Array.prototype.reduceRight()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/ReduceRight "The reduceRight() method applies a function against an accumulator and each value of the array (from right-to-left) has to reduce it to a single value.")
  103. [Array.prototype.reverse()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reverse "The reverse() method reverses an array in place. The first array element becomes the last and the last becomes the first.")
  104. [Array.prototype.shift()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/shift "The shift() method removes the first element from an array and returns that element. This method changes the length of the array.")
  105. [Array.prototype.slice()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/slice "The slice() method returns a shallow copy of a portion of an array into a new array object.")
  106. [Array.prototype.some()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some "The some() method tests whether some element in the array passes the test implemented by the provided function.")
  107. [Array.prototype.sort()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort "The sort() method sorts the elements of an array in place and returns the array. The sort is not necessarily stable. The default sort order is according to string Unicode code points.")
  108. [Array.prototype.splice()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice "The splice() method changes the content of an array by removing existing elements and/or adding new elements.")
  109. [Array.prototype.toLocaleString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/toLocaleString "The toLocaleString() method returns a string representing the elements of the array. The elements are converted to Strings using their toLocaleString methods and these Strings are separated by a locale-specific String (such as a comma ",").")
  110. [Array.prototype.toSource()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/toSource "The toSource() method returns a string representing the source code of the array.")
  111. [Array.prototype.toString()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/toString "The toString() method returns a string representing the specified array and its elements.")
  112. [Array.prototype.unshift()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/unshift "The unshift() method adds one or more elements to the beginning of an array and returns the new length of the array.")
  113. [Array.prototype.values()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/values "The values() method returns a new Array Iterator object that contains the values for each index in the array.")
  114. [Array.prototype[@@iterator]()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/@@iterator "The initial value of the @@iterator property is the same function object as the initial value of the values() property.")
  115. [Array.prototype[@@unscopables]](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/@@unscopables "The @@unscopable symbol property contains property names that were not included in the ECMAScript standard prior to the ES2015 (ES6) version. These properties are excluded from with statement bindings.")
  116. [Array.unobserve()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/unobserve "The Array.unobserve() method was used to remove observers set by Array.observe(), but has been deprecated and removed from Browsers. You can use the more general Proxy object instead.")
  117. [array.length](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/length "The length property represents an unsigned, 32-bit integer that is always numerically greater than the highest index in the array.")
  118. [get Array[@@species]](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/@@species "The Array[@@species] accessor property returns the Array constructor.")
9. [Expressions & operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators)
  1. [Arithmetic operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Arithmetic_Operators "Arithmetic operators take numerical values (either literals or variables) as their operands and return a single numerical value. The standard arithmetic operators are addition (+), subtraction (-), multiplication (*), and division (/).")
  2. [Array comprehensions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Array_comprehensions "The array comprehension syntax is a JavaScript expression which allows you to quickly assemble a new array based on an existing one. Comprehensions exist in many programming languages.")
  3. [Assignment operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Assignment_Operators "An assignment operator assigns a value to its left operand based on the value of its right operand.")
  4. [Bitwise operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Bitwise_Operators "Bitwise operators treat their operands as a sequence of 32 bits (zeroes and ones), rather than as decimal, hexadecimal, or octal numbers. For example, the decimal number nine has a binary representation of 1001. Bitwise operators perform their operations on such binary representations, but they return standard JavaScript numerical values.")
  5. [Comma operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Comma_Operator "The comma operator evaluates each of its operands (from left to right) and returns the value of the last operand.")
  6. [Comparison operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Comparison_Operators "JavaScript has both strict and type–converting comparisons. A strict comparison (e.g., ===) is only true if the operands are of the same type and the contents match. The more commonly-used abstract comparison (e.g. ==) converts the operands to the same type before making the comparison. For relational abstract comparisons (e.g., <=), the operands are first converted to primitives, then to the same type, before comparison.")
  7. [Conditional (ternary) Operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Conditional_Operator "The conditional (ternary) operator is the only JavaScript operator that takes three operands. This operator is frequently used as a shortcut for the if statement.")
  8. [Destructuring assignment](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment "The destructuring assignment syntax is a JavaScript expression that makes it possible to extract data from arrays or objects into distinct variables.")
  9. [Expression closures](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Expression_closures "Expression closures are a shorthand function syntax for writing simple functions.")
  10. [Generator comprehensions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Generator_comprehensions "The generator comprehension syntax is a JavaScript expression which allows you to quickly assemble a new generator function based on an existing iterable object. Comprehensions exist in many programming languages.")
  11. [Grouping operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Grouping "The grouping operator ( ) controls the precedence of evaluation in expressions.")
  12. [Legacy generator function expression](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Legacy_generator_function "The function keyword can be used to define a legacy generator function inside an expression. To make the function a legacy generator, the function body should contain at least one yield expression.")
  13. [Logical Operators](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_Operators "Logical operators are typically used with Boolean (logical) values. When they are, they return a Boolean value. However, the && and || operators actually return the value of one of the specified operands, so if these operators are used with non-Boolean values, they may return a non-Boolean value.")
  14. [Object initializer](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Object_initializer "Objects can be initialized using new Object(), Object.create(), or using the literal notation (initializer notation). An object initializer is a list of zero or more pairs of property names and associated values of an object, enclosed in curly braces ({}).")
  15. [Operator precedence](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_Precedence "Operator precedence determines the order in which operators are evaluated. Operators with higher precedence are evaluated first.")
  16. [Property accessors](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Property_Accessors "Property accessors provide access to an object's properties by using the dot notation or the bracket notation.")
  17. [Spread operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_operator "The spread operator allows an expression to be expanded in places where multiple arguments (for function calls) or multiple elements (for array literals) or multiple variables  (for destructuring assignment) are expected.")
  18. [class expression](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/class "The class expression is one way to define a class in ECMAScript 2015 (ES6). Similar to function expressions, class expressions can be named or unnamed. If named, the name of the class is local to the class body only. JavaScript classes are using prototype-based inheritance.")
  19. [delete operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/delete "The delete operator removes a property from an object.")
  20. [function expression](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/function "The function keyword can be used to define a function inside an expression.")
  21. [function* expression](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/function* "The function* keyword can be used to define a generator function inside an expression.")
  22. [in operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/in "The in operator returns true if the specified property is in the specified object.")
  23. [instanceof](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/instanceof "The instanceof operator tests whether an object has in its prototype chain the prototype property of a constructor.")
  24. [new operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new "The new operator creates an instance of a user-defined object type or of one of the built-in object types that has a constructor function.")
  25. [new.target](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new.target "The new.target property lets you detect whether a function or constructor was called using the new operator. In constructors and functions instantiated with the new operator, new.target returns a reference to the constructor or function. In normal function calls, new.target is undefined.")
  26. [super](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/super "The super keyword is used to call functions on an object's parent.")
  27. [this](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/this "A function's this keyword behaves a little differently in JavaScript compared to other languages. It also has some differences between strict mode and non-strict mode.")
  28. [typeof](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/typeof "The typeof operator returns a string indicating the type of the unevaluated operand.")
  29. [void operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/void "The void operator evaluates the given expression and then returns undefined.")
  30. [yield](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/yield "The yield keyword is used to pause and resume a generator function (function* or legacy generator function).")
  31. [yield*](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/yield* "The yield* expression is used to delegate to another generator or iterable object.")
10. [Statements & declarations](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements)
  1. [Legacy generator function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/Legacy_generator_function "The legacy generator function statement declares legacy generator functions with the specified parameters.")
  2. [block](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/block "A block statement (or compound statement in other languages) is used to group zero or more statements. The block is delimited by a pair of curly brackets.")
  3. [break](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/break "The break statement terminates the current loop, switch, or label statement and transfers program control to the statement following the terminated statement.")
  4. [class](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/class "The class declaration creates a new class with a given name using prototype-based inheritance.")
  5. [const](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const "The const declaration creates a read-only reference to a value. It does not mean the value it holds is immutable, just that the variable identifier cannot be reassigned.")
  6. [continue](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/continue "The continue statement terminates execution of the statements in the current iteration of the current or labeled loop, and continues execution of the loop with the next iteration.")
  7. [debugger](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/debugger "The debugger statement invokes any available debugging functionality, such as setting a breakpoint. If no debugging functionality is available, this statement has no effect.")
  8. [default](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/default "Technical review completed.")
  9. [do...while](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/do...while "The do...while statement creates a loop that executes a specified statement until the test condition evaluates to false. The condition is evaluated after executing the statement, resulting in the specified statement executing at least once.")
  10. [empty](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/Empty "An empty statement is used to provide no statement, although the JavaScript syntax would expect one.")
  11. [export](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/export "The export statement is used to export functions, objects or primitives from a given file (or module).")
  12. [for](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for "The for statement creates a loop that consists of three optional expressions, enclosed in parentheses and separated by semicolons, followed by a statement or a set of statements executed in the loop.")
  13. [for each...in](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for_each...in "The for each...in statement iterates a specified variable over all values of object's properties. For each distinct property, a specified statement is executed.")
  14. [for...in](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for...in "The for...in statement iterates over the enumerable properties of an object, in arbitrary order. For each distinct property, statements can be executed.")
  15. [for...of](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for...of "The for...of statement creates a loop iterating over iterable objects (including Array, Map, Set, String, TypedArray, arguments object and so on), invoking a custom iteration hook with statements to be executed for the value of each distinct property.")
  16. [function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function "The function declaration defines a function with the specified parameters.")
  17. [function*](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function* "The function* declaration (function keyword followed by an asterisk) defines a generator function, which returns a Generator object.")
  18. [if...else](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/if...else "The if statement executes a statement if a specified condition is true. If the condition is false, another statement can be executed.")
  19. [import](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import "The import statement is used to import functions, objects or primitives that have been exported from an external module, another script, etc.")
  20. [label](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/label "The labeled statement can be used with break or continue statements. It is prefixing a statement with an identifier which you can refer to.")
  21. [let](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let "The let statement declares a block scope local variable, optionally initializing it to a value.")
  22. [return](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/return "The return statement ends function execution and specifies a value to be returned to the function caller.")
  23. [switch](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/switch "The switch statement evaluates an expression, matching the expression's value to a case clause, and executes statements associated with that case.")
  24. [throw](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/throw "The throw statement throws a user-defined exception. Execution of the current function will stop (the statements after throw won't be executed), and control will be passed to the first catch block in the call stack. If no catch block exists among caller functions, the program will terminate.")
  25. [try...catch](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/try...catch "The try...catch statement marks a block of statements to try, and specifies a response, should an exception be thrown.")
  26. [var](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var "The variable statement declares a variable, optionally initializing it to a value.")
  27. [while](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/while "The while statement creates a loop that executes a specified statement as long as the test condition evaluates to true. The condition is evaluated before executing the statement.")
  28. [with](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/with "The with statement extends the scope chain for a statement.")
11. [Functions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions)
  1. [Arguments object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments "The arguments object is an Array-like object corresponding to the arguments passed to a function.")
  2. [Arrow functions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Arrow_functions "An arrow function expression has a shorter syntax compared to function expressions and lexically binds the this value (does not bind its own this, arguments, super, or new.target). Arrow functions are always anonymous. These function expressions are best suited for non-method functions and they can not be used as constructors.")
  3. [Default parameters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Default_parameters "Default function parameters allow formal parameters to be initialized with default values if no value or undefined is passed.")
  4. [Method definitions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Method_definitions "Starting with ECMAScript 2015 (ES6), a shorter syntax for method definitions on objects initializers is introduced. It is a shorthand for a function assigned to the method's name.")
  5. [Rest parameters](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/rest_parameters "The rest parameter syntax allows us to represent an indefinite number of arguments as an array.")
  6. [getter](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get "The get syntax binds an object property to a function that will be called when that property is looked up.")
  7. [setter](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/set "The set syntax binds an object property to a function to be called when there is an attempt to set that property.")
  8. [arguments.callee](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/callee "The arguments.callee property contains the currently executing function.")
  9. [arguments.caller](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/caller "The obsolete arguments.caller property used to provide the function that invoked the currently executing function. This property has been removed and no longer works.")
  10. [arguments.length](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/length "The arguments.length property contains the number of arguments passed to the function.")
  11. [arguments[@@iterator]()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/@@iterator "The initial value of the @@iterator property is the same function object as the initial value of the Array.prototype.values property.")
12. [Classes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes)
  1. [constructor](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/constructor "The constructor method is a special method for creating and initializing an object created with a class.")
  2. [extends](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/extends "The extends keyword is used in a class declarations or class expressions to create a class with a child of another class.")
  3. [static](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/static "The static keyword defines a static method for a class.")
13. [Errors](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors)
  1. [Error: Permission denied to access property "x"](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Property_access_denied "Error.")
  2. [InternalError: too much recursion](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Too_much_recursion "InternalError.")
  3. [RangeError: argument is not a valid code point](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Not_a_codepoint "RangeError")
  4. [RangeError: invalid array length](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Invalid_array_length "RangeError")
  5. [RangeError: precision is out of range](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Precision_range "RangeError")
  6. [RangeError: radix must be an integer](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Bad_radix "RangeError")
  7. [RangeError: repeat count must be less than infinity](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Resulting_string_too_large "RangeError")
  8. [RangeError: repeat count must be non-negative](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Negative_repetition_count "RangeError")
  9. [ReferenceError: "x" is not defined](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Not_defined "ReferenceError.")
  10. [ReferenceError: assignment to undeclared variable "x"](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Undeclared_var "ReferenceError warning in strict mode only.")
  11. [ReferenceError: deprecated caller or arguments usage](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Deprecated_caller_or_arguments_usage "A strict-mode-only warning that a ReferenceError occurred. JavaScript execution won't be halted.")
  12. [ReferenceError: invalid assignment left-hand side](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Invalid_assignment_left-hand_side "ReferenceError.")
  13. [ReferenceError: reference to undefined property "x"](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Undefined_prop "ReferenceError warning in strict mode only.")
  14. [SyntaxError: "x" is not a legal ECMA-262 octal constant](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Bad_octal "SyntaxError warning in strict mode only.")
  15. [SyntaxError: JSON.parse: bad parsing](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/JSON_bad_parse "SyntaxError")
  16. [SyntaxError: Malformed formal parameter](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Malformed_formal_parameter "SyntaxError")
  17. [SyntaxError: Unexpected token](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Unexpected_token "SyntaxError")
  18. [SyntaxError: Using //@ to indicate sourceURL pragmas is deprecated. Use //# instead](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Deprecated_source_map_pragma "A warning that a SyntaxError occurred. JavaScript execution won't be halted.")
  19. [SyntaxError: missing ) after argument list](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Missing_parenthesis_after_argument_list "SyntaxError.")
  20. [SyntaxError: missing ; before statement](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Missing_semicolon_before_statement "SyntaxError.")
  21. [SyntaxError: missing ] after element list](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Missing_bracket_after_list "SyntaxError.")
  22. [SyntaxError: missing } after property list](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Missing_curly_after_property_list "SyntaxError")
  23. [SyntaxError: redeclaration of formal parameter "x"](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Redeclared_parameter "SyntaxError")
  24. [SyntaxError: return not in function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Bad_return_or_yield "SyntaxError.")
  25. [SyntaxError: test for equality (==) mistyped as assignment (=)?](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Equal_as_assign "SyntaxError warning in strict mode only.")
  26. [SyntaxError: unterminated string literal](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Unterminated_string_literal "SyntaxError")
  27. [TypeError: "x" has no properties](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/No_properties "TypeError.")
  28. [TypeError: "x" is (not) "y"](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Unexpected_type "TypeError.")
  29. [TypeError: "x" is not a constructor](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Not_a_constructor "TypeError")
  30. [TypeError: "x" is not a function](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Not_a_function "TypeError.")
  31. [TypeError: "x" is read-only](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Read-only "TypeError")
  32. [TypeError: More arguments needed](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/More_arguments_needed "TypeError.")
  33. [TypeError: invalid Array.prototype.sort argument](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Array_sort_argument "TypeError")
  34. [TypeError: property "x" is non-configurable and can't be deleted](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Cant_delete "TypeError in strict mode only.")
  35. [TypeError: variable "x" redeclares argument](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Var_hides_argument "TypeError warning in strict mode only.")
  36. [Warning: -file- is being assigned a //# sourceMappingURL, but already has one](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Already_has_pragma "A warning. JavaScript execution won't be halted.")
  37. [Warning: unreachable code after return statement](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Stmt_after_return "Warning")
14. [Misc](#)
  1. [Lexical grammar](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar)
  2. [JavaScript data structures](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures)
  3. [Enumerability and ownership of properties](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Enumerability_and_ownership_of_properties)
  4. [Iteration protocols](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols)
  5. [Strict mode](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode)
  6. [Transitioning to strict mode](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode/Transitioning_to_strict_mode)
  7. [Template literals](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals)
  8. [Deprecated features](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Deprecated_and_obsolete_features)
15. [New in JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript)
  1. [ECMAScript 5 support in Mozilla](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/ECMAScript_5_support_in_Mozilla "ECMAScript 5.1, an older version of the standard upon which JavaScript is based, was approved in June 2011.")
  2. [ECMAScript 6 support in Mozilla](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/ECMAScript_6_support_in_Mozilla "ECMAScript 2015 (6th Edition) is the current version of the ECMAScript Language Specification standard. Commonly referred to as "ES6", it defines the standard for the JavaScript implementation in SpiderMonkey, the engine used in Firefox and other Mozilla applications.")
  3. [ECMAScript Next support in Mozilla](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/ECMAScript_Next_support_in_Mozilla "ECMAScript Next refers to new features of the ECMA-262 standard (commonly referred to as JavaScript) introduced after ECMAScript 6 (ES2015). New versions of ECMAScript specifications are released yearly. This year, the ES2016 specification will be released and the ES2017 is the current ECMAScript draft specification.")
  4. [Firefox JavaScript changelog](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/Firefox_JavaScript_changelog "The following is a changelog for JavaScript features in Firefox releases.")
  5. [New in JavaScript 1.1](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.1 "The following is a changelog for JavaScript from Netscape Navigator 2.0 to 3.0. The old Netscape documentation references this as "Features added after version 1". Netscape Navigator 3.0 was released on August 19, 1996. Netscape Navigator 3.0 was the second major version of the browser with JavaScript support.")
  6. [New in JavaScript 1.2](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.2 "The following is a changelog for JavaScript from Netscape Navigator 3.0 to 4.0. The old Netscape documentation can be found on archive.org. Netscape Navigator 4.0 was released on June 11, 1997. Netscape Navigator 4.0 was the third major version of the browser with JavaScript support.")
  7. [New in JavaScript 1.3](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.3 "The following is a changelog for JavaScript from Netscape Navigator 4.0 to 4.5. The old Netscape documentation can be found on archive.org. Netscape Navigator 4.5 was released on October 19, 1998.")
  8. [New in JavaScript 1.4](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.4 "The following is a changelog for JavaScript 1.4, which was only used for Netscape's server side JavaScript released in 1999. The old Netscape documentation can be found on archive.org.")
  9. [New in JavaScript 1.5](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.5 "The following is a changelog for JavaScript 1.5. This version was included in Netscape Navigator 6.0 was released on November 14, 2000 and was also used in later versions of Netscape Navigator and Firefox 1.0. You can compare JavaScript 1.5 to JScript version 5.5 and Internet Explorer 5.5, which was released in July 2000. The corresponding ECMA standard is ECMA-262 Edition 3 (from December 1999).")
  10. [New in JavaScript 1.6](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.6 "The following is a changelog for JavaScript 1.6. This version was included in Firefox 1.5 (Gecko 1.8), which was released in November 2005. The corresponding ECMA standard is ECMA-262 Edition 3 and ECMAScript for XML (E4X) with some additional features. Several new features were introduced: E4X, several new Array methods, and Array and String generics.")
  11. [New in JavaScript 1.7](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.7 "The following is a changelog for JavaScript 1.7. This version was included in Firefox 2 (October 2006).")
  12. [New in JavaScript 1.8](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.8 "The following is a changelog for JavaScript 1.8. This version was included in Firefox 3 and is part of Gecko 1.9. See bug 380236 for a tracking development bug for JavaScript 1.8.")
  13. [New in JavaScript 1.8.1](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.8.1 "The following is a changelog for JavaScript 1.8.1. This version was included in Firefox 3.5.")
  14. [New in JavaScript 1.8.5](https://developer.mozilla.org/en-US/docs/Web/JavaScript/New_in_JavaScript/1.8.5 "The following is a changelog for JavaScript 1.8.5. This version was included in Firefox 4.")
16. **[Documentation:](https://developer.mozilla.org/en-US/docs/MDN)**
17. [Useful lists](#)
  1. [All pages index](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Index)
  2. [Methods index](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Methods_Index)
  3. [Properties index](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Properties_Index)
  4. [Pages tagged "JavaScript"](https://developer.mozilla.org/en-US/docs/tag/JavaScript)
18. [Contribute](#)
  1. [JavaScript doc status](https://developer.mozilla.org/en-US/docs/MDN/Doc_status/JavaScript)
  2. [The MDN project](https://developer.mozilla.org/en-US/docs/MDN)

© 2005-2016 Mozilla Developer Network and individual contributors.

Content is available under [these licenses](https://developer.mozilla.org/en-US/docs/MDN/About#Copyrights_and_licenses).

* [About MDN](https://developer.mozilla.org/docs/MDN/About)
* [Terms](//www.mozilla.org/about/legal/terms/mozilla)
* [Privacy](//www.mozilla.org/privacy/websites/)
* [Cookies](//www.mozilla.org/privacy/websites/#cookies)
* [Contribute to the code](//github.com/mozilla/kuma)
