| Element | Description |
| --- | --- |
| [`<address>`](/en-US/docs/Web/HTML/Element/address "The HTML <address> element supplies contact information for its nearest <article> or <body> ancestor; in the latter case, it applies to the whole document.") | The **HTML `<address>` element** supplies contact information for its nearest [`<article>`](/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.") or [`<body>`](/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.") ancestor; in the latter case, it applies to the whole document. |
| [`<article>`](/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.") | The **HTML `<article>` element** represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each `<article>` should be identified, typically by including a heading ([`<h1>`-`<h6>`](/en-US/docs/Web/HTML/Element/Heading_Elements) element) as a child of the `<article>` element. |
| [`<aside>`](/en-US/docs/Web/HTML/Element/aside "The HTML <aside> element represents a section of the page with content connected tangentially to the rest, which could be considered separate from that content. These sections are often represented as sidebars or inserts. They often contain the definitions on the sidebars, such as definitions from the glossary; there may also be other types of information, such as related advertisements; the biography of the author; web applications; profile information or related links on the blog.") | The **HTML `<aside>` element** represents a section of the page with content connected tangentially to the rest, which could be considered separate from that content. These sections are often represented as sidebars or inserts. They often contain the definitions on the sidebars, such as definitions from the glossary; there may also be other types of information, such as related advertisements; the biography of the author; web applications; profile information or related links on the blog. |
| [`<footer>`](/en-US/docs/Web/HTML/Element/footer "The HTML <footer> element represents a footer for its nearest sectioning content or sectioning root element. A footer typically contains information about the author of the section, copyright data or links to related documents.") | The **HTML `<footer>` element** represents a footer for its nearest [sectioning content](/en-US/docs/Web/Guide/HTML/Sections_and_Outlines_of_an_HTML5_document#Defining_Sections_in_HTML5) or [sectioning root](/en-US/docs/Web/Guide/HTML/Sections_and_Outlines_of_an_HTML5_document#Sectioning_root "Sections and Outlines of an HTML5 document#Sectioning root") element. A footer typically contains information about the author of the section, copyright data or links to related documents. |
| [`<header>`](/en-US/docs/Web/HTML/Element/header "The HTML <header> element represents a group of introductory or navigational aids. It may contain some heading elements but also other elements like a logo, wrapped section's header, a search form, and so on.") | The **HTML `<header>` element** represents a group of introductory or navigational aids. It may contain some heading elements but also other elements like a logo, wrapped section's header, a search form, and so on. |
| [`<h1>`](/en-US/docs/Web/HTML/Element/h1 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h2>`](/en-US/docs/Web/HTML/Element/h2 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h3>`](/en-US/docs/Web/HTML/Element/h3 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h4>`](/en-US/docs/Web/HTML/Element/h4 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h5>`](/en-US/docs/Web/HTML/Element/h5 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h6>`](/en-US/docs/Web/HTML/Element/h6 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.") | **Heading** elements implement six levels of document headings, `<h1>` is the most important and `<h6>` is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically. |
| [`<hgroup>`](/en-US/docs/Web/HTML/Element/hgroup "The HTML <hgroup> Element (HTML Heading Group Element) represents the heading of a section. It defines a single title that participates in the outline of the document as the heading of the implicit or explicit section that it belongs to.") | The **HTML `<hgroup>` Element** (_HTML Heading Group Element_) represents the heading of a section. It defines a single title that participates in [the outline of the document](/en-US/docs/Sections_and_Outlines_of_an_HTML5_document "Sections and Outlines of an HTML5 document") as the heading of the implicit or explicit section that it belongs to. |
| [`<nav>`](/en-US/docs/Web/HTML/Element/nav "The HTML <nav> element (HTML Navigation Element) represents a section of a page that links to other pages or to parts within the page: a section with navigation links.") | The **HTML `<nav>` element** (_HTML Navigation Element_) represents a section of a page that links to other pages or to parts within the page: a section with navigation links. |
| [`<section>`](/en-US/docs/Web/HTML/Element/section "The HTML <section> element represents a generic section of a document, i.e., a thematic grouping of content, typically with a heading. Each <section> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <section> element.") | The **HTML `<section>` element** represents a generic section of a document, i.e., a thematic grouping of content, typically with a heading. Each `<section>` should be identified, typically by including a heading ([`<h1>`](/en-US/docs/Web/HTML/Element/h1 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.")-[`<h6>`](/en-US/docs/Web/HTML/Element/h6 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.") element) as a child of the `<section>` element. |
