"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackEvents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigatewayv2 = require("@aws-cdk/aws-apigatewayv2-alpha");
const integrations = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const events_function_1 = require("./events-function");
/**
 * Send Slack events to Amazon EventBridge
 */
class SlackEvents extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.customEventBus) {
            this.eventBus = new events.EventBus(this, 'EventBus');
        }
        // Send event to the event bus
        const handler = new events_function_1.EventsFunction(this, 'handler', {
            logRetention: logs.RetentionDays.ONE_MONTH,
            environment: {
                SLACK_SIGNING_SECRET: props.signingSecret.toString(),
            },
        });
        if (this.eventBus) {
            handler.addEnvironment('EVENT_BUS_NAME', this.eventBus.eventBusName);
        }
        events.EventBus.grantAllPutEvents(handler);
        // HTTP API
        const httpApi = new apigatewayv2.HttpApi(this, 'SlackEventsApi', {
            defaultIntegration: new integrations.HttpLambdaIntegration('Integration', handler),
            apiName: props.apiName,
        });
        new cdk.CfnOutput(this, 'ApiEndpoint', {
            value: httpApi.apiEndpoint,
        });
    }
}
exports.SlackEvents = SlackEvents;
_a = JSII_RTTI_SYMBOL_1;
SlackEvents[_a] = { fqn: "cloudstructs.SlackEvents", version: "0.6.3" };
//# sourceMappingURL=data:application/json;base64,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