# coding: utf-8

"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field. HubDB tables now support `DRAFT` and `PUBLISHED` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the live version of the data without disrupting it.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.cms.hubdb.api_client import ApiClient
from hubspot.cms.hubdb.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive_table(self, table_id, **kwargs):  # noqa: E501
        """Archive a table  # noqa: E501

        Archive an existing HubDB table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_table(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to archive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_table_with_http_info(table_id, **kwargs)  # noqa: E501

    def archive_table_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Archive a table  # noqa: E501

        Archive an existing HubDB table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_table_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to archive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `archive_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_clone_draft_table_rows(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Clone rows in batch  # noqa: E501

        Clones rows in the `DRAFT` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_clone_draft_table_rows(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_clone_draft_table_rows_with_http_info(
            table_id, batch_input_string, **kwargs
        )  # noqa: E501

    def batch_clone_draft_table_rows_with_http_info(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Clone rows in batch  # noqa: E501

        Clones rows in the `DRAFT` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_clone_draft_table_rows_with_http_info(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_string"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_clone_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_clone_draft_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and (
            "batch_input_string" not in local_var_params
            or local_var_params["batch_input_string"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_string` when calling `batch_clone_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft/batch/clone",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_create_draft_table_rows(
        self, table_id, batch_input_hub_db_table_row_v3, **kwargs
    ):  # noqa: E501
        """Create rows in batch  # noqa: E501

        Creates rows in the `DRAFT` version of the specified table, given an array of row objects. See the endpoint `/tables/{tableId}/rows` for more details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_create_draft_table_rows(table_id, batch_input_hub_db_table_row_v3, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3 batch_input_hub_db_table_row_v3: JSON array of row objects (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_create_draft_table_rows_with_http_info(
            table_id, batch_input_hub_db_table_row_v3, **kwargs
        )  # noqa: E501

    def batch_create_draft_table_rows_with_http_info(
        self, table_id, batch_input_hub_db_table_row_v3, **kwargs
    ):  # noqa: E501
        """Create rows in batch  # noqa: E501

        Creates rows in the `DRAFT` version of the specified table, given an array of row objects. See the endpoint `/tables/{tableId}/rows` for more details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_create_draft_table_rows_with_http_info(table_id, batch_input_hub_db_table_row_v3, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3 batch_input_hub_db_table_row_v3: JSON array of row objects (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_hub_db_table_row_v3"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_create_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_create_draft_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_hub_db_table_row_v3' is set
        if self.api_client.client_side_validation and (
            "batch_input_hub_db_table_row_v3" not in local_var_params
            or local_var_params["batch_input_hub_db_table_row_v3"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_hub_db_table_row_v3` when calling `batch_create_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_hub_db_table_row_v3" in local_var_params:
            body_params = local_var_params["batch_input_hub_db_table_row_v3"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft/batch/create",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_purge_draft_table_rows(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Permanently deletes rows  # noqa: E501

        Permanently deletes rows from the `DRAFT` version of the table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_purge_draft_table_rows(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_purge_draft_table_rows_with_http_info(
            table_id, batch_input_string, **kwargs
        )  # noqa: E501

    def batch_purge_draft_table_rows_with_http_info(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Permanently deletes rows  # noqa: E501

        Permanently deletes rows from the `DRAFT` version of the table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_purge_draft_table_rows_with_http_info(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_string"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_purge_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_purge_draft_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and (
            "batch_input_string" not in local_var_params
            or local_var_params["batch_input_string"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_string` when calling `batch_purge_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft/batch/purge",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_read_draft_table_rows(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Get a set of rows from DRAFT table  # noqa: E501

        Returns rows in the `DRAFT` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_draft_table_rows(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_read_draft_table_rows_with_http_info(
            table_id, batch_input_string, **kwargs
        )  # noqa: E501

    def batch_read_draft_table_rows_with_http_info(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Get a set of rows from DRAFT table  # noqa: E501

        Returns rows in the `DRAFT` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_draft_table_rows_with_http_info(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputString batch_input_string: JSON array of row ids. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_string"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_read_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_read_draft_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and (
            "batch_input_string" not in local_var_params
            or local_var_params["batch_input_string"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_string` when calling `batch_read_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft/batch/read",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_read_table_rows(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Get a set of rows  # noqa: E501

        Returns rows in the `PUBLISHED` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_table_rows(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to query. (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_read_table_rows_with_http_info(
            table_id, batch_input_string, **kwargs
        )  # noqa: E501

    def batch_read_table_rows_with_http_info(
        self, table_id, batch_input_string, **kwargs
    ):  # noqa: E501
        """Get a set of rows  # noqa: E501

        Returns rows in the `PUBLISHED` version of the specified table, given a set of row ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_read_table_rows_with_http_info(table_id, batch_input_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to query. (required)
        :param BatchInputString batch_input_string: The JSON array of row ids (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_string"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_read_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_read_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_string' is set
        if self.api_client.client_side_validation and (
            "batch_input_string" not in local_var_params
            or local_var_params["batch_input_string"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_string` when calling `batch_read_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_string" in local_var_params:
            body_params = local_var_params["batch_input_string"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/batch/read",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_replace_draft_table_rows(
        self, table_id, batch_input_hub_db_table_row_v3, **kwargs
    ):  # noqa: E501
        """Replace rows in batch in DRAFT table  # noqa: E501

        Updates multiple rows as a batch in the `DRAFT` version of the table. See the endpoint `/tables/{tableId}/rows/{rowId}/draft PUT` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_replace_draft_table_rows(table_id, batch_input_hub_db_table_row_v3, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3 batch_input_hub_db_table_row_v3: JSON array of row objects. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_replace_draft_table_rows_with_http_info(
            table_id, batch_input_hub_db_table_row_v3, **kwargs
        )  # noqa: E501

    def batch_replace_draft_table_rows_with_http_info(
        self, table_id, batch_input_hub_db_table_row_v3, **kwargs
    ):  # noqa: E501
        """Replace rows in batch in DRAFT table  # noqa: E501

        Updates multiple rows as a batch in the `DRAFT` version of the table. See the endpoint `/tables/{tableId}/rows/{rowId}/draft PUT` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_replace_draft_table_rows_with_http_info(table_id, batch_input_hub_db_table_row_v3, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputHubDbTableRowV3 batch_input_hub_db_table_row_v3: JSON array of row objects. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_hub_db_table_row_v3"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_replace_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_replace_draft_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_hub_db_table_row_v3' is set
        if self.api_client.client_side_validation and (
            "batch_input_hub_db_table_row_v3" not in local_var_params
            or local_var_params["batch_input_hub_db_table_row_v3"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_hub_db_table_row_v3` when calling `batch_replace_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_hub_db_table_row_v3" in local_var_params:
            body_params = local_var_params["batch_input_hub_db_table_row_v3"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft/batch/replace",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def batch_update_draft_table_rows(
        self, table_id, batch_input_json_node, **kwargs
    ):  # noqa: E501
        """Update rows in batch in DRAFT table  # noqa: E501

        Updates multiple rows as a batch in the `DRAFT` version of the table. See the endpoint `/tables/{tableId}/rows/{rowId}/draft PATCH` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_update_draft_table_rows(table_id, batch_input_json_node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputJsonNode batch_input_json_node: JSON array of row objects. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.batch_update_draft_table_rows_with_http_info(
            table_id, batch_input_json_node, **kwargs
        )  # noqa: E501

    def batch_update_draft_table_rows_with_http_info(
        self, table_id, batch_input_json_node, **kwargs
    ):  # noqa: E501
        """Update rows in batch in DRAFT table  # noqa: E501

        Updates multiple rows as a batch in the `DRAFT` version of the table. See the endpoint `/tables/{tableId}/rows/{rowId}/draft PATCH` for details on updating a single row.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.batch_update_draft_table_rows_with_http_info(table_id, batch_input_json_node, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table (required)
        :param BatchInputJsonNode batch_input_json_node: JSON array of row objects. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "batch_input_json_node"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_update_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `batch_update_draft_table_rows`"
            )  # noqa: E501
        # verify the required parameter 'batch_input_json_node' is set
        if self.api_client.client_side_validation and (
            "batch_input_json_node" not in local_var_params
            or local_var_params["batch_input_json_node"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `batch_input_json_node` when calling `batch_update_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "batch_input_json_node" in local_var_params:
            body_params = local_var_params["batch_input_json_node"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft/batch/update",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="object",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def clone_draft_table(
        self, table_id, hub_db_table_clone_request, **kwargs
    ):  # noqa: E501
        """Clone a table  # noqa: E501

        Clone an existing HubDB table. The `newName` and `newLabel` of the new table can be sent as JSON in the `body` parameter. This will create the cloned table as a `DRAFT`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table(table_id, hub_db_table_clone_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to clone. (required)
        :param HubDbTableCloneRequest hub_db_table_clone_request: JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.clone_draft_table_with_http_info(
            table_id, hub_db_table_clone_request, **kwargs
        )  # noqa: E501

    def clone_draft_table_with_http_info(
        self, table_id, hub_db_table_clone_request, **kwargs
    ):  # noqa: E501
        """Clone a table  # noqa: E501

        Clone an existing HubDB table. The `newName` and `newLabel` of the new table can be sent as JSON in the `body` parameter. This will create the cloned table as a `DRAFT`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table_with_http_info(table_id, hub_db_table_clone_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to clone. (required)
        :param HubDbTableCloneRequest hub_db_table_clone_request: JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "hub_db_table_clone_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `clone_draft_table`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_clone_request' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_clone_request" not in local_var_params
            or local_var_params["hub_db_table_clone_request"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_clone_request` when calling `clone_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_clone_request" in local_var_params:
            body_params = local_var_params["hub_db_table_clone_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft/clone",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def clone_draft_table_row(self, row_id, table_id, **kwargs):  # noqa: E501
        """Clone a row  # noqa: E501

        Clones a single row in the `DRAFT` version of the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table_row(row_id, table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.clone_draft_table_row_with_http_info(
            row_id, table_id, **kwargs
        )  # noqa: E501

    def clone_draft_table_row_with_http_info(
        self, row_id, table_id, **kwargs
    ):  # noqa: E501
        """Clone a row  # noqa: E501

        Clones a single row in the `DRAFT` version of the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table_row_with_http_info(row_id, table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["row_id", "table_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and (
            "row_id" not in local_var_params
            or local_var_params["row_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `row_id` when calling `clone_draft_table_row`"
            )  # noqa: E501
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `clone_draft_table_row`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "row_id" in local_var_params
            and not re.search(r"\d+", local_var_params["row_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `row_id` when calling `clone_draft_table_row`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "row_id" in local_var_params:
            path_params["rowId"] = local_var_params["row_id"]  # noqa: E501
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/{rowId}/draft/clone",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_table(self, hub_db_table_v3_input, **kwargs):  # noqa: E501
        """Create a new table  # noqa: E501

        Creates a new HubDB table given a JSON schema. The table name and label should be unique for each account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table(hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being created. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_with_http_info(
            hub_db_table_v3_input, **kwargs
        )  # noqa: E501

    def create_table_with_http_info(
        self, hub_db_table_v3_input, **kwargs
    ):  # noqa: E501
        """Create a new table  # noqa: E501

        Creates a new HubDB table given a JSON schema. The table name and label should be unique for each account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_with_http_info(hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being created. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["hub_db_table_v3_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'hub_db_table_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_v3_input" not in local_var_params
            or local_var_params["hub_db_table_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_v3_input` when calling `create_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_table_row(
        self, table_id, hub_db_table_row_v3_input, **kwargs
    ):  # noqa: E501
        """Add a new row to a table  # noqa: E501

        Add a new row to a HubDB table. New rows will be added to the `DRAFT` version of the table. Use the `/publish`  endpoint to push these changes live.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_row(table_id, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the target table. (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The row definition JSON, formatted as described above. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_row_with_http_info(
            table_id, hub_db_table_row_v3_input, **kwargs
        )  # noqa: E501

    def create_table_row_with_http_info(
        self, table_id, hub_db_table_row_v3_input, **kwargs
    ):  # noqa: E501
        """Add a new row to a table  # noqa: E501

        Add a new row to a HubDB table. New rows will be added to the `DRAFT` version of the table. Use the `/publish`  endpoint to push these changes live.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_row_with_http_info(table_id, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the target table. (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The row definition JSON, formatted as described above. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "hub_db_table_row_v3_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `create_table_row`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_row_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_row_v3_input" not in local_var_params
            or local_var_params["hub_db_table_row_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_row_v3_input` when calling `create_table_row`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_row_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_row_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def export_draft_table(self, table_id, **kwargs):  # noqa: E501
        """Export a DRAFT table  # noqa: E501

        Exports the `DRAFT` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_draft_table(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.export_draft_table_with_http_info(table_id, **kwargs)  # noqa: E501

    def export_draft_table_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Export a DRAFT table  # noqa: E501

        Exports the `DRAFT` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_draft_table_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "format"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `export_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "format" in local_var_params and local_var_params["format"] is not None
        ):  # noqa: E501
            query_params.append(("format", local_var_params["format"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/vnd.ms-excel", "text/csv", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft/export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def export_table(self, table_id, **kwargs):  # noqa: E501
        """Export a PUBLISHED version of a table  # noqa: E501

        Exports the `PUBLISHED` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_table(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.export_table_with_http_info(table_id, **kwargs)  # noqa: E501

    def export_table_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Export a PUBLISHED version of a table  # noqa: E501

        Exports the `PUBLISHED` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_table_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "format"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `export_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "format" in local_var_params and local_var_params["format"] is not None
        ):  # noqa: E501
            query_params.append(("format", local_var_params["format"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/vnd.ms-excel", "text/csv", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_all_draft_tables(self, **kwargs):  # noqa: E501
        """Return all DRAFT tables  # noqa: E501

        Returns the details for each DRAFT table defined in the specified account, including column definitions. `Note:` Unlike other HubDB GET endpoints, getting all tables will require authentication.\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_draft_tables(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_all_draft_tables_with_http_info(**kwargs)  # noqa: E501

    def get_all_draft_tables_with_http_info(self, **kwargs):  # noqa: E501
        """Return all DRAFT tables  # noqa: E501

        Returns the details for each DRAFT table defined in the specified account, including column definitions. `Note:` Unlike other HubDB GET endpoints, getting all tables will require authentication.\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_draft_tables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "updated_after",
            "updated_before",
            "sort",
            "created_at",
            "created_after",
            "after",
            "archived",
            "created_before",
            "updated_at",
            "limit",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_draft_tables" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "updated_after" in local_var_params
            and local_var_params["updated_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAfter", local_var_params["updated_after"])
            )  # noqa: E501
        if (
            "updated_before" in local_var_params
            and local_var_params["updated_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedBefore", local_var_params["updated_before"])
            )  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if (
            "created_at" in local_var_params
            and local_var_params["created_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAt", local_var_params["created_at"])
            )  # noqa: E501
        if (
            "created_after" in local_var_params
            and local_var_params["created_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAfter", local_var_params["created_after"])
            )  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "created_before" in local_var_params
            and local_var_params["created_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdBefore", local_var_params["created_before"])
            )  # noqa: E501
        if (
            "updated_at" in local_var_params
            and local_var_params["updated_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAt", local_var_params["updated_at"])
            )  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalHubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_all_tables(self, **kwargs):  # noqa: E501
        """Get all tables  # noqa: E501

        Returns the details for each table defined in an account, including column definitions. `Note:` Unlike other HubDB GET endpoints, getting all tables will require authentication.\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_tables(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_all_tables_with_http_info(**kwargs)  # noqa: E501

    def get_all_tables_with_http_info(self, **kwargs):  # noqa: E501
        """Get all tables  # noqa: E501

        Returns the details for each table defined in an account, including column definitions. `Note:` Unlike other HubDB GET endpoints, getting all tables will require authentication.\"  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_tables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "updated_after",
            "updated_before",
            "sort",
            "created_at",
            "created_after",
            "after",
            "archived",
            "created_before",
            "updated_at",
            "limit",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_tables" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "updated_after" in local_var_params
            and local_var_params["updated_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAfter", local_var_params["updated_after"])
            )  # noqa: E501
        if (
            "updated_before" in local_var_params
            and local_var_params["updated_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedBefore", local_var_params["updated_before"])
            )  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if (
            "created_at" in local_var_params
            and local_var_params["created_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAt", local_var_params["created_at"])
            )  # noqa: E501
        if (
            "created_after" in local_var_params
            and local_var_params["created_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAfter", local_var_params["created_after"])
            )  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "created_before" in local_var_params
            and local_var_params["created_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdBefore", local_var_params["created_before"])
            )  # noqa: E501
        if (
            "updated_at" in local_var_params
            and local_var_params["updated_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAt", local_var_params["updated_at"])
            )  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalHubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_draft_table_details_by_id(self, table_id, **kwargs):  # noqa: E501
        """Get details for a DRAFT table  # noqa: E501

        Get the details for the `DRAFT` version of a specific HubDB table. This will include the definitions for the columns in the table and the number of rows in the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_details_by_id(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to return. (required)
        :param bool archived: Set this to `true` to return an archived table. Defaults to `false`.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_draft_table_details_by_id_with_http_info(
            table_id, **kwargs
        )  # noqa: E501

    def get_draft_table_details_by_id_with_http_info(
        self, table_id, **kwargs
    ):  # noqa: E501
        """Get details for a DRAFT table  # noqa: E501

        Get the details for the `DRAFT` version of a specific HubDB table. This will include the definitions for the columns in the table and the number of rows in the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_details_by_id_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to return. (required)
        :param bool archived: Set this to `true` to return an archived table. Defaults to `false`.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "archived", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_table_details_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `get_draft_table_details_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_draft_table_row_by_id(self, row_id, table_id, **kwargs):  # noqa: E501
        """Get a table row  # noqa: E501

        Get a single row by ID from a table's `DRAFT` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_row_by_id(row_id, table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_draft_table_row_by_id_with_http_info(
            row_id, table_id, **kwargs
        )  # noqa: E501

    def get_draft_table_row_by_id_with_http_info(
        self, row_id, table_id, **kwargs
    ):  # noqa: E501
        """Get a table row  # noqa: E501

        Get a single row by ID from a table's `DRAFT` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_row_by_id_with_http_info(row_id, table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["row_id", "table_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_table_row_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and (
            "row_id" not in local_var_params
            or local_var_params["row_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `row_id` when calling `get_draft_table_row_by_id`"
            )  # noqa: E501
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `get_draft_table_row_by_id`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "row_id" in local_var_params
            and not re.search(r"\d+", local_var_params["row_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `row_id` when calling `get_draft_table_row_by_id`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "row_id" in local_var_params:
            path_params["rowId"] = local_var_params["row_id"]  # noqa: E501
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/{rowId}/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def import_draft_table(self, table_id, **kwargs):  # noqa: E501
        """Import data into DRAFT table  # noqa: E501

        Import the contents of a CSV file into an existing HubDB table. The data will always be imported into the `DRAFT` version of the table. Use the `/push-live` endpoint to push these changes to `PUBLISHED`. This endpoint takes a multi-part POST request. The first part will be a set of JSON-formatted options for the import.  The second part will be the CSV file you want to import. Refer the overview section to check the details and format of the JSON-formatted options for the import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_draft_table(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID of the destination table where data will be imported. (required)
        :param file file: The source CSV file to be imported.
        :param str config: Configuration for the import in JSON format as described above.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.import_draft_table_with_http_info(table_id, **kwargs)  # noqa: E501

    def import_draft_table_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Import data into DRAFT table  # noqa: E501

        Import the contents of a CSV file into an existing HubDB table. The data will always be imported into the `DRAFT` version of the table. Use the `/push-live` endpoint to push these changes to `PUBLISHED`. This endpoint takes a multi-part POST request. The first part will be a set of JSON-formatted options for the import.  The second part will be the CSV file you want to import. Refer the overview section to check the details and format of the JSON-formatted options for the import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_draft_table_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID of the destination table where data will be imported. (required)
        :param file file: The source CSV file to be imported.
        :param str config: Configuration for the import in JSON format as described above.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "file", "config"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `import_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "file" in local_var_params:
            local_var_files["file"] = local_var_params["file"]  # noqa: E501
        if "config" in local_var_params:
            form_params.append(("config", local_var_params["config"]))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft/import",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ImportResult",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def publish_draft_table(self, table_id, **kwargs):  # noqa: E501
        """Publish a table from draft  # noqa: E501

        Publishes the current `DRAFT` version of the table by copying the data to the PUBLISHED version of the table. This will immediately push the data for any stored `DRAFT` version to the `PUBLISHED` version of the table, meaning any website pages using data from the table will be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_draft_table(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to publish. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.publish_draft_table_with_http_info(table_id, **kwargs)  # noqa: E501

    def publish_draft_table_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Publish a table from draft  # noqa: E501

        Publishes the current `DRAFT` version of the table by copying the data to the PUBLISHED version of the table. This will immediately push the data for any stored `DRAFT` version to the `PUBLISHED` version of the table, meaning any website pages using data from the table will be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_draft_table_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to publish. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `publish_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft/push-live",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def purge_draft_table_row(self, row_id, table_id, **kwargs):  # noqa: E501
        """Permanently deletes a row  # noqa: E501

        Permanently deletes a row from a table's `DRAFT` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purge_draft_table_row(row_id, table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.purge_draft_table_row_with_http_info(
            row_id, table_id, **kwargs
        )  # noqa: E501

    def purge_draft_table_row_with_http_info(
        self, row_id, table_id, **kwargs
    ):  # noqa: E501
        """Permanently deletes a row  # noqa: E501

        Permanently deletes a row from a table's `DRAFT` version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.purge_draft_table_row_with_http_info(row_id, table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["row_id", "table_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method purge_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and (
            "row_id" not in local_var_params
            or local_var_params["row_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `row_id` when calling `purge_draft_table_row`"
            )  # noqa: E501
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `purge_draft_table_row`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "row_id" in local_var_params
            and not re.search(r"\d+", local_var_params["row_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `row_id` when calling `purge_draft_table_row`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "row_id" in local_var_params:
            path_params["rowId"] = local_var_params["row_id"]  # noqa: E501
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/{rowId}/draft",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def read_draft_table_rows(self, table_id, **kwargs):  # noqa: E501
        """Get rows from DRAFT table  # noqa: E501

        Returns rows in the `DRAFT` version of the specified table. Row results can be filtered and sorted using the options mentioned in the `/tables/{tableId}/rows` endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_draft_table_rows(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to query. (required)
        :param list[str] properties: Specify the column names to get results containing only the required columns instead of all column details.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to return. Default is `1000`.
        :param list[str] sort: Specifies the column names to sort the results by.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.read_draft_table_rows_with_http_info(
            table_id, **kwargs
        )  # noqa: E501

    def read_draft_table_rows_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Get rows from DRAFT table  # noqa: E501

        Returns rows in the `DRAFT` version of the specified table. Row results can be filtered and sorted using the options mentioned in the `/tables/{tableId}/rows` endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_draft_table_rows_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to query. (required)
        :param list[str] properties: Specify the column names to get results containing only the required columns instead of all column details.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param int limit: The maximum number of results to return. Default is `1000`.
        :param list[str] sort: Specifies the column names to sort the results by.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "properties", "after", "limit", "sort"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_draft_table_rows" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `read_draft_table_rows`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "properties" in local_var_params
            and local_var_params["properties"] is not None
        ):  # noqa: E501
            query_params.append(
                ("properties", local_var_params["properties"])
            )  # noqa: E501
            collection_formats["properties"] = "multi"  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalHubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def replace_draft_table_row(
        self, row_id, table_id, hub_db_table_row_v3_input, **kwargs
    ):  # noqa: E501
        """Replaces an existing row  # noqa: E501

        Replace a single row in the table's `DRAFT` version. All the column values must be specified. If a column has a value in the target table and this request doesn't define that value, it will be deleted. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_draft_table_row(row_id, table_id, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.replace_draft_table_row_with_http_info(
            row_id, table_id, hub_db_table_row_v3_input, **kwargs
        )  # noqa: E501

    def replace_draft_table_row_with_http_info(
        self, row_id, table_id, hub_db_table_row_v3_input, **kwargs
    ):  # noqa: E501
        """Replaces an existing row  # noqa: E501

        Replace a single row in the table's `DRAFT` version. All the column values must be specified. If a column has a value in the target table and this request doesn't define that value, it will be deleted. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_draft_table_row_with_http_info(row_id, table_id, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["row_id", "table_id", "hub_db_table_row_v3_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and (
            "row_id" not in local_var_params
            or local_var_params["row_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `row_id` when calling `replace_draft_table_row`"
            )  # noqa: E501
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `replace_draft_table_row`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_row_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_row_v3_input" not in local_var_params
            or local_var_params["hub_db_table_row_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_row_v3_input` when calling `replace_draft_table_row`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "row_id" in local_var_params
            and not re.search(r"\d+", local_var_params["row_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `row_id` when calling `replace_draft_table_row`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "row_id" in local_var_params:
            path_params["rowId"] = local_var_params["row_id"]  # noqa: E501
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_row_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_row_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/{rowId}/draft",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def reset_draft_table(self, table_id, **kwargs):  # noqa: E501
        """Reset a draft table  # noqa: E501

        Replaces the data in the `DRAFT` version of the table with values from the `PUBLISHED` version. Any unpublished changes in the `DRAFT` will be lost after this call is made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_draft_table(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to reset. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.reset_draft_table_with_http_info(table_id, **kwargs)  # noqa: E501

    def reset_draft_table_with_http_info(self, table_id, **kwargs):  # noqa: E501
        """Reset a draft table  # noqa: E501

        Replaces the data in the `DRAFT` version of the table with values from the `PUBLISHED` version. Any unpublished changes in the `DRAFT` will be lost after this call is made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_draft_table_with_http_info(table_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to reset. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `reset_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft/reset",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_draft_table(
        self, table_id, hub_db_table_v3_input, **kwargs
    ):  # noqa: E501
        """Update an existing table  # noqa: E501

        Update an existing HubDB table. You can use this endpoint to add or remove a column. Tables updated using the endpoint will only modify the `DRAFT` table. Use the publish endpoint to push all changes to the `PUBLISHED` version. You can only include the columns that need to be modified without including the remaining columns.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table(table_id, hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to update. (required)
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being updated. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_draft_table_with_http_info(
            table_id, hub_db_table_v3_input, **kwargs
        )  # noqa: E501

    def update_draft_table_with_http_info(
        self, table_id, hub_db_table_v3_input, **kwargs
    ):  # noqa: E501
        """Update an existing table  # noqa: E501

        Update an existing HubDB table. You can use this endpoint to add or remove a column. Tables updated using the endpoint will only modify the `DRAFT` table. Use the publish endpoint to push all changes to the `PUBLISHED` version. You can only include the columns that need to be modified without including the remaining columns.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table_with_http_info(table_id, hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to update. (required)
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being updated. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id", "hub_db_table_v3_input", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `update_draft_table`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_v3_input" not in local_var_params
            or local_var_params["hub_db_table_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_v3_input` when calling `update_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/draft",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_draft_table_row(
        self, row_id, table_id, hub_db_table_row_v3_input, **kwargs
    ):  # noqa: E501
        """Updates an existing row  # noqa: E501

        Sparse updates a single row in the table's `DRAFT` version. All the column values need not be specified. Only the columns or fields that needs to be modified can be specified. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table_row(row_id, table_id, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row with necessary fields that needs to be updated. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableRowV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_draft_table_row_with_http_info(
            row_id, table_id, hub_db_table_row_v3_input, **kwargs
        )  # noqa: E501

    def update_draft_table_row_with_http_info(
        self, row_id, table_id, hub_db_table_row_v3_input, **kwargs
    ):  # noqa: E501
        """Updates an existing row  # noqa: E501

        Sparse updates a single row in the table's `DRAFT` version. All the column values need not be specified. Only the columns or fields that needs to be modified can be specified. See the `Create a row` endpoint for instructions on how to format the JSON row definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table_row_with_http_info(row_id, table_id, hub_db_table_row_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str row_id: The ID of the row (required)
        :param str table_id: The ID or name of the table (required)
        :param HubDbTableRowV3Input hub_db_table_row_v3_input: The JSON object of the row with necessary fields that needs to be updated. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableRowV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["row_id", "table_id", "hub_db_table_row_v3_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_draft_table_row" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'row_id' is set
        if self.api_client.client_side_validation and (
            "row_id" not in local_var_params
            or local_var_params["row_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `row_id` when calling `update_draft_table_row`"
            )  # noqa: E501
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `update_draft_table_row`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_row_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_row_v3_input" not in local_var_params
            or local_var_params["hub_db_table_row_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_row_v3_input` when calling `update_draft_table_row`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "row_id" in local_var_params
            and not re.search(r"\d+", local_var_params["row_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `row_id` when calling `update_draft_table_row`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "row_id" in local_var_params:
            path_params["rowId"] = local_var_params["row_id"]  # noqa: E501
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_row_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_row_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}/rows/{rowId}/draft",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableRowV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_table(
        self, table_id, hub_db_table_v3_live_input, **kwargs
    ):  # noqa: E501
        """Publish or unpublish a live version of a table or restore an archived table  # noqa: E501

        Use this endpoint to perform one of the following <ul><li> Publish a live version of a table (without copying table data from DRAFT) </li><li>Un-publish a live version of a table (Leaving the data in the live version)</li><li>Restore an archived table</li></ul>  To publish a table, send `published` property in the JSON object with the value `true`. To unpublish a table, send `published` property in the JSON object with the value `false`.  To restore an archived table, send `archived` property in the JSON object with the value `false` along with the query parameter `archived=true`. When restoring an archived table, if an active table already exists with the same `name` or `label`, you will need to change the name of the archived table when restoring it using the `name` and `label` parameters with a new name and new label.  Examples:  Publish a table:  ```     {       \"published\": true     } ``` Unpublish a table: ```     {       \"published\": false     } ``` Restore a table: (send `archived=true` in query parameters) ```     {       \"archived\": false     } ``` Restore a table with a new name: (send `archived=true` in query parameters) ```     {       \"label\": \"New Table Name\",       \"name\": \"new_table_name\",       \"archived\": false     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_table(table_id, hub_db_table_v3_live_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to return. (required)
        :param HubDbTableV3LiveInput hub_db_table_v3_live_input: The JSON object as described. (required)
        :param bool archived: Whether to return only results that have been archived.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_table_with_http_info(
            table_id, hub_db_table_v3_live_input, **kwargs
        )  # noqa: E501

    def update_table_with_http_info(
        self, table_id, hub_db_table_v3_live_input, **kwargs
    ):  # noqa: E501
        """Publish or unpublish a live version of a table or restore an archived table  # noqa: E501

        Use this endpoint to perform one of the following <ul><li> Publish a live version of a table (without copying table data from DRAFT) </li><li>Un-publish a live version of a table (Leaving the data in the live version)</li><li>Restore an archived table</li></ul>  To publish a table, send `published` property in the JSON object with the value `true`. To unpublish a table, send `published` property in the JSON object with the value `false`.  To restore an archived table, send `archived` property in the JSON object with the value `false` along with the query parameter `archived=true`. When restoring an archived table, if an active table already exists with the same `name` or `label`, you will need to change the name of the archived table when restoring it using the `name` and `label` parameters with a new name and new label.  Examples:  Publish a table:  ```     {       \"published\": true     } ``` Unpublish a table: ```     {       \"published\": false     } ``` Restore a table: (send `archived=true` in query parameters) ```     {       \"archived\": false     } ``` Restore a table with a new name: (send `archived=true` in query parameters) ```     {       \"label\": \"New Table Name\",       \"name\": \"new_table_name\",       \"archived\": false     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_table_with_http_info(table_id, hub_db_table_v3_live_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id: The ID or name of the table to return. (required)
        :param HubDbTableV3LiveInput hub_db_table_v3_live_input: The JSON object as described. (required)
        :param bool archived: Whether to return only results that have been archived.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "table_id",
            "hub_db_table_v3_live_input",
            "archived",
            "include_foreign_ids",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id' is set
        if self.api_client.client_side_validation and (
            "table_id" not in local_var_params
            or local_var_params["table_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id` when calling `update_table`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_v3_live_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_v3_live_input" not in local_var_params
            or local_var_params["hub_db_table_v3_live_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_v3_live_input` when calling `update_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id" in local_var_params:
            path_params["tableId"] = local_var_params["table_id"]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_v3_live_input" in local_var_params:
            body_params = local_var_params["hub_db_table_v3_live_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableId}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
