define("ipycanvas",["@jupyter-widgets/base"],function(e){return function(e){var t={};function n(s){if(t[s])return t[s].exports;var i=t[s]={i:s,l:!1,exports:{}};return e[s].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=e,n.c=t,n.d=function(e,t,s){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:s})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var s=Object.create(null);if(n.r(s),Object.defineProperty(s,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var i in e)n.d(s,i,function(t){return e[t]}.bind(null,i));return s},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="https://unpkg.com/ipycanvas@0.4.4/dist/",n(n.s=1)}([function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});const s=n(2);t.MODULE_VERSION=s.version,t.MODULE_NAME=s.name},function(e,t,n){"use strict";function s(e){for(var n in e)t.hasOwnProperty(n)||(t[n]=e[n])}Object.defineProperty(t,"__esModule",{value:!0}),s(n(0)),s(n(3))},function(e){e.exports={name:"ipycanvas",version:"0.4.4",description:"Interactive widgets library exposing the browser's Canvas API",keywords:["jupyter","jupyterlab","jupyterlab-extension","widgets"],files:["lib/**/*.js","dist/*.js"],homepage:"https://github.com/martinRenou/ipycanvas",bugs:{url:"https://github.com/martinRenou/ipycanvas/issues"},license:"BSD-3-Clause",author:{name:"Martin Renou",email:"martin.renou@gmail.com"},main:"lib/index.js",types:"./lib/index.d.ts",repository:{type:"git",url:"https://github.com/martinRenou/ipycanvas"},scripts:{build:"npm run build:lib && npm run build:nbextension","build:labextension":"npm run clean:labextension && mkdirp ipycanvas/labextension && cd ipycanvas/labextension && npm pack ../..","build:lib":"tsc","build:nbextension":"webpack -p","build:all":"npm run build:labextension && npm run build:nbextension",clean:"npm run clean:lib && npm run clean:nbextension","clean:lib":"rimraf lib","clean:labextension":"rimraf ipycanvas/labextension","clean:nbextension":"rimraf ipycanvas/nbextension/static/index.js",prepack:"npm run build:lib",watch:"npm-run-all -p watch:*","watch:lib":"tsc -w","watch:nbextension":"webpack --watch"},dependencies:{"@jupyter-widgets/base":"^2.0.1 || ^3",lodash:">=4.17.13"},devDependencies:{"@phosphor/application":"^1.6.0","@phosphor/widgets":"^1.6.0","@types/node":"^10.11.6","@types/webpack-env":"^1.13.6","expect.js":"^0.3.1","fs-extra":"^7.0.0",mkdirp:"^0.5.1","npm-run-all":"^4.1.3",rimraf:"^2.6.2","source-map-loader":"^0.2.4","ts-loader":"^5.2.1",typescript:"~3.1.2",webpack:"^4.20.2","webpack-cli":"^3.1.2",acorn:"^6.2.0"},jupyterlab:{extension:"lib/plugin"}}},function(e,t,n){"use strict";var s=this&&this.__awaiter||function(e,t,n,s){return new(n||(n=Promise))(function(i,a){function o(e){try{c(s.next(e))}catch(e){a(e)}}function r(e){try{c(s.throw(e))}catch(e){a(e)}}function c(e){e.done?i(e.value):new n(function(t){t(e.value)}).then(o,r)}c((s=s.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0});const i=n(4),a=n(0),o=n(5);function r(e){const t=e.getContext("2d");if(null===t)throw"Could not create 2d context.";return t}class c extends i.DOMWidgetModel{defaults(){return Object.assign({},super.defaults(),{_model_name:c.model_name,_model_module:c.model_module,_model_module_version:c.model_module_version,_view_name:c.view_name,_view_module:c.view_module,_view_module_version:c.view_module_version,width:700,height:500,sync_image_data:!1,image_data:null})}initialize(e,t){super.initialize(e,t),this.canvas=document.createElement("canvas"),this.ctx=r(this.canvas),this.resizeCanvas(),this.drawImageData(),this.on_some_change(["width","height"],this.resizeCanvas,this),this.on("change:sync_image_data",this.syncImageData.bind(this)),this.on("msg:custom",this.onCommand.bind(this)),this.send({event:"client_ready"},{})}drawImageData(){return s(this,void 0,void 0,function*(){if(null!==this.get("image_data")){const e=yield o.fromBytes(this.get("image_data"));this.ctx.drawImage(e,0,0),this.trigger("new-frame")}})}onCommand(e,t){return s(this,void 0,void 0,function*(){yield this.processCommand(e,t),this.forEachView(e=>{e.updateCanvas()}),this.trigger("new-frame"),this.syncImageData()})}processCommand(e,t){return s(this,void 0,void 0,function*(){if(e instanceof Array){let n=t;for(const t of e){let e=[];t.n_buffers&&(e=n.slice(0,t.n_buffers),n=n.slice(t.n_buffers)),yield this.processCommand(t,e)}}else switch(e.name){case"fillRects":this.drawRects(e.args,t,"fillRect");break;case"strokeRects":this.drawRects(e.args,t,"strokeRect");break;case"fillArc":this.fillArc(e.args,t);break;case"strokeArc":this.strokeArc(e.args,t);break;case"fillArcs":this.drawArcs(e.args,t,"fill");break;case"strokeArcs":this.drawArcs(e.args,t,"stroke");break;case"drawImage":yield this.drawImage(e.args,t);break;case"putImageData":this.putImageData(e.args,t);break;case"set":this.setAttr(e.attr,e.value);break;case"clear":this.clearCanvas();break;default:this.executeCommand(e.name,e.args)}})}drawRects(e,t,n){const s=o.getArg(e[0],t),i=o.getArg(e[1],t),a=o.getArg(e[2],t),r=o.getArg(e[3],t),c=Math.min(s.length,i.length,a.length,r.length);for(let e=0;e<c;++e)this.executeCommand(n,[s.getItem(e),i.getItem(e),a.getItem(e),r.getItem(e)])}fillArc(e,t){this.ctx.save(),this.ctx.beginPath(),this.executeCommand("arc",e),this.ctx.closePath(),this.ctx.fill(),this.ctx.restore()}strokeArc(e,t){this.ctx.save(),this.ctx.beginPath(),this.executeCommand("arc",e),this.ctx.closePath(),this.ctx.stroke(),this.ctx.restore()}drawArcs(e,t,n){const s=o.getArg(e[0],t),i=o.getArg(e[1],t),a=o.getArg(e[2],t),r=o.getArg(e[3],t),c=o.getArg(e[4],t),d=o.getArg(e[5],t),l=Math.min(s.length,i.length,a.length,r.length,c.length);this.ctx.save();for(let e=0;e<l;++e)this.ctx.beginPath(),this.ctx.arc(s.getItem(e),i.getItem(e),a.getItem(e),r.getItem(e),c.getItem(e),d.getItem(e)),this.ctx.closePath(),this.executeCommand(n);this.ctx.restore()}drawImage(e,t){return s(this,void 0,void 0,function*(){const[t,n,s,a,o]=e,r=yield i.unpack_models(t,this.widget_manager);if(r instanceof c)this._drawImage(r.canvas,n,s,a,o);else if("ImageModel"==r.get("_model_name")){let e;const t=r.get("format"),i=r.get("value");if("url"!==t){const n=new Blob([i],{type:`image/${t}`});e=URL.createObjectURL(n)}else e=new TextDecoder("utf-8").decode(i.buffer);const c=new Image;return new Promise(t=>{c.onload=()=>{this._drawImage(c,n,s,a,o),t()},c.src=e})}})}_drawImage(e,t,n,s,i){void 0===s||void 0===i?this.ctx.drawImage(e,t,n):this.ctx.drawImage(e,t,n,s,i)}putImageData(e,t){const[n,s,i]=e,a=n.shape[1],o=n.shape[0],c=new Uint8ClampedArray(t[0].buffer),d=new ImageData(c,a,o),l=document.createElement("canvas");l.width=a,l.height=o,r(l).putImageData(d,0,0),this.ctx.drawImage(l,s,i)}setAttr(e,t){this.ctx[e]=t}clearCanvas(){this.forEachView(e=>{e.clear()}),this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height)}executeCommand(e,t=[]){this.ctx[e](...t)}forEachView(e){for(const t in this.views)this.views[t].then(t=>{e(t)})}resizeCanvas(){this.canvas.setAttribute("width",this.get("width")),this.canvas.setAttribute("height",this.get("height"))}syncImageData(){return s(this,void 0,void 0,function*(){if(!this.get("sync_image_data"))return;const e=yield o.toBytes(this.canvas);this.set("image_data",e),this.save_changes()})}}c.serializers=Object.assign({},i.DOMWidgetModel.serializers,{image_data:{serialize:function(e){return new DataView(e.buffer.slice(0))},deserialize:function(e){return null===e?null:new Uint8ClampedArray(e.buffer)}}}),c.model_name="CanvasModel",c.model_module=a.MODULE_NAME,c.model_module_version=a.MODULE_VERSION,c.view_name="CanvasView",c.view_module=a.MODULE_NAME,c.view_module_version=a.MODULE_VERSION,t.CanvasModel=c;t.CanvasView=class extends i.DOMWidgetView{render(){this.canvas=document.createElement("canvas"),this.el.appendChild(this.canvas),this.ctx=r(this.canvas),this.resizeCanvas(),this.model.on_some_change(["width","height"],this.resizeCanvas,this),this.canvas.addEventListener("mousemove",{handleEvent:this.onMouseMove.bind(this)}),this.canvas.addEventListener("mousedown",{handleEvent:this.onMouseDown.bind(this)}),this.canvas.addEventListener("mouseup",{handleEvent:this.onMouseUp.bind(this)}),this.canvas.addEventListener("mouseout",{handleEvent:this.onMouseOut.bind(this)}),this.canvas.addEventListener("touchstart",{handleEvent:this.onTouchStart.bind(this)}),this.canvas.addEventListener("touchend",{handleEvent:this.onTouchEnd.bind(this)}),this.canvas.addEventListener("touchmove",{handleEvent:this.onTouchMove.bind(this)}),this.canvas.addEventListener("touchcancel",{handleEvent:this.onTouchCancel.bind(this)}),this.updateCanvas()}clear(){this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height)}updateCanvas(){this.clear(),this.ctx.drawImage(this.model.canvas,0,0)}resizeCanvas(){this.canvas.setAttribute("width",this.model.get("width")),this.canvas.setAttribute("height",this.model.get("height"))}onMouseMove(e){this.model.send(Object.assign({event:"mouse_move"},this.getCoordinates(e)),{})}onMouseDown(e){this.model.send(Object.assign({event:"mouse_down"},this.getCoordinates(e)),{})}onMouseUp(e){this.model.send(Object.assign({event:"mouse_up"},this.getCoordinates(e)),{})}onMouseOut(e){this.model.send(Object.assign({event:"mouse_out"},this.getCoordinates(e)),{})}onTouchStart(e){const t=Array.from(e.touches);this.model.send({event:"touch_start",touches:t.map(this.getCoordinates.bind(this))},{})}onTouchEnd(e){const t=Array.from(e.touches);this.model.send({event:"touch_end",touches:t.map(this.getCoordinates.bind(this))},{})}onTouchMove(e){const t=Array.from(e.touches);this.model.send({event:"touch_move",touches:t.map(this.getCoordinates.bind(this))},{})}onTouchCancel(e){const t=Array.from(e.touches);this.model.send({event:"touch_cancel",touches:t.map(this.getCoordinates.bind(this))},{})}getCoordinates(e){const t=this.canvas.getBoundingClientRect();return{x:e.clientX-t.left,y:e.clientY-t.top}}};class d extends i.DOMWidgetModel{defaults(){return Object.assign({},super.defaults(),{_model_name:d.model_name,_model_module:d.model_module,_model_module_version:d.model_module_version,_view_name:d.view_name,_view_module:d.view_module,_view_module_version:d.view_module_version,_canvases:[],sync_image_data:!1,image_data:null})}initialize(e,t){super.initialize(e,t),this.on("change:_canvases",this.updateListeners.bind(this)),this.on("change:sync_image_data",this.syncImageData.bind(this)),this.updateListeners()}updateListeners(){for(const e of this.get("_canvases"))e.on("new-frame",this.syncImageData,this)}syncImageData(){return s(this,void 0,void 0,function*(){if(!this.get("sync_image_data"))return;const e=document.createElement("canvas");e.width=this.get("width"),e.height=this.get("height");const t=r(e);for(const e of this.get("_canvases")){t.drawImage(e.canvas,0,0);const n=yield o.toBytes(e.canvas);e.set("image_data",n),e.save_changes()}const n=yield o.toBytes(e);this.set("image_data",n),this.save_changes()})}}d.serializers=Object.assign({},i.DOMWidgetModel.serializers,{_canvases:{deserialize:i.unpack_models},image_data:{serialize:e=>new DataView(e.buffer.slice(0))}}),d.model_name="MultiCanvasModel",d.model_module=a.MODULE_NAME,d.model_module_version=a.MODULE_VERSION,d.view_name="MultiCanvasView",d.view_module=a.MODULE_NAME,d.view_module_version=a.MODULE_VERSION,t.MultiCanvasModel=d;t.MultiCanvasView=class extends i.DOMWidgetView{render(){this.container=document.createElement("div"),this.container.style.position="relative",this.el.appendChild(this.container),this.canvas_views=new i.ViewList(this.createCanvasView,this.removeCanvasView,this),this.updateCanvasViews(),this.model.on("change:_canvases",this.updateCanvasViews.bind(this))}updateCanvasViews(){this.canvas_views.update(this.model.get("_canvases"))}createCanvasView(e,t){return this.create_child_view(e).then(e=>(e.el.style.zIndex=t,0==t?(e.el.style.position="relative",e.el.style.float="left"):e.el.style.position="absolute",this.container.appendChild(e.el),e))}removeCanvasView(e){this.container.removeChild(e.el)}}},function(t,n){t.exports=e},function(e,t,n){"use strict";var s,i=this&&this.__awaiter||function(e,t,n,s){return new(n||(n=Promise))(function(i,a){function o(e){try{c(s.next(e))}catch(e){a(e)}}function r(e){try{c(s.throw(e))}catch(e){a(e)}}function c(e){e.done?i(e.value):new n(function(t){t(e.value)}).then(o,r)}c((s=s.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),function(e){e.isScalar=function(e){return null===e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e}}(s||(s={}));class a{}t.Arg=a;class o extends a{constructor(e){super(),this.value=e,this.length=1/0}getItem(e){return this.value}}class r extends a{constructor(e,t){super(),this.value=function(e,t){switch(t.dtype){case"int32":return new Int32Array(e.buffer);default:throw"Unknown dtype "+t.dtype}}(t,e),this.length=this.value.length}getItem(e){return this.value[e]}}function c(e){return i(this,void 0,void 0,function*(){return new Promise((t,n)=>{e.toBlob(e=>{if(null==e)return n("Unable to create blob");t(e)})})})}t.getArg=function(e,t){if(s.isScalar(e))return new o(e);if(void 0!==e.idx)return new r(e,t[e.idx]);throw"Could not process argument "+e},t.toBlob=c,t.toBytes=function(e){return i(this,void 0,void 0,function*(){const t=yield c(e);return new Promise((e,n)=>{const s=new FileReader;s.onloadend=()=>{if("string"==typeof s.result||null==s.result)return n("Unable to read blob");const t=new Uint8ClampedArray(s.result);e(t)},s.readAsArrayBuffer(t)})})},t.fromBytes=function(e){return i(this,void 0,void 0,function*(){const t=new Blob([e]);return new Promise((e,n)=>{const s=new Image;s.onload=()=>{e(s)},s.src=URL.createObjectURL(t)})})}}])});
//# sourceMappingURL=index.js.map