# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Optional, TypeVar, Union, cast

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.polling.async_base_polling import AsyncLROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ..._operations._operations import build_analyze_conversation_request, build_conversation_analysis_request_initial
from .._vendor import MixinABC
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any] # pylint: disable=unsubscriptable-object
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class ConversationAnalysisClientOperationsMixin(MixinABC):

    @distributed_trace_async
    async def analyze_conversation(
        self,
        task: JSON,
        **kwargs: Any
    ) -> JSON:
        """Analyzes the input conversation utterance.

        :param task: A single conversational task to execute.
        :type task: JSON
        :return: JSON object
        :rtype: JSON
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                kind = 'ConversationalTask'

                # JSON input template you can fill out and use as your body input.
                task = {
                    kind: kind
                }

                # response body for status code(s): 200
                response.json() == {
                    kind: kind
                }
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-05-15-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]

        _json = task

        request = build_analyze_conversation_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)



    async def _conversation_analysis_initial(
        self,
        task: JSON,
        **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-05-15-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[JSON]]

        _json = task

        request = build_conversation_analysis_request_initial(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
            

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized



    @distributed_trace_async
    async def begin_conversation_analysis(
        self,
        task: JSON,
        **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Submit analysis job for conversations.

        Submit a collection of conversations for analysis. Specify one or more unique tasks to be
        executed.

        :param task: The collection of conversations to analyze and one or more tasks to execute.
        :type task: JSON
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncLROBasePolling. Pass in False
         for this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns JSON object
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                task = {
                    "analysisInput": {
                        "conversations": [
                            {
                                "domain": "str",  # Optional. Enumeration of
                                  supported conversational domains. Known values are: "finance",
                                  "healthcare", "generic".
                                "id": "str",  # Required. Unique identifier for the
                                  conversation.
                                "language": "str",  # Required. The language of the
                                  conversation item in BCP-47 format.
                                modality: modality
                            }
                        ]
                    },
                    "displayName": "str",  # Optional. Optional display name for the analysis
                      job.
                    "tasks": [
                        {
                            "taskName": "str",  # Optional. Required. The set of tasks to
                              execute on the input conversation.
                            kind: AnalyzeConversationLROTask
                        }
                    ]
                }

                # response body for status code(s): 200
                response.json() == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Required.
                    "displayName": "str",  # Optional.
                    "errors": [
                        {
                            "code": "str",  # Required. One of a server-defined set of
                              error codes. Known values are: "InvalidRequest", "InvalidArgument",
                              "Unauthorized", "Forbidden", "NotFound", "ProjectNotFound",
                              "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable", "Timeout", "QuotaExceeded", "Conflict", "Warning".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # Required. One of a server-defined
                                  set of error codes. Known values are: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure", "InvalidRequestBodyFormat", "EmptyRequest",
                                  "MissingInputDocuments", "InvalidDocument", "ModelVersionIncorrect",
                                  "InvalidDocumentBatch", "UnsupportedLanguageCode",
                                  "InvalidCountryHint".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Required. Error message.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # Required. A human-readable
                              representation of the error.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional.
                    "jobId": "str",  # Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Required.
                    "nextLink": "str",  # Optional.
                    "statistics": {
                        "conversationsCount": 0,  # Required. Number of conversations
                          submitted in the request.
                        "erroneousConversationsCount": 0,  # Required. Number of invalid
                          documents. This includes empty, over-size limit or non-supported languages
                          documents.
                        "transactionsCount": 0.0,  # Required. Number of transactions for the
                          request.
                        "validConversationsCount": 0  # Required. Number of conversations
                          documents. This excludes empty, over-size limit or non-supported languages
                          documents.
                    },
                    "status": "str",  # Required. Known values are: "notStarted", "running",
                      "succeeded", "partiallyCompleted", "failed", "cancelled", "cancelling".
                    "tasks": {
                        "completed": 0,  # Required. Count of tasks completed successfully.
                        "failed": 0,  # Required. Count of tasks that failed.
                        "inProgress": 0,  # Required. Count of tasks in progress currently.
                        "items": [
                            {
                                "lastUpdateDateTime": "2020-02-20 00:00:00",  #
                                  Required. The last updated time in UTC for the task.
                                "status": "str",  # Required. The status of the task
                                  at the mentioned last update time. Known values are: "notStarted",
                                  "running", "succeeded", "failed", "cancelled", "cancelling".
                                "taskName": "str",  # Optional. List of results from
                                  tasks (if available).
                                kind: AnalyzeConversationJobResult
                            }
                        ],
                        "total": 0  # Required. Total count of tasks submitted as part of the
                          job.
                    }
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2022-05-15-preview"))  # type: str
        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[JSON]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._conversation_analysis_initial(  # type: ignore
                task=task,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True:
            polling_method = cast(AsyncPollingMethod, AsyncLROBasePolling(
                lro_delay,
                
                path_format_arguments=path_format_arguments,
                **kwargs
        ))  # type: AsyncPollingMethod
        elif polling is False: polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)


