# coding: utf-8

"""
    Bacalhau API

    This page is the reference of the Bacalhau REST API. Project docs are available at https://docs.bacalhau.org/. Find more information about Bacalhau at https://github.com/bacalhau-project/bacalhau.  # noqa: E501

    OpenAPI spec version: 0.3.23.post7
    Contact: team@bacalhau.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class StorageSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cid': 'str',
        'metadata': 'dict(str, str)',
        'name': 'str',
        'source_path': 'str',
        'storage_source': 'AllOfStorageSpecStorageSource',
        'url': 'str',
        'path': 'str'
    }

    attribute_map = {
        'cid': 'CID',
        'metadata': 'Metadata',
        'name': 'Name',
        'source_path': 'SourcePath',
        'storage_source': 'StorageSource',
        'url': 'URL',
        'path': 'path'
    }

    def __init__(self, cid=None, metadata=None, name=None, source_path=None, storage_source=None, url=None, path=None):  # noqa: E501
        """StorageSpec - a model defined in Swagger"""  # noqa: E501
        self._cid = None
        self._metadata = None
        self._name = None
        self._source_path = None
        self._storage_source = None
        self._url = None
        self._path = None
        self.discriminator = None
        if cid is not None:
            self.cid = cid
        if metadata is not None:
            self.metadata = metadata
        if name is not None:
            self.name = name
        if source_path is not None:
            self.source_path = source_path
        if storage_source is not None:
            self.storage_source = storage_source
        if url is not None:
            self.url = url
        if path is not None:
            self.path = path

    @property
    def cid(self):
        """Gets the cid of this StorageSpec.  # noqa: E501

        The unique ID of the data, where it makes sense (for example, in an IPFS storage spec this will be the data's CID). NOTE: The below is capitalized to match IPFS & IPLD (even though it's out of golang fmt)  # noqa: E501

        :return: The cid of this StorageSpec.  # noqa: E501
        :rtype: str
        """
        return self._cid

    @cid.setter
    def cid(self, cid):
        """Sets the cid of this StorageSpec.

        The unique ID of the data, where it makes sense (for example, in an IPFS storage spec this will be the data's CID). NOTE: The below is capitalized to match IPFS & IPLD (even though it's out of golang fmt)  # noqa: E501

        :param cid: The cid of this StorageSpec.  # noqa: E501
        :type: str
        """

        self._cid = cid

    @property
    def metadata(self):
        """Gets the metadata of this StorageSpec.  # noqa: E501

        Additional properties specific to each driver  # noqa: E501

        :return: The metadata of this StorageSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this StorageSpec.

        Additional properties specific to each driver  # noqa: E501

        :param metadata: The metadata of this StorageSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._metadata = metadata

    @property
    def name(self):
        """Gets the name of this StorageSpec.  # noqa: E501

        Name of the spec's data, for reference.  # noqa: E501

        :return: The name of this StorageSpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this StorageSpec.

        Name of the spec's data, for reference.  # noqa: E501

        :param name: The name of this StorageSpec.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def source_path(self):
        """Gets the source_path of this StorageSpec.  # noqa: E501

        The path of the host data if we are using local directory paths  # noqa: E501

        :return: The source_path of this StorageSpec.  # noqa: E501
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """Sets the source_path of this StorageSpec.

        The path of the host data if we are using local directory paths  # noqa: E501

        :param source_path: The source_path of this StorageSpec.  # noqa: E501
        :type: str
        """

        self._source_path = source_path

    @property
    def storage_source(self):
        """Gets the storage_source of this StorageSpec.  # noqa: E501

        StorageSource is the abstract source of the data. E.g. a storage source might be a URL download, but doesn't specify how the execution engine does the download or what it will do with the downloaded data.  # noqa: E501

        :return: The storage_source of this StorageSpec.  # noqa: E501
        :rtype: AllOfStorageSpecStorageSource
        """
        return self._storage_source

    @storage_source.setter
    def storage_source(self, storage_source):
        """Sets the storage_source of this StorageSpec.

        StorageSource is the abstract source of the data. E.g. a storage source might be a URL download, but doesn't specify how the execution engine does the download or what it will do with the downloaded data.  # noqa: E501

        :param storage_source: The storage_source of this StorageSpec.  # noqa: E501
        :type: AllOfStorageSpecStorageSource
        """

        self._storage_source = storage_source

    @property
    def url(self):
        """Gets the url of this StorageSpec.  # noqa: E501

        Source URL of the data  # noqa: E501

        :return: The url of this StorageSpec.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this StorageSpec.

        Source URL of the data  # noqa: E501

        :param url: The url of this StorageSpec.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def path(self):
        """Gets the path of this StorageSpec.  # noqa: E501

        The path that the spec's data should be mounted on, where it makes sense (for example, in a Docker storage spec this will be a filesystem path). TODO: #668 Replace with \"Path\" (note the caps) for yaml/json when we update the n.js file  # noqa: E501

        :return: The path of this StorageSpec.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this StorageSpec.

        The path that the spec's data should be mounted on, where it makes sense (for example, in a Docker storage spec this will be a filesystem path). TODO: #668 Replace with \"Path\" (note the caps) for yaml/json when we update the n.js file  # noqa: E501

        :param path: The path of this StorageSpec.  # noqa: E501
        :type: str
        """

        self._path = path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(StorageSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StorageSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
