# AUTOGENERATED FROM: babilim/model/sequential.ipynb

# Cell: 0
"""doc
# babilim.model.sequential

> Sequentially combine modules into a model.
"""

# Cell: 1
from babilim.core.annotations import RunOnlyOnce
from babilim.core.module import Module


# Cell: 2
class Sequential(Module):
    def __init__(self, *layers):
        """
        Create a module which is a sequential order of other layers.
    
        Runs the layers in order.
        
        ```python
        my_seq = Sequential(layer1, layer2, layer3)
        ```
        
        :param layers: All ordered parameters are used as layers.
        """
        super().__init__()
        self.layers = layers

    def call(self, features):
        """
        Do not call this directly, use `__call__`:
        ```
        my_seq(features)
        ```
        """
        tmp = features
        for layer in self.layers:
            tmp = layer(tmp)
        return tmp
