# Generated by Django 3.1.10 on 2021-05-12 19:51

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("eveuniverse", "0005_type_materials_and_sections"),
        ("eveonline", "0014_auto_20210105_1413"),
        ("standingsrequests", "0006_add_user_to_revocations"),
    ]

    operations = [
        migrations.CreateModel(
            name="CharacterAffiliation",
            fields=[
                (
                    "character",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="character_affiliation",
                        serialize=False,
                        to="eveuniverse.eveentity",
                    ),
                ),
                ("updated", models.DateTimeField(auto_now_add=True)),
                (
                    "alliance",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "corporation",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "eve_character",
                    models.ForeignKey(
                        default=None,
                        help_text="Related auth character (if any)",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "faction",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Contact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("standing", models.FloatField(db_index=True)),
                ("is_watched", models.BooleanField(default=False)),
                (
                    "contact_set",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="contacts",
                        to="standingsrequests.contactset",
                    ),
                ),
                (
                    "eve_entity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="standingrequests_contact",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CorporationDetails",
            fields=[
                (
                    "corporation",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        related_name="corporation_details",
                        serialize=False,
                        to="eveuniverse.eveentity",
                    ),
                ),
                ("member_count", models.PositiveIntegerField()),
                ("ticker", models.CharField(max_length=255)),
                (
                    "alliance",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "ceo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "faction",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="+",
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
        ),
        migrations.RemoveField(
            model_name="alliancecontact",
            name="contact_set",
        ),
        migrations.RemoveField(
            model_name="alliancecontact",
            name="labels",
        ),
        migrations.DeleteModel(
            name="CharacterAssociation",
        ),
        migrations.RemoveField(
            model_name="charactercontact",
            name="contact_set",
        ),
        migrations.RemoveField(
            model_name="charactercontact",
            name="labels",
        ),
        migrations.RemoveField(
            model_name="corporationcontact",
            name="contact_set",
        ),
        migrations.RemoveField(
            model_name="corporationcontact",
            name="labels",
        ),
        migrations.DeleteModel(
            name="EveEntity",
        ),
        migrations.AlterField(
            model_name="contactlabel",
            name="contact_set",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="labels",
                to="standingsrequests.contactset",
            ),
        ),
        migrations.DeleteModel(
            name="AllianceContact",
        ),
        migrations.DeleteModel(
            name="CharacterContact",
        ),
        migrations.DeleteModel(
            name="CorporationContact",
        ),
        migrations.AddField(
            model_name="contact",
            name="labels",
            field=models.ManyToManyField(
                related_name="contacts", to="standingsrequests.ContactLabel"
            ),
        ),
    ]
