# Fancy Aggregations  [![DOI](https://zenodo.org/badge/221485987.svg)](https://zenodo.org/badge/latestdoi/221485987)

Fanzy Aggregations is a package written in python that implements modern functions to aggregate data using Choquet integral, CF12 generalization, Sugeno, etc. More are to come. Our target is to give a wide range of functions to work with and to generate/use different fuzzy measures.

## Implemented functions

- Choquet Integral
- Choquet Integral CF and CF<sub>1,2</sub>
- Sugeno integral and generalizations.
- Wide range of T-norms (and T-conorms).
- Implication operators.
- OWA operators.
- Penalty functions.
- MD deviations.
- N-Overlap functions.

## Reference papers
Each file contains the correspondent paper in its header. Here it is the whole list:

<a id="1"> [1]  A.H. Altalhi, J.I. Forcén, M. Pagola, E. Barrenechea, H. Bustince, Zdenko Takáč,
Moderate deviation and restricted equivalence functions for measuring similarity between data,
Information Sciences,Volume 501,
2019,
Pages 19-29,
ISSN 0020-0255,
https://doi.org/10.1016/j.ins.2019.05.078.
(http://www.sciencedirect.com/science/article/pii/S0020025519305031)

<a id="2"> [2] Bustince, H., Beliakov, G., Dimuro, G. P., Bedregal, B., & Mesiar, R. (2017). 
On the definition of penalty functions in data aggregation. Fuzzy Sets and Systems, 323, 1-18.

<a id="3"> [3] A. Jurio, M. Pagola, R. Mesiar, G. Beliakov and H. Bustince, "Image Magnification Using Interval Information," 
in IEEE Transactions on Image Processing, vol. 20, no. 11, pp. 3112-3123, Nov. 2011.
doi: 10.1109/TIP.2011.2158227
URL: http://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=5782984&isnumber=6045652


<a id="4"> [4] Graçaliz Pereira Dimuro, Giancarlo Lucca, Benjamín Bedregal, Radko Mesiar, José Antonio Sanz, Chin-Teng Lin, Humberto Bustince,
Generalized CF1F2-integrals: From Choquet-like aggregation to ordered directionally monotone functions,
Fuzzy Sets and Systems,
Volume 378,
2020,
Pages 44-67,
ISSN 0165-0114,
https://doi.org/10.1016/j.fss.2019.01.009.
(http://www.sciencedirect.com/science/article/pii/S0165011418305451)

<a id="5"> [5] Beliakov, G., Sola, H. B., & Sánchez, T. C. (2016). A practical guide to averaging functions (Vol. 329). Heidelberg: Springer.

### Mandatory
* Numpy
