/*
 * Decompiled with CFR 0.152.
 */
package jap;

import jap.Alignment;
import jap.AminoAcidAlignment;
import jap.NucleotideAlignment;
import java.util.ArrayList;
import java.util.Arrays;

public class CodonAlignment
extends Alignment {
    private final String[] codonCharacter = new String[]{"GCT", "GCC", "GCA", "GCG", "GCU", "GCX", "GCM", "GCR", "GCW", "GCS", "GCY", "GCK", "GCB", "GCD", "GCH", "GCV", "CGT", "CGC", "CGA", "CGG", "AGA", "AGG", "CGU", "CGX", "AGR", "MGX", "CGM", "CGR", "CGW", "CGS", "CGY", "CGK", "CGB", "CGD", "CGH", "CGV", "AAT", "AAC", "AAU", "AAY", "GAT", "GAC", "GAU", "GAY", "TGT", "TGC", "UGU", "UGC", "TGY", "UGY", "CAA", "CAG", "CAR", "GAA", "GAG", "GAR", "GGT", "GGC", "GGA", "GGG", "GGU", "GGX", "GGM", "GGR", "GGW", "GGS", "GGY", "GGK", "GGB", "GGD", "GGH", "GGV", "CAT", "CAC", "CAU", "CAY", "ATT", "ATC", "ATA", "AUU", "AUC", "AUA", "ATH", "AUH", "TTA", "TTG", "CTT", "CTC", "CTA", "CTG", "UUA", "UUG", "CUU", "CUC", "CUA", "CUG", "TTR", "CTX", "YTX", "UUR", "CUX", "YUX", "CTM", "CTR", "CTW", "CTS", "CTY", "CTK", "CTB", "CTD", "CTH", "CTV", "CUM", "CUR", "CUW", "CUS", "CUY", "CUK", "CUB", "CUD", "CUH", "CUV", "YTM", "YTR", "YTW", "YTS", "YTY", "YTK", "YTB", "YTD", "YTH", "YTV", "YUM", "YUR", "YUW", "YUS", "YUY", "YUK", "YUB", "YUD", "YUH", "YUV", "AAA", "AAG", "AAR", "ATG", "AUG", "TTT", "TTC", "UUU", "UUC", "TTY", "UUY", "CCT", "CCC", "CCA", "CCG", "CCU", "CCX", "CCM", "CCR", "CCW", "CCS", "CCY", "CCK", "CCB", "CCD", "CCH", "CCV", "TCT", "TCC", "TCA", "TCG", "AGT", "AGC", "UCU", "UCC", "UCA", "UCG", "ACU", "TCX", "UCX", "AGY", "WSX", "TCM", "TCR", "TCW", "TCS", "TCY", "TCK", "TCB", "TCD", "TCH", "TCV", "UCM", "UCR", "UCW", "UCS", "UCY", "UCK", "UCB", "UCD", "UCH", "UCV", "WSM", "WSR", "WSW", "WSS", "WSY", "WSK", "WSB", "WSD", "WSH", "WSV", "ACT", "ACC", "ACA", "ACG", "ACU", "ACX", "ACM", "ACR", "ACW", "ACS", "ACY", "ACK", "ACB", "ACD", "ACH", "ACV", "TGG", "UGG", "TAT", "TAC", "UAU", "UAC", "TAY", "UAY", "GTT", "GTC", "GTA", "GTG", "GUU", "GUC", "GUA", "GUG", "GTX", "GUX", "GTM", "GTR", "GTW", "GTS", "GTY", "GTK", "GTB", "GTD", "GTH", "GTV", "GUM", "GUR", "GUW", "GUS", "GUY", "GUK", "GUB", "GUD", "GUH", "GUV", "XXX", "???", "---"};
    private final char[] aaCharacter = new char[]{'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'R', 'N', 'N', 'N', 'N', 'D', 'D', 'D', 'D', 'C', 'C', 'C', 'C', 'C', 'C', 'Q', 'Q', 'Q', 'E', 'E', 'E', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'G', 'H', 'H', 'H', 'H', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'K', 'K', 'K', 'M', 'M', 'F', 'F', 'F', 'F', 'F', 'F', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'T', 'W', 'W', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'V', 'X', '?', '-'};
    private final int A = 0;
    private final int R = 1;
    private final int N = 2;
    private final int D = 3;
    private final int C = 4;
    private final int Q = 5;
    private final int E = 6;
    private final int G = 7;
    private final int H = 8;
    private final int I = 9;
    private final int L = 10;
    private final int K = 11;
    private final int M = 12;
    private final int F = 13;
    private final int P = 14;
    private final int S = 15;
    private final int T = 16;
    private final int W = 17;
    private final int Y = 18;
    private final int V = 19;
    private NucleotideAlignment dnaAlignment;
    private static ArrayList<String> codonAlphabet;
    private static ArrayList<Character> aminoAcidAlphabet;
    private static int i;
    private static int j;
    private static int c;
    private static int cc;
    private static int cs;
    private static String codon;
    private static char ch;
    private static StringBuffer sb;
    private static double[] freq;
    private static double total;
    private static boolean rna;
    private static AminoAcidAlignment aaAlig;
    private static CodonAlignment coAlig;
    private static NucleotideAlignment dnaAlig;

    public CodonAlignment() {
        codonAlphabet = new ArrayList();
        aminoAcidAlphabet = new ArrayList();
        i = -1;
        while (++i < this.codonCharacter.length) {
            codonAlphabet.add(this.codonCharacter[i]);
            aminoAcidAlphabet.add(new Character(this.aaCharacter[i]));
        }
        this.dnaAlignment = new NucleotideAlignment();
    }

    public static char toAminoAcidCharacter(String string) {
        cc = codonAlphabet.indexOf(string);
        if (cc != -1) {
            return aminoAcidAlphabet.get(cc).charValue();
        }
        return 'X';
    }

    public static String toAminoAcidSequence(String string) {
        sb = new StringBuffer(string.substring(0, string.length() / 3));
        cs = 0;
        while (cs < sb.length()) {
            sb.setCharAt(cs, CodonAlignment.toAminoAcidCharacter(string.substring(3 * cs, 3 * ++cs)));
        }
        return sb.toString();
    }

    public static String filter(String string) {
        sb = new StringBuffer(string);
        i = 0;
        while (i < sb.length() / 3) {
            if (codonAlphabet.contains(string.substring(3 * i, 3 * ++i))) continue;
            i = i - 1;
            sb = sb.replace(3 * i, 3 * ++i, "XXX");
        }
        return sb.toString();
    }

    @Override
    public boolean add(String string) {
        if (string.length() % 3 == 0 && super.add(CodonAlignment.toAminoAcidSequence(string))) {
            return this.dnaAlignment.add(string, super.getLabel(super.size() - 1));
        }
        return false;
    }

    @Override
    public boolean add(String string, String string2) {
        if (string.length() % 3 == 0 && super.add(CodonAlignment.toAminoAcidSequence(string), string2)) {
            return this.dnaAlignment.add(string, string2);
        }
        return false;
    }

    @Override
    public boolean add(int n, String string) {
        if (string.length() % 3 == 0 && super.add(n, CodonAlignment.toAminoAcidSequence(string))) {
            return this.dnaAlignment.add(n, string, super.getLabel(super.size() - 1));
        }
        return false;
    }

    @Override
    public boolean add(int n, String string, String string2) {
        if (string.length() % 3 == 0 && super.add(n, CodonAlignment.toAminoAcidSequence(string), string2)) {
            return this.dnaAlignment.add(n, string, string2);
        }
        return false;
    }

    @Override
    public boolean set(int n, String string) {
        if (string.length() % 3 == 0 && super.set(n, CodonAlignment.toAminoAcidSequence(string))) {
            return this.dnaAlignment.set(n, string);
        }
        return false;
    }

    @Override
    public boolean set(int n, String string, String string2) {
        if (string.length() % 3 == 0 && super.set(n, CodonAlignment.toAminoAcidSequence(string), string2)) {
            return this.dnaAlignment.set(n, string, string2);
        }
        return false;
    }

    @Override
    public boolean removeColumn(int n) {
        j = 3 * n;
        if (super.removeColumn(n)) {
            return this.dnaAlignment.removeColumn(j) && this.dnaAlignment.removeColumn(j) && this.dnaAlignment.removeColumn(j);
        }
        return false;
    }

    @Override
    public String getSequence(int n) {
        return this.dnaAlignment.getSequence(n);
    }

    @Override
    public boolean setCharAt(int n, int n2, char c) {
        if (!aminoAcidAlphabet.contains(new Character(c))) {
            return false;
        }
        if (super.setCharAt(n, n2, c)) {
            rna = this.dnaAlignment.isRNA();
            switch (c) {
                case 'A': {
                    codon = "GCX";
                    break;
                }
                case 'R': {
                    codon = "MGX";
                    break;
                }
                case 'N': {
                    codon = "AAY";
                    break;
                }
                case 'D': {
                    codon = "GAY";
                    break;
                }
                case 'C': {
                    if (rna) {
                        codon = "UGY";
                        break;
                    }
                    codon = "TGY";
                    break;
                }
                case 'Q': {
                    codon = "CAR";
                    break;
                }
                case 'E': {
                    codon = "GAR";
                    break;
                }
                case 'G': {
                    codon = "GGX";
                    break;
                }
                case 'H': {
                    codon = "CAY";
                    break;
                }
                case 'I': {
                    if (rna) {
                        codon = "AUH";
                        break;
                    }
                    codon = "ATH";
                    break;
                }
                case 'L': {
                    if (rna) {
                        codon = "YUX";
                        break;
                    }
                    codon = "YTX";
                    break;
                }
                case 'K': {
                    codon = "AAR";
                    break;
                }
                case 'M': {
                    if (rna) {
                        codon = "AUG";
                        break;
                    }
                    codon = "ATG";
                    break;
                }
                case 'F': {
                    if (rna) {
                        codon = "UUY";
                        break;
                    }
                    codon = "TTY";
                    break;
                }
                case 'P': {
                    codon = "CCX";
                    break;
                }
                case 'S': {
                    codon = "WSX";
                    break;
                }
                case 'T': {
                    codon = "ACX";
                    break;
                }
                case 'W': {
                    if (rna) {
                        codon = "UGG";
                        break;
                    }
                    codon = "TGG";
                    break;
                }
                case 'Y': {
                    if (rna) {
                        codon = "UAY";
                        break;
                    }
                    codon = "TAY";
                    break;
                }
                case 'V': {
                    if (rna) {
                        codon = "GUX";
                        break;
                    }
                    codon = "GTX";
                    break;
                }
                case 'X': {
                    codon = "XXX";
                    break;
                }
                case '-': {
                    codon = "---";
                    break;
                }
                default: {
                    codon = "???";
                }
            }
            return this.dnaAlignment.setCharAt(n, 3 * n2, codon.charAt(0)) && this.dnaAlignment.setCharAt(n, 3 * n2 + 1, codon.charAt(1)) && this.dnaAlignment.setCharAt(n, 3 * n2 + 2, codon.charAt(2));
        }
        return false;
    }

    @Override
    public String getCodonAt(int n, int n2) {
        if (super.size() > n && n >= 0 && super.length() > n2 && n2 >= 0) {
            return this.dnaAlignment.getSequence(n).substring(3 * n2, 3 * (n2 + 1));
        }
        return null;
    }

    @Override
    public boolean setCodonAt(int n, int n2, String string) {
        return codonAlphabet.contains(string) && super.setCharAt(n, n2, CodonAlignment.toAminoAcidCharacter(string)) && this.dnaAlignment.setCharAt(n, 3 * n2, string.charAt(0)) && this.dnaAlignment.setCharAt(n, 3 * n2 + 1, string.charAt(1)) && this.dnaAlignment.setCharAt(n, 3 * n2 + 2, string.charAt(2));
    }

    @Override
    public int getAlphabetSize() {
        return 20;
    }

    @Override
    public double[] getFrequencies(int n) {
        freq = new double[this.getAlphabetSize()];
        Arrays.fill(freq, 0.0);
        total = 0.0;
        i = -1;
        block25: while (++i < super.size()) {
            total += 1.0;
            switch (super.getSequence(i).charAt(n)) {
                case 'A': {
                    freq[0] = freq[0] + 1.0;
                    continue block25;
                }
                case 'R': {
                    freq[1] = freq[1] + 1.0;
                    continue block25;
                }
                case 'N': {
                    freq[2] = freq[2] + 1.0;
                    continue block25;
                }
                case 'D': {
                    freq[3] = freq[3] + 1.0;
                    continue block25;
                }
                case 'C': {
                    freq[4] = freq[4] + 1.0;
                    continue block25;
                }
                case 'Q': {
                    freq[5] = freq[5] + 1.0;
                    continue block25;
                }
                case 'E': {
                    freq[6] = freq[6] + 1.0;
                    continue block25;
                }
                case 'G': {
                    freq[7] = freq[7] + 1.0;
                    continue block25;
                }
                case 'H': {
                    freq[8] = freq[8] + 1.0;
                    continue block25;
                }
                case 'I': {
                    freq[9] = freq[9] + 1.0;
                    continue block25;
                }
                case 'L': {
                    freq[10] = freq[10] + 1.0;
                    continue block25;
                }
                case 'K': {
                    freq[11] = freq[11] + 1.0;
                    continue block25;
                }
                case 'M': {
                    freq[12] = freq[12] + 1.0;
                    continue block25;
                }
                case 'F': {
                    freq[13] = freq[13] + 1.0;
                    continue block25;
                }
                case 'P': {
                    freq[14] = freq[14] + 1.0;
                    continue block25;
                }
                case 'S': {
                    freq[15] = freq[15] + 1.0;
                    continue block25;
                }
                case 'T': {
                    freq[16] = freq[16] + 1.0;
                    continue block25;
                }
                case 'W': {
                    freq[17] = freq[17] + 1.0;
                    continue block25;
                }
                case 'Y': {
                    freq[18] = freq[18] + 1.0;
                    continue block25;
                }
                case 'V': {
                    freq[19] = freq[19] + 1.0;
                    continue block25;
                }
                case 'B': {
                    freq[3] = freq[3] + 0.5;
                    freq[2] = freq[2] + 0.5;
                    continue block25;
                }
                case 'Z': {
                    freq[5] = freq[5] + 0.5;
                    freq[6] = freq[6] + 0.5;
                    continue block25;
                }
                case 'X': {
                    c = -1;
                    while (++c < this.getAlphabetSize()) {
                        int n2 = c;
                        freq[n2] = freq[n2] + 0.05;
                    }
                    continue block25;
                }
            }
            total -= 1.0;
        }
        c = -1;
        while (++c < this.getAlphabetSize()) {
            int n3 = c;
            freq[n3] = freq[n3] / total;
        }
        return freq;
    }

    @Override
    public AminoAcidAlignment toAminoAcidAlignment() {
        aaAlig = new AminoAcidAlignment();
        i = -1;
        while (++i < super.size()) {
            aaAlig.add(super.getSequence(i), super.getLabel(i));
        }
        return aaAlig;
    }

    @Override
    public NucleotideAlignment toNucleotideAlignment() {
        return this.toNucleotideAlignment(7);
    }

    @Override
    public NucleotideAlignment toNucleotideAlignment(int n) {
        dnaAlig = new NucleotideAlignment();
        if (n <= 0 || n > 7) {
            return dnaAlig;
        }
        i = -1;
        while (++i < super.size()) {
            dnaAlig.add(this.dnaAlignment.getSequence(i), super.getLabel(i));
        }
        if (n == 7) {
            return dnaAlig;
        }
        switch (n) {
            case 4: 
            case 6: {
                c = 0;
                break;
            }
            case 5: {
                c = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                c = 2;
            }
        }
        j = super.length();
        while (--j >= 0) {
            dnaAlig.removeColumn(3 * j + c);
        }
        if (n == 3 || n == 5 || n == 6) {
            return dnaAlig;
        }
        switch (n) {
            case 4: {
                c = 1;
                break;
            }
            case 2: {
                c = 0;
                break;
            }
            case 1: {
                c = 1;
            }
        }
        j = dnaAlig.length();
        while (--j >= 0) {
            dnaAlig.removeColumn(2 * j + c);
        }
        return dnaAlig;
    }

    @Override
    public CodonAlignment toCodonAlignment() {
        coAlig = new CodonAlignment();
        i = -1;
        while (++i < super.size()) {
            coAlig.add(this.dnaAlignment.getSequence(i), super.getLabel(i));
        }
        return coAlig;
    }

    @Override
    public NucleotideAlignment toRYcodingAlignment() {
        dnaAlig = new NucleotideAlignment();
        i = -1;
        while (++i < super.size()) {
            dnaAlig.add(this.dnaAlignment.getSequence(i), super.getLabel(i));
            j = -1;
            block7: while (++j < dnaAlig.length()) {
                ch = dnaAlig.charAt(i, j);
                switch (ch) {
                    case 'A': 
                    case 'G': {
                        dnaAlig.setCharAt(i, j, 'R');
                        continue block7;
                    }
                    case 'C': 
                    case 'T': {
                        dnaAlig.setCharAt(i, j, 'Y');
                        continue block7;
                    }
                    case '?': {
                        dnaAlig.setCharAt(i, j, '?');
                        continue block7;
                    }
                    case '-': {
                        dnaAlig.setCharAt(i, j, '-');
                        continue block7;
                    }
                }
                dnaAlig.setCharAt(i, j, 'X');
            }
        }
        return dnaAlig;
    }
}

