/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.hash.IntSet;

public final class IntObjMap<E>
extends IntSet {
    private Object[] values = new Object[this.capacity()];

    public E put(int key, E value) {
        int i = this.put(key);
        Object v = this.values[i];
        this.values[i] = value;
        return (E)v;
    }

    public E computeIfAbsent(int key, Supplier<? extends E> func) {
        E value = this.get(key);
        if (value == null) {
            value = func.get();
            this.put(key, value);
        }
        return value;
    }

    public E get(int key) {
        return (E)this.values[this.id(key)];
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Array.copy(this.values, new Object[newSize]);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    public String toString() {
        ArrayList<Integer> k = new ArrayList<Integer>();
        for (int key : this.keys) {
            k.add(key);
        }
        return this.toString(k.toArray(), this.values);
    }
}

