/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.query.QueryTracer;
import org.basex.server.LogFile;
import org.basex.util.DateTime;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Log
implements QueryTracer {
    public static final String SERVER = "SERVER";
    private final StaticOptions sopts;
    private LogFile file;

    public Log(StaticOptions sopts) {
        this.sopts = sopts;
    }

    public LogFile file(String name) {
        LogFile lf = this.file;
        if (lf == null || !lf.valid(name)) {
            lf = new LogFile(name, this.dir());
        }
        return lf.exists() ? lf : null;
    }

    public void writeServer(LogType type, String info) {
        this.write(type.toString(), info, null, null, null);
    }

    public void write(LogType type, String info, Performance perf, Context ctx) {
        this.write(type.toString(), info, perf, ctx);
    }

    public void write(LogType type, String info, Performance perf, String address, Context ctx) {
        this.write(type.toString(), info, perf, address, ctx.clientName());
    }

    public void write(Object type, String info, Performance perf, Context ctx) {
        this.write(type.toString(), info, perf, ctx.clientAddress(), ctx.clientName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String type, String info, Performance perf, String address, String user) {
        if (!this.sopts.get(StaticOptions.LOG).booleanValue()) {
            return;
        }
        Date date = new Date();
        int ml = this.sopts.get(StaticOptions.LOGMSGMAXLEN);
        TokenBuilder tb = new TokenBuilder();
        tb.add(DateTime.format(date, DateTime.TIME));
        tb.add(9).add(address != null ? address.replaceFirst("^/", "") : SERVER);
        tb.add(9).add(user != null ? user : "admin");
        tb.add(9).add(type);
        tb.add(9).add(info != null ? Token.chop(Token.normalize(Token.token(info)), ml) : Token.EMPTY);
        if (perf != null) {
            tb.add(9).add(perf);
        }
        tb.add(Prop.NL);
        try {
            StaticOptions staticOptions = this.sopts;
            synchronized (staticOptions) {
                String name = DateTime.format(date, DateTime.DATE);
                if (this.file != null && !this.file.valid(name)) {
                    this.close();
                }
                if (this.file == null) {
                    this.file = LogFile.create(name, this.dir());
                }
                this.file.write(tb.finish());
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            StaticOptions staticOptions = this.sopts;
            synchronized (staticOptions) {
                if (this.file != null) {
                    this.file.close();
                    this.file = null;
                }
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public IOFile[] files() {
        return this.dir().children(".*\\.log");
    }

    private IOFile dir() {
        return this.sopts.dbPath(".").resolve(this.sopts.get(StaticOptions.LOGPATH));
    }

    @Override
    public boolean print(String info) {
        this.writeServer(LogType.TRACE, info);
        return false;
    }

    public static enum LogType {
        REQUEST,
        TRACE,
        INFO,
        ERROR,
        OK;

    }
}

