/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.EnumMap;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class FuncType
implements Type {
    static final String[] WILDCARD = new String[]{"*"};
    public final AnnList anns;
    public final SeqType declType;
    public final SeqType[] argTypes;
    private EnumMap<Occ, SeqType> seqTypes;

    FuncType(SeqType declType, SeqType ... argTypes) {
        this(new AnnList(), declType, argTypes);
    }

    private FuncType(AnnList anns, SeqType declType, SeqType ... argTypes) {
        this.anns = anns;
        this.declType = declType == null ? SeqType.ITEM_ZM : declType;
        this.argTypes = argTypes;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public final boolean isSortable() {
        return false;
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public FItem cast(Item item, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        if (!(item instanceof FItem)) {
            throw QueryError.typeError(item, this, ii);
        }
        FItem func = (FItem)item;
        return this == SeqType.FUNCTION ? func : func.coerceTo(this, qc, ii, false);
    }

    @Override
    public final Item cast(Object value, QueryContext qc, StaticContext sc, InputInfo ii) {
        throw Util.notExpected(value, new Object[0]);
    }

    @Override
    public final Item castString(String string, QueryContext qc, StaticContext sc, InputInfo ii) {
        throw Util.notExpected(string, new Object[0]);
    }

    @Override
    public boolean eq(Type type) {
        if (this == type) {
            return true;
        }
        if (type.getClass() != FuncType.class) {
            return false;
        }
        FuncType ft = (FuncType)type;
        if (this == SeqType.FUNCTION || ft == SeqType.FUNCTION || this.argTypes.length != ft.argTypes.length) {
            return false;
        }
        int al = this.argTypes.length;
        for (int a = 0; a < al; ++a) {
            if (this.argTypes[a].eq(ft.argTypes[a])) continue;
            return false;
        }
        return this.declType.eq(ft.declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type.oneOf(this, SeqType.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (this == SeqType.FUNCTION || !(type instanceof FuncType) || type instanceof MapType || type instanceof ArrayType) {
            return false;
        }
        FuncType ft = (FuncType)type;
        int al = this.argTypes.length;
        if (al != ft.argTypes.length) {
            return false;
        }
        for (int a = 0; a < al; ++a) {
            if (ft.argTypes[a].instanceOf(this.argTypes[a])) continue;
            return false;
        }
        for (Ann ann : ft.anns) {
            if (this.anns.contains(ann)) continue;
            return false;
        }
        return this.declType.instanceOf(ft.declType);
    }

    @Override
    public Type union(Type type) {
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        if (!(type instanceof FuncType)) {
            return AtomType.ITEM;
        }
        FuncType ft = (FuncType)type;
        int al = this.argTypes.length;
        if (al != ft.argTypes.length) {
            return SeqType.FUNCTION;
        }
        SeqType[] arg = new SeqType[al];
        for (int a = 0; a < al; ++a) {
            arg[a] = this.argTypes[a].intersect(ft.argTypes[a]);
            if (arg[a] != null) continue;
            return SeqType.FUNCTION;
        }
        AnnList an = this.anns.union(ft.anns);
        SeqType dt = this.declType.union(ft.declType);
        return FuncType.get(an, dt, arg);
    }

    @Override
    public Type intersect(Type type) {
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (!(type instanceof FuncType)) {
            return null;
        }
        if (type instanceof MapType || type instanceof ArrayType) {
            return type.intersect(this);
        }
        FuncType ft = (FuncType)type;
        int al = this.argTypes.length;
        if (al != ft.argTypes.length) {
            return null;
        }
        AnnList an = this.anns.intersect(ft.anns);
        if (an == null) {
            return null;
        }
        SeqType dt = this.declType.intersect(ft.declType);
        if (dt == null) {
            return null;
        }
        SeqType[] arg = new SeqType[al];
        for (int a = 0; a < al; ++a) {
            arg[a] = this.argTypes[a].union(ft.argTypes[a]);
        }
        return FuncType.get(an, dt, arg);
    }

    public static FuncType get(AnnList anns, SeqType declType, SeqType ... args) {
        return new FuncType(anns, declType, args);
    }

    public static FuncType get(SeqType declType, SeqType ... args) {
        return FuncType.get(new AnnList(), declType, args);
    }

    public static Type find(QNm name) {
        if (name.uri().length == 0) {
            byte[] ln = name.local();
            if (Token.eq(ln, Token.token("function"))) {
                return SeqType.FUNCTION;
            }
            if (Token.eq(ln, Token.token("map"))) {
                return SeqType.MAP;
            }
            if (Token.eq(ln, Token.token("array"))) {
                return SeqType.ARRAY;
            }
        }
        return null;
    }

    public static FuncType get(AnnList anns, SeqType declType, Var[] params) {
        int pl = params.length;
        SeqType[] argTypes = new SeqType[pl];
        for (int p = 0; p < pl; ++p) {
            argTypes[p] = params[p] == null ? SeqType.ITEM_ZM : params[p].declaredType();
        }
        return new FuncType(anns, declType, argTypes);
    }

    @Override
    public final AtomType atomic() {
        return null;
    }

    @Override
    public final Type.ID id() {
        return Type.ID.FUN;
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }

    @Override
    public String toString() {
        QueryString qs = new QueryString().token(this.anns).token("function");
        if (this == SeqType.FUNCTION) {
            qs.params(WILDCARD);
        } else {
            qs.params(this.argTypes).token("as").token(this.declType);
        }
        return qs.toString();
    }
}

