/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Arrays;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.tree.LeafNode;
import org.basex.util.Array;
import org.basex.util.Util;

final class PartialLeafNode
implements NodeLike<Item, Item> {
    final Item[] elems;

    PartialLeafNode(Item[] elems) {
        this.elems = elems;
    }

    @Override
    public int append(NodeLike<Item, Item>[] nodes, int pos) {
        if (pos == 0) {
            nodes[0] = this;
            return 1;
        }
        NodeLike<Item, Item> left = nodes[pos - 1];
        if (left instanceof PartialLeafNode) {
            Item[] ls = ((PartialLeafNode)left).elems;
            Item[] rs = this.elems;
            int l = ls.length;
            int r = rs.length;
            int n = l + r;
            Item[] vals = new Item[n];
            Array.copy(ls, l, vals);
            Array.copyFromStart(rs, r, vals, l);
            nodes[pos - 1] = n < 8 ? new PartialLeafNode(vals) : new LeafNode(vals);
            return pos;
        }
        Item[] ls = ((LeafNode)left).values;
        int l = ls.length;
        Item[] rs = this.elems;
        int r = rs.length;
        int n = l + r;
        if (n <= 15) {
            Item[] vals = new Item[n];
            Array.copy(ls, l, vals);
            Array.copyFromStart(rs, r, vals, l);
            nodes[pos - 1] = new LeafNode(vals);
            return pos;
        }
        int ll = n / 2;
        int rl = n - ll;
        int move = l - ll;
        Item[] newLeft = new Item[ll];
        Item[] newRight = new Item[rl];
        Array.copy(ls, ll, newLeft);
        Array.copyToStart(ls, ll, move, newRight);
        Array.copyFromStart(rs, r, newRight, move);
        nodes[pos - 1] = new LeafNode(newLeft);
        nodes[pos] = new LeafNode(newRight);
        return pos + 1;
    }

    public String toString() {
        return Util.className(this) + '(' + this.elems.length + ')' + Arrays.toString(this.elems);
    }
}

