/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.LongList;

public final class IntSeq
extends NativeSeq {
    private final long[] values;

    private IntSeq(long[] values, Type type) {
        super(values.length, type);
        this.values = values;
    }

    @Override
    public Int itemAt(long pos) {
        return Int.get(this.values[(int)pos], this.type);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        long[] tmp = new long[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return IntSeq.get(tmp, this.type);
    }

    public long[] values() {
        return this.values;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        if (mode == CompileContext.Simplify.DISTINCT) {
            long[] tmp = new LongList((int)this.size).add(this.values).sort().distinct().finish();
            int tl = tmp.length;
            if (this.seqType().type == AtomType.INTEGER) {
                int t = 0;
                while (++t < tl && tmp[0] + (long)t == tmp[t]) {
                }
                if (t == tl) {
                    return cc.replaceWith(this, RangeSeq.get(tmp[0], tl, true));
                }
            }
            return cc.replaceWith(this, IntSeq.get(tmp, this.type));
        }
        return super.simplifyFor(mode, cc);
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYTE: {
                byte[] t1 = new byte[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t1[s] = (byte)this.values[s];
                    ++s;
                }
                return t1;
            }
            case SHORT: 
            case UNSIGNED_BYTE: {
                short[] t2 = new short[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t2[s] = (short)this.values[s];
                    ++s;
                }
                return t2;
            }
            case INT: 
            case UNSIGNED_SHORT: {
                int[] t3 = new int[(int)this.size];
                int s = 0;
                while ((long)s < this.size) {
                    t3[s] = (int)this.values[s];
                    ++s;
                }
                return t3;
            }
        }
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSeq)) {
            return super.equals(obj);
        }
        IntSeq is = (IntSeq)obj;
        return this.type == is.type && Arrays.equals(this.values, is.values);
    }

    public static Value get(int[] values) {
        LongList list = new LongList(values.length);
        for (int value : values) {
            list.add((long)value);
        }
        return IntSeq.get(list.finish(), AtomType.INTEGER);
    }

    public static Value get(long[] values) {
        return IntSeq.get(values, AtomType.INTEGER);
    }

    public static Value get(long[] values, Type type) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Int.get(values[0], type) : new IntSeq(values, type));
    }

    static Value get(Type type, int size, Value ... values) throws QueryException {
        LongList tmp = new LongList(size);
        for (Value value : values) {
            if (value instanceof IntSeq) {
                tmp.add(((IntSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.itr(null));
            }
        }
        return IntSeq.get(tmp.finish(), type);
    }
}

