/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;

public final class FltSeq
extends NativeSeq {
    private final float[] values;

    private FltSeq(float[] values) {
        super(values.length, (Type)AtomType.FLOAT);
        this.values = values;
    }

    @Override
    public Flt itemAt(long pos) {
        return Flt.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        float[] tmp = new float[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return FltSeq.get(tmp);
    }

    public float[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof FltSeq ? Arrays.equals(this.values, ((FltSeq)obj).values) : super.equals(obj));
    }

    public static Value get(float[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Flt.get(values[0]) : new FltSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        float[] tmp = new float[size];
        int t = 0;
        for (Value value : values) {
            if (value instanceof FltSeq) {
                int vs = (int)value.size();
                Array.copyFromStart(((FltSeq)value).values, vs, tmp, t);
                t += vs;
                continue;
            }
            for (Item item : value) {
                tmp[t++] = item.flt(null);
            }
        }
        return FltSeq.get(tmp);
    }
}

