/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

public class DBNodeSeq
extends NativeSeq {
    protected final Data data;
    protected final boolean all;
    protected int[] pres;

    protected DBNodeSeq(int[] pres, Data data, Type type, boolean all) {
        super(pres.length, type);
        this.pres = pres;
        this.data = data;
        this.all = all;
    }

    @Override
    public Data data() {
        return this.data;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) {
        return this.itemAt(0L);
    }

    @Override
    public boolean ddo() {
        return true;
    }

    @Override
    public DBNode itemAt(long pos) {
        return new DBNode(this.data, this.pres[(int)pos]);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) {
        ValueBuilder vb = new ValueBuilder(qc);
        int i = 0;
        while ((long)i < this.size) {
            vb.add(this.itemAt(i).atomValue(qc, ii));
            ++i;
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    public int[] pres() {
        return this.pres;
    }

    public int pre(int index) {
        return this.pres[index];
    }

    public boolean all() {
        return this.all;
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        int[] tmp = new int[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.pres[i];
        }
        return new DBNodeSeq(tmp, this.data, this.type, false);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DBNodeSeq)) {
            return super.equals(obj);
        }
        DBNodeSeq ds = (DBNodeSeq)obj;
        return this.size == ds.size && Arrays.equals(this.pres, ds.pres);
    }

    @Override
    public void plan(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(40);
        int p = 0;
        while ((long)p < this.size) {
            if (p > 0) {
                tb.add(", ");
            }
            tb.add(Function._DB_OPEN_PRE.args(this.data.meta.name, this.pres[p]).trim());
            if (tb.size() > 16 && (long)(p + 1) != this.size) {
                tb.add(", ").add("...");
                break;
            }
            ++p;
        }
        qs.token(tb.add(41).finish());
    }

    public static Value get(int[] pres, Data data, Type type, boolean all) {
        return pres.length == 0 ? Empty.VALUE : (pres.length == 1 ? new DBNode(data, pres[0]) : new DBNodeSeq(pres, data, type == null ? NodeType.NODE : type, all));
    }

    public static Value get(int[] pres, Data data, Expr expr) {
        return DBNodeSeq.get(pres, data, NodeType.NODE.refine(expr), false);
    }

    public static Value get(IntList pres, Data data, boolean docs, boolean all) {
        return DBNodeSeq.get(pres.toArray(), data, docs ? NodeType.DOCUMENT_NODE : null, all);
    }
}

