/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.ByteList;

public final class BytSeq
extends NativeSeq {
    private final byte[] values;

    private BytSeq(byte[] values) {
        super(values.length, (Type)AtomType.BYTE);
        this.values = values;
    }

    @Override
    public Int itemAt(long pos) {
        return new Int(this.values[(int)pos], this.type);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        byte[] tmp = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BytSeq.get(tmp);
    }

    public byte[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof BytSeq ? Arrays.equals(this.values, ((BytSeq)obj).values) : super.equals(obj));
    }

    public static Value get(byte[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Int.get(values[0], AtomType.BYTE) : new BytSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        ByteList tmp = new ByteList(size);
        for (Value value : values) {
            if (value instanceof BytSeq) {
                tmp.add(((BytSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add((byte)item.itr(null));
            }
        }
        return BytSeq.get(tmp.finish());
    }
}

