/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.w3c.dom.ProcessingInstruction;

public final class FPI
extends FNode {
    public static final byte[] OPEN = new byte[]{60, 63};
    public static final byte[] CLOSE = new byte[]{63, 62};
    private final QNm name;

    public FPI(String name, String value) {
        this(new QNm(name), Token.token(value));
    }

    public FPI(QNm name, byte[] value) {
        super(NodeType.PROCESSING_INSTRUCTION);
        this.name = name;
        this.value = value;
    }

    public FPI(ProcessingInstruction pi) {
        this(pi.getTarget(), pi.getData());
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public FPI materialize(QueryContext qc, boolean copy) {
        return copy ? new FPI(this.name, this.value) : this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FPI && this.name.eq(((FPI)obj).name) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string(), "value", this.value), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        qs.concat(OPEN, this.name.string(), " ", QueryString.toValue(this.value), CLOSE);
    }

    public static byte[] parse(byte[] atom, InputInfo ii) throws QueryException {
        if (Token.contains(atom, CLOSE)) {
            throw QueryError.CPICONT_X.get(ii, new Object[]{atom});
        }
        return atom;
    }
}

