/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.Stack;
import org.basex.api.dom.BXNode;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class FNode
extends ANode {
    FNode parent;

    FNode(NodeType type) {
        super(type);
    }

    @Override
    public byte[] string() {
        if (this.value == null) {
            this.value = Token.EMPTY;
        }
        return this.value;
    }

    @Override
    public FNode finish() {
        return this;
    }

    @Override
    public final boolean is(ANode node) {
        return this == node;
    }

    @Override
    public final int diff(ANode node) {
        return this == node ? 0 : (node instanceof FNode ? this.id - node.id : FNode.diff(this, node));
    }

    @Override
    public final ANode parent() {
        return this.parent;
    }

    @Override
    public final void parent(FNode par) {
        this.parent = par;
    }

    @Override
    public BasicNodeIter attributeIter() {
        return BasicNodeIter.EMPTY;
    }

    @Override
    public BasicNodeIter childIter() {
        return BasicNodeIter.EMPTY;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public final BasicNodeIter descendantIter() {
        return this.desc(false);
    }

    @Override
    public final BasicNodeIter descendantOrSelfIter() {
        return this.desc(true);
    }

    final byte[] string(ANodeList iter) {
        if (this.value == null) {
            TokenBuilder tb = new TokenBuilder();
            for (ANode nc : iter) {
                if (nc.type != NodeType.ELEMENT && nc.type != NodeType.TEXT) continue;
                tb.add(nc.string());
            }
            this.value = tb.finish();
        }
        return this.value;
    }

    private BasicNodeIter desc(final boolean self) {
        return new BasicNodeIter(){
            private final Stack<BasicNodeIter> iters = new Stack();
            private ANode last;

            @Override
            public ANode next() {
                BasicNodeIter ir = this.last != null ? this.last.childIter() : (self ? FNode.this.selfIter() : FNode.this.childIter());
                this.last = ir.next();
                if (this.last == null) {
                    while (!this.iters.isEmpty()) {
                        this.last = this.iters.peek().next();
                        if (this.last == null) {
                            this.iters.pop();
                            continue;
                        }
                        break;
                    }
                } else {
                    this.iters.add(ir);
                }
                return this.last;
            }
        };
    }

    @Override
    public final BXNode toJava() {
        return BXNode.get(this);
    }

    public final int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FNode)) {
            return false;
        }
        FNode n = (FNode)obj;
        return this.type.eq(n.type) && Token.eq(this.value, n.value) && this.parent == n.parent;
    }
}

