/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.io.IOException;
import org.basex.api.dom.BXNode;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FPI;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.ByteList;

public class DBNode
extends ANode {
    FNode root;
    private final Data data;
    private int pre;

    public DBNode(Data data) {
        this(data, 0);
    }

    public DBNode(Data data, int pre) {
        this(data, pre, data.kind(pre));
    }

    public DBNode(Data data, int pre, int kind) {
        this(data, pre, null, DBNode.type(kind));
    }

    DBNode(Data data, int pre, FNode rt, NodeType type) {
        super(type);
        this.data = data;
        this.pre = pre;
        this.root = rt;
    }

    public DBNode(IO input) throws IOException {
        this(MemBuilder.build(input));
    }

    public DBNode(Parser parser) throws IOException {
        this(MemBuilder.build("", parser));
    }

    private DBNode set(int p, int k) {
        this.type = DBNode.type(k);
        this.value = null;
        this.pre = p;
        return this;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    public final void pre(int p) {
        this.pre = p;
    }

    public final int pre() {
        return this.pre;
    }

    @Override
    public final byte[] string() {
        if (this.value == null) {
            this.value = this.data.atom(this.pre);
        }
        return this.value;
    }

    @Override
    public final long itr(InputInfo ii) throws QueryException {
        long l;
        if (this.type == NodeType.ELEMENT) {
            long l2;
            int as = this.data.attSize(this.pre, 1);
            if (this.data.size(this.pre, 1) - as == 1 && this.data.kind(this.pre + as) == 2 && (l2 = this.data.textItr(this.pre + as, true)) != Long.MIN_VALUE) {
                return l2;
            }
        } else if ((this.type == NodeType.TEXT || this.type == NodeType.ATTRIBUTE) && (l = this.data.textItr(this.pre, this.type == NodeType.TEXT)) != Long.MIN_VALUE) {
            return l;
        }
        return Int.parse(this, ii);
    }

    @Override
    public final double dbl(InputInfo ii) throws QueryException {
        double d = Double.NaN;
        if (this.type == NodeType.ELEMENT) {
            int as = this.data.attSize(this.pre, 1);
            if (this.data.size(this.pre, 1) - as == 1 && this.data.kind(this.pre + as) == 2) {
                d = this.data.textDbl(this.pre + as, true);
            }
        } else if (this.type == NodeType.TEXT || this.type == NodeType.ATTRIBUTE) {
            d = this.data.textDbl(this.pre, this.type == NodeType.TEXT);
        }
        return Double.isNaN(d) ? Dbl.parse(this.string(), ii) : d;
    }

    @Override
    public final byte[] name() {
        return (byte[])(this.type == NodeType.ELEMENT || this.type == NodeType.ATTRIBUTE || this.type == NodeType.PROCESSING_INSTRUCTION ? this.data.name(this.pre, DBNode.kind(this.nodeType())) : null);
    }

    @Override
    public final QNm qname() {
        if (this.type == NodeType.ELEMENT || this.type == NodeType.ATTRIBUTE || this.type == NodeType.PROCESSING_INSTRUCTION) {
            byte[][] qname = this.data.qname(this.pre, this.kind());
            return new QNm(qname[0], qname[1]);
        }
        return null;
    }

    @Override
    public final Atts namespaces() {
        return this.data.namespaces(this.pre);
    }

    @Override
    public final byte[] baseURI() {
        if (this.type == NodeType.DOCUMENT_NODE) {
            String base = Token.string(this.data.text(this.pre, true));
            if (this.data.inMemory()) {
                String path = this.data.meta.original;
                return Token.token(path.isEmpty() ? base : IO.get(path).merge(base).url());
            }
            return Token.concat(Character.valueOf('/'), this.data.meta.name, Character.valueOf('/'), base);
        }
        byte[] base = this.attribute(QNm.XML_BASE);
        return base != null ? base : Token.EMPTY;
    }

    @Override
    public final boolean is(ANode node) {
        return this == node || this.data == node.data() && this.pre == ((DBNode)node).pre;
    }

    @Override
    public final int diff(ANode node) {
        if (this == node) {
            return 0;
        }
        Data ndata = node.data();
        return ndata != null ? (this.data == ndata ? this.pre - ((DBNode)node).pre : this.data.dbid - ndata.dbid) : DBNode.diff(this, node);
    }

    @Override
    public final Value copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.finish();
    }

    @Override
    public final DBNode materialize(QueryContext qc, boolean copy) {
        return copy ? this.copy(qc) : this;
    }

    @Override
    public final DBNode finish() {
        return new DBNode(this.data, this.pre, this.root, this.nodeType());
    }

    @Override
    public final ANode parent() {
        int par = this.data.parent(this.pre, this.kind());
        return par == -1 ? this.root : this.finish().set(par, this.data.kind(par));
    }

    @Override
    public final void parent(FNode par) {
        this.root = par;
    }

    @Override
    public final boolean hasChildren() {
        int kind = this.kind();
        return this.data.attSize(this.pre, kind) != this.data.size(this.pre, kind);
    }

    @Override
    public final BasicNodeIter ancestorIter() {
        return this.root != null ? super.ancestorIter() : this.ancestorIter(this.data.parent(this.pre, this.kind()));
    }

    @Override
    public final BasicNodeIter ancestorOrSelfIter() {
        return this.root != null ? super.ancestorOrSelfIter() : this.ancestorIter(this.pre);
    }

    @Override
    public final BasicNodeIter attributeIter() {
        final int first = this.pre + 1;
        int k = this.kind();
        final int last = this.pre + this.data.attSize(this.pre, k);
        return first == last ? BasicNodeIter.EMPTY : new DBNodeIter(this.data){
            final DBNode node;
            int curr;
            {
                super(data);
                this.node = DBNode.this.finish();
                this.curr = first;
            }

            @Override
            public DBNode next() {
                return this.curr == last ? null : this.node.set(this.curr++, 3);
            }

            @Override
            public ANode get(long i) {
                return this.node.set(DBNode.this.pre + 1 + (int)i, 3);
            }

            @Override
            public long size() {
                return last - first;
            }
        };
    }

    @Override
    public final BasicNodeIter childIter() {
        int last;
        int k = this.kind();
        final int first = this.pre + this.data.attSize(this.pre, k);
        return first == (last = this.pre + this.data.size(this.pre, k)) ? BasicNodeIter.EMPTY : new DBNodeIter(this.data){
            final DBNode node;
            int curr;
            {
                super(data);
                this.node = DBNode.this.finish();
                this.curr = first;
            }

            @Override
            public DBNode next() {
                if (this.curr == last) {
                    return null;
                }
                int kind = this.data.kind(this.curr);
                this.node.set(this.curr, kind);
                this.curr += this.data.size(this.curr, kind);
                return this.node;
            }
        };
    }

    @Override
    public final BasicNodeIter descendantIter() {
        int k = this.kind();
        int first = this.pre + this.data.attSize(this.pre, k);
        int last = this.pre + this.data.size(this.pre, k);
        return this.descendantIter(first, last);
    }

    @Override
    public final BasicNodeIter descendantOrSelfIter() {
        int k = this.kind();
        int first = this.pre;
        int last = this.pre + this.data.size(this.pre, k);
        return this.descendantIter(first, last);
    }

    @Override
    public final BasicNodeIter followingIter() {
        if (this.root != null) {
            return super.followingIter();
        }
        return new DBNodeIter(this.data){
            private final DBNode node;
            int kind;
            int curr;
            int size;
            {
                this.node = DBNode.this.finish();
                this.kind = DBNode.this.kind();
                this.curr = DBNode.this.pre + this.data.size(DBNode.this.pre, this.kind);
                this.size = -1;
            }

            @Override
            public DBNode next() {
                if (this.size == -1) {
                    if (this.data.meta.ndocs > 1) {
                        int p = DBNode.this.pre;
                        for (ANode nd : DBNode.this.ancestorIter()) {
                            p = ((DBNode)nd).pre;
                        }
                        this.size = p + this.data.size(p, this.data.kind(p));
                    } else {
                        this.size = this.data.meta.size;
                    }
                }
                if (this.curr == this.size) {
                    return null;
                }
                this.kind = this.data.kind(this.curr);
                this.node.set(this.curr, this.kind);
                this.curr += this.data.attSize(this.curr, this.kind);
                return this.node;
            }
        };
    }

    @Override
    public final BasicNodeIter followingSiblingIter() {
        final int k = this.kind();
        final int parent = this.data.parent(this.pre, k);
        if (parent == -1) {
            return this.root != null ? super.followingSiblingIter() : BasicNodeIter.EMPTY;
        }
        return new DBNodeIter(this.data){
            final DBNode node;
            final int last;
            int curr;
            {
                super(data);
                this.node = DBNode.this.finish();
                this.last = parent + this.data.size(parent, this.data.kind(parent));
                this.curr = DBNode.this.pre + this.data.size(DBNode.this.pre, k);
            }

            @Override
            public DBNode next() {
                if (this.curr == this.last) {
                    return null;
                }
                int kind = this.data.kind(this.curr);
                this.node.set(this.curr, kind);
                this.curr += this.data.size(this.curr, kind);
                return this.node;
            }
        };
    }

    private BasicNodeIter ancestorIter(final int first) {
        return first == -1 ? BasicNodeIter.EMPTY : new DBNodeIter(this.data){
            final DBNode node;
            int curr;
            {
                super(data);
                this.node = DBNode.this.finish();
                this.curr = first;
            }

            @Override
            public DBNode next() {
                if (this.curr == -1) {
                    return null;
                }
                int kind = this.data.kind(this.curr);
                this.node.set(this.curr, kind);
                this.curr = this.data.parent(this.curr, kind);
                return this.node;
            }
        };
    }

    private BasicNodeIter descendantIter(final int first, final int last) {
        return first == last ? BasicNodeIter.EMPTY : new DBNodeIter(this.data){
            final DBNode node;
            int curr;
            {
                super(data);
                this.node = DBNode.this.finish();
                this.curr = first;
            }

            @Override
            public DBNode next() {
                if (this.curr == last) {
                    return null;
                }
                int kind = this.data.kind(this.curr);
                this.node.set(this.curr, kind);
                this.curr += this.data.attSize(this.curr, kind);
                return this.node;
            }
        };
    }

    @Override
    public final byte[] xdmInfo() {
        ByteList bl = new ByteList().add(this.typeId().asByte());
        if (this.type == NodeType.DOCUMENT_NODE) {
            bl.add(this.baseURI()).add(0);
        } else if (this.type == NodeType.ATTRIBUTE) {
            bl.add(this.qname().uri()).add(0);
        }
        return bl.finish();
    }

    @Override
    public final Type.ID typeId() {
        BasicNodeIter iter;
        ANode n;
        Type.ID i = this.type.id();
        if (this.type == NodeType.DOCUMENT_NODE && (n = (iter = this.childIter()).next()) != null && n.type == NodeType.ELEMENT && iter.next() == null) {
            i = NodeType.DOCUMENT_NODE_ELEMENT.id();
        }
        return i;
    }

    @Override
    public final BXNode toJava() {
        return BXNode.get(this.copy(new MainOptions(), null));
    }

    public final int hashCode() {
        return this.data.hashCode() + this.pre;
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof DBNode && this.is((DBNode)obj);
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, "pre", this.pre), new ExprInfo[0]);
    }

    @Override
    public String toErrorString() {
        QueryString qs = new QueryString();
        this.plan(qs, true);
        return qs.toString();
    }

    @Override
    public void plan(QueryString qs) {
        this.plan(qs, false);
    }

    private void plan(QueryString qs, boolean error) {
        if (error || this.data.inMemory()) {
            switch ((NodeType)this.type) {
                case ATTRIBUTE: {
                    qs.concat(this.name(), "=", QueryString.toQuoted(this.string()));
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    qs.concat(FPI.OPEN, this.name(), " ", QueryString.toValue(this.string()), FPI.CLOSE);
                    break;
                }
                case ELEMENT: {
                    qs.concat("<", this.name(), this.hasChildren() || this.attributeIter().size() > 0L ? "..." : "", "/>");
                    break;
                }
                case DOCUMENT_NODE: {
                    qs.token("document").brace(QueryString.toQuoted(this.baseURI()));
                    break;
                }
                case COMMENT: {
                    qs.concat("<!--", QueryString.toValue(this.string()), "-->");
                    break;
                }
                default: {
                    qs.quoted(this.string());
                    break;
                }
            }
        } else {
            qs.function(Function._DB_OPEN_PRE, this.data.meta.name, this.pre);
        }
    }
}

