/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.concurrent.atomic.AtomicInteger;
import org.basex.api.dom.BXNode;
import org.basex.core.MainOptions;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANode
extends Item {
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOCUMENT_NODE, NodeType.ELEMENT, NodeType.TEXT, NodeType.ATTRIBUTE, NodeType.COMMENT, NodeType.PROCESSING_INSTRUCTION};
    private static final AtomicInteger ID = new AtomicInteger();
    public final int id = ID.incrementAndGet();
    byte[] value;

    ANode(NodeType type) {
        super(type);
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return true;
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    public abstract byte[] string();

    @Override
    public final boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return item.type.isUntyped() ? (coll == null ? Token.eq(this.string(), item.string(ii)) : coll.compare(this.string(), item.string(ii)) == 0) : item.eq(this, coll, sc, ii);
    }

    @Override
    public boolean sameKey(Item item, InputInfo ii) throws QueryException {
        return item.type.isStringOrUntyped() && this.eq(item, null, null, ii);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        return item.type.isUntyped() ? (coll == null ? Token.diff(this.string(), item.string(ii)) : coll.compare(this.string(), item.string(ii))) : -item.diff(this, coll, ii);
    }

    @Override
    public final Item atomValue(QueryContext qc, InputInfo ii) {
        return this.atomItem();
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) {
        return this.atomItem();
    }

    public Item atomItem() {
        return this.type == NodeType.PROCESSING_INSTRUCTION || this.type == NodeType.COMMENT ? Str.get(this.string()) : new Atm(this.string());
    }

    @Override
    public boolean ddo() {
        return true;
    }

    @Override
    public abstract ANode materialize(QueryContext var1, boolean var2);

    public final DBNode copy(QueryContext qc) {
        return this.copy(qc.context.options, qc);
    }

    public final DBNode copy(MainOptions options, QueryContext qc) {
        MemData data = new MemData(options);
        new DataBuilder(data, qc).build(this);
        return new DBNode(data);
    }

    public abstract ANode finish();

    public byte[] name() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public ANode optimize() {
        return this;
    }

    public Atts namespaces() {
        return null;
    }

    public final Atts nsScope(StaticContext sc) {
        Atts ns = new Atts();
        ANode node = this;
        do {
            Atts nsp;
            if ((nsp = node.namespaces()) == null) continue;
            for (int a = nsp.size() - 1; a >= 0; --a) {
                byte[] key = nsp.name(a);
                if (ns.contains(key)) continue;
                ns.add(key, nsp.value(a));
            }
        } while ((node = node.parent()) != null && node.type == NodeType.ELEMENT);
        if (sc != null) {
            sc.ns.inScope(ns);
        }
        return ns;
    }

    public final byte[] uri(byte[] pref) {
        Atts at = this.namespaces();
        if (at != null) {
            byte[] s = at.value(pref);
            if (s != null) {
                return s;
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(pref);
            }
        }
        return (byte[])(pref.length == 0 ? Token.EMPTY : null);
    }

    public byte[] baseURI() {
        return Token.EMPTY;
    }

    public abstract boolean is(ANode var1);

    public abstract int diff(ANode var1);

    static int diff(ANode node1, ANode node2) {
        ANodeList nl = new ANodeList();
        for (ANode n = node1; n != null; n = n.parent()) {
            if (n == node2) {
                return 1;
            }
            nl.add(n);
        }
        ANode c2 = node2;
        ANode n = node2;
        block1: while ((n = n.parent()) != null) {
            int is = nl.size();
            for (int i = 1; i < is; ++i) {
                if (n == node1) {
                    return -1;
                }
                if (!((ANode)nl.get(i)).is(n)) continue;
                ANode c1 = (ANode)nl.get(i - 1);
                for (ANode c : n.childIter()) {
                    if (c.is(c1)) {
                        return -1;
                    }
                    if (!c.is(c2)) continue;
                    return 1;
                }
                break block1;
            }
            c2 = n;
        }
        return node1.id - node2.id;
    }

    public final ANode root() {
        ANode p = this.parent();
        return p == null ? this : p.root();
    }

    public abstract ANode parent();

    public abstract void parent(FNode var1);

    public abstract boolean hasChildren();

    public byte[] attribute(byte[] name) {
        return this.attribute(new QNm(name));
    }

    public byte[] attribute(QNm name) {
        ANode node;
        BasicNodeIter iter = this.attributeIter();
        do {
            if ((node = iter.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.string();
    }

    public BasicNodeIter ancestorIter() {
        return new BasicNodeIter(){
            private ANode node;
            {
                this.node = ANode.this;
            }

            @Override
            public ANode next() {
                this.node = this.node.parent();
                return this.node;
            }
        };
    }

    public BasicNodeIter ancestorOrSelfIter() {
        return new BasicNodeIter(){
            private ANode node;
            {
                this.node = ANode.this;
            }

            @Override
            public ANode next() {
                if (this.node == null) {
                    return null;
                }
                ANode n = this.node;
                this.node = n.parent();
                return n;
            }
        };
    }

    public abstract BasicNodeIter attributeIter();

    public abstract BasicNodeIter childIter();

    public abstract BasicNodeIter descendantIter();

    public abstract BasicNodeIter descendantOrSelfIter();

    public BasicNodeIter followingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    ANode node = ANode.this;
                    for (ANode root = node.parent(); root != null; root = root.parent()) {
                        BasicNodeIter ir = root.childIter();
                        if (node.type != NodeType.ATTRIBUTE) {
                            for (ANode nd : ir) {
                                if (nd.is(node)) break;
                            }
                        }
                        for (ANode nd : ir) {
                            list.add(nd.finish());
                            ANode.addDesc(nd.childIter(), list);
                        }
                        node = root;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public BasicNodeIter followingSiblingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANode n;
                    ANode root = ANode.this.parent();
                    if (root == null) {
                        return null;
                    }
                    this.iter = root.childIter();
                    while ((n = this.iter.next()) != null && !n.is(ANode.this)) {
                    }
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter parentIter() {
        return new BasicNodeIter(){
            private boolean called;

            @Override
            public ANode next() {
                if (this.called) {
                    return null;
                }
                this.called = true;
                return ANode.this.parent();
            }
        };
    }

    public final BasicNodeIter precedingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    ANode node = ANode.this;
                    for (ANode root = node.parent(); root != null; root = root.parent()) {
                        if (node.type != NodeType.ATTRIBUTE) {
                            ANodeList tmp = new ANodeList();
                            for (ANode c : root.childIter()) {
                                if (c.is(node)) break;
                                tmp.add(c.finish());
                                ANode.addDesc(c.childIter(), tmp);
                            }
                            for (int t = tmp.size() - 1; t >= 0; --t) {
                                list.add(tmp.get(t));
                            }
                        }
                        node = root;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter precedingSiblingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;
            private int i;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    if (ANode.this.type == NodeType.ATTRIBUTE) {
                        return null;
                    }
                    ANode root = ANode.this.parent();
                    if (root == null) {
                        return null;
                    }
                    ANodeList list = new ANodeList();
                    for (ANode node : root.childIter()) {
                        if (node.is(ANode.this)) break;
                        list.add(node.finish());
                    }
                    this.i = list.size();
                    this.iter = list.iter();
                }
                return this.i > 0 ? this.iter.get(--this.i) : null;
            }
        };
    }

    public final BasicNodeIter selfIter() {
        return new BasicNodeIter(){
            private boolean called;

            @Override
            public ANode next() {
                if (this.called) {
                    return null;
                }
                this.called = true;
                return ANode.this;
            }
        };
    }

    static void addDesc(BasicNodeIter children, ANodeList nodes) {
        for (ANode node : children) {
            nodes.add(node.finish());
            ANode.addDesc(node.childIter(), nodes);
        }
    }

    public int kind() {
        return ANode.kind(this.nodeType());
    }

    public static int kind(NodeType type) {
        switch (type) {
            case DOCUMENT_NODE: {
                return 0;
            }
            case ELEMENT: {
                return 1;
            }
            case TEXT: {
                return 2;
            }
            case ATTRIBUTE: {
                return 3;
            }
            case COMMENT: {
                return 4;
            }
            case PROCESSING_INSTRUCTION: {
                return 5;
            }
        }
        return -1;
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public abstract BXNode toJava();

    public final NodeType nodeType() {
        return (NodeType)this.type;
    }
}

