/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.fn.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieBranch;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieList;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

abstract class TrieNode {
    static final int KIDS = 32;
    private static final int MASK = 31;
    static final TrieNode EMPTY = new TrieNode(0){

        @Override
        TrieNode delete(int hash, Item key, int level, InputInfo ii) {
            return this;
        }

        @Override
        Value get(int hash, Item key, int level, InputInfo ii) {
            return null;
        }

        @Override
        boolean contains(int hash, Item key, int level, InputInfo ii) {
            return false;
        }

        @Override
        TrieNode addAll(TrieNode node, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) {
            return node;
        }

        @Override
        TrieNode add(TrieLeaf leaf, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) {
            return leaf;
        }

        @Override
        TrieNode add(TrieList list, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) {
            return list;
        }

        @Override
        TrieNode add(TrieBranch branch, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) {
            return branch;
        }

        @Override
        boolean verify() {
            return true;
        }

        @Override
        void keys(ItemList ks) {
        }

        @Override
        void values(ValueBuilder vs) {
        }

        @Override
        void cache(boolean lazy, InputInfo ii) {
        }

        @Override
        boolean materialized() {
            return true;
        }

        @Override
        boolean instanceOf(AtomType kt, SeqType dt) {
            return true;
        }

        @Override
        int hash(InputInfo ii) {
            return 0;
        }

        @Override
        boolean deep(TrieNode node, Collation coll, InputInfo ii) {
            return this == node;
        }

        @Override
        public TrieNode put(int hash, Item key, Value value, int level, InputInfo ii) {
            return new TrieLeaf(hash, key, value);
        }

        @Override
        void forEach(ValueBuilder vb, FItem func, QueryContext qc, InputInfo ii) {
        }

        @Override
        StringBuilder append(StringBuilder sb, String indent) {
            return sb.append("{ }");
        }

        @Override
        StringBuilder append(StringBuilder sb) {
            return sb;
        }
    };
    final int size;

    TrieNode(int size) {
        this.size = size;
    }

    abstract TrieNode put(int var1, Item var2, Value var3, int var4, InputInfo var5) throws QueryException;

    abstract TrieNode delete(int var1, Item var2, int var3, InputInfo var4) throws QueryException;

    abstract Value get(int var1, Item var2, int var3, InputInfo var4) throws QueryException;

    abstract boolean contains(int var1, Item var2, int var3, InputInfo var4) throws QueryException;

    abstract TrieNode addAll(TrieNode var1, int var2, MergeDuplicates var3, QueryContext var4, InputInfo var5) throws QueryException;

    abstract TrieNode add(TrieLeaf var1, int var2, MergeDuplicates var3, QueryContext var4, InputInfo var5) throws QueryException;

    abstract TrieNode add(TrieList var1, int var2, MergeDuplicates var3, QueryContext var4, InputInfo var5) throws QueryException;

    abstract TrieNode add(TrieBranch var1, int var2, MergeDuplicates var3, QueryContext var4, InputInfo var5) throws QueryException;

    abstract boolean verify();

    abstract void keys(ItemList var1);

    abstract void values(ValueBuilder var1);

    abstract void cache(boolean var1, InputInfo var2) throws QueryException;

    abstract boolean materialized();

    abstract void forEach(ValueBuilder var1, FItem var2, QueryContext var3, InputInfo var4) throws QueryException;

    static int key(int hash, int level) {
        return hash >>> level * 5 & 0x1F;
    }

    abstract boolean instanceOf(AtomType var1, SeqType var2);

    static boolean deep(Value value1, Value value2, Collation coll, InputInfo ii) throws QueryException {
        return value1.size() == value2.size() && new DeepEqual(ii).collation(coll).equal(value1, value2);
    }

    abstract int hash(InputInfo var1) throws QueryException;

    abstract boolean deep(TrieNode var1, Collation var2, InputInfo var3) throws QueryException;

    abstract StringBuilder append(StringBuilder var1, String var2);

    abstract StringBuilder append(StringBuilder var1);

    public String toString() {
        return this.append(new StringBuilder(), "").toString();
    }

    static boolean more(StringBuilder sb) {
        if (sb.length() <= 32) {
            return true;
        }
        if (!sb.substring(sb.length() - "...".length()).equals("...")) {
            sb.append("...");
        }
        return false;
    }
}

