/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Bln
extends Item {
    public static final Bln TRUE = new Bln(true);
    public static final Bln FALSE = new Bln(false);
    private final boolean value;
    private double score;

    private Bln(boolean value) {
        super(AtomType.BOOLEAN);
        this.value = value;
    }

    private Bln(double score) {
        this(true);
        this.score = score;
    }

    public static Bln get(double score) {
        return score != 0.0 ? new Bln(score) : FALSE;
    }

    public static Bln get(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public byte[] string(InputInfo ii) {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value;
    }

    @Override
    public long itr(InputInfo ii) {
        return this.value ? 1L : 0L;
    }

    @Override
    public float flt(InputInfo ii) {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double dbl(InputInfo ii) {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return this.value == (item.type == this.type ? item.bool(ii) : Bln.parse(item, ii));
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        boolean n;
        boolean bl = n = item.type == this.type ? item.bool(ii) : Bln.parse(item, ii);
        return this.value ? (n ? 0 : 1) : (n ? -1 : 0);
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public Boolean toJava() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Bln && this.value == ((Bln)obj).value;
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.value ? Token.TRUE : Token.FALSE).paren("");
    }

    public static boolean parse(Item item, InputInfo ii) throws QueryException {
        Boolean b = Bln.parse(item.string(ii));
        if (b != null) {
            return b;
        }
        throw AtomType.BOOLEAN.castError(item, ii);
    }

    public static Boolean parse(byte[] value) {
        byte[] v = Token.trim(value);
        if (Token.eq(v, Token.TRUE) || Token.eq(v, Token.ONE)) {
            return Boolean.TRUE;
        }
        if (Token.eq(v, Token.FALSE) || Token.eq(v, Token.ZERO)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

