/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.util.fingertree.DeepTree;
import org.basex.query.util.fingertree.EmptyTree;
import org.basex.query.util.fingertree.FingerTreeIterator;
import org.basex.query.util.fingertree.InnerNode;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.PartialInnerNode;
import org.basex.query.util.fingertree.SingletonTree;
import org.basex.query.util.fingertree.TreeSlice;
import org.basex.util.Array;

public abstract class FingerTree<N, E>
implements Iterable<E> {
    static final int MAX_ARITY = 4;
    static final int MAX_DIGIT = 5;

    public static <E> FingerTree<E, E> empty() {
        return EmptyTree.INSTANCE;
    }

    public static <E> FingerTree<E, E> singleton(Node<E, E> leaf) {
        return new SingletonTree<E, E>(leaf);
    }

    public final boolean isEmpty() {
        return this == EmptyTree.INSTANCE;
    }

    public final E get(long index) {
        Node digit;
        long pos = index;
        FingerTree curr = this;
        int level = 0;
        while (true) {
            if (curr instanceof SingletonTree) {
                digit = ((SingletonTree)curr).elem;
                break;
            }
            DeepTree deep = (DeepTree)curr;
            if (pos < deep.leftSize) {
                long sz;
                Node nd = null;
                for (int i = 0; i < deep.left.length && pos >= (sz = (nd = deep.left[i]).size()); pos -= sz, ++i) {
                }
                digit = nd;
                break;
            }
            long mSize = deep.middle.size();
            if ((pos -= deep.leftSize) >= mSize) {
                long sz;
                pos -= mSize;
                Node nd = null;
                for (int i = 0; i < deep.right.length && pos >= (sz = (nd = deep.right[i]).size()); pos -= sz, ++i) {
                }
                digit = nd;
                break;
            }
            curr = deep.middle;
            ++level;
        }
        Node nd = digit;
        while (level > 0) {
            InnerNode deep = (InnerNode)nd;
            long[] bounds = deep.bounds;
            int p = 0;
            while (pos >= bounds[p]) {
                ++p;
            }
            if (p > 0) {
                pos -= bounds[p - 1];
            }
            nd = deep.children[p];
            --level;
        }
        Object res = nd.getSub((int)pos);
        return (E)res;
    }

    public abstract FingerTree<N, E> set(long var1, E var3);

    public abstract long size();

    public abstract FingerTree<N, E> cons(Node<N, E> var1);

    public abstract FingerTree<N, E> snoc(Node<N, E> var1);

    public abstract Node<N, E> head();

    public abstract FingerTree<N, E> tail();

    public abstract Node<N, E> last();

    public abstract FingerTree<N, E> init();

    public abstract FingerTree<N, E> concat(Node<N, E>[] var1, long var2, FingerTree<N, E> var4);

    public abstract FingerTree<N, E> reverse(QueryContext var1);

    public abstract FingerTree<N, E> insert(long var1, E var3, QueryContext var4);

    public abstract TreeSlice<N, E> remove(long var1, QueryContext var3);

    public abstract TreeSlice<N, E> slice(long var1, long var3);

    public abstract FingerTree<N, E> replaceHead(Node<N, E> var1);

    public abstract FingerTree<N, E> replaceLast(Node<N, E> var1);

    static <N, E> FingerTree<N, E> buildTree(Node<N, E>[] nodes, int n, long size) {
        if (n == 0) {
            return EmptyTree.getInstance();
        }
        if (n == 1) {
            return new SingletonTree<N, E>(nodes[0]);
        }
        if (n <= 8) {
            int mid = n / 2;
            Node[] left = new Node[mid];
            Node[] right = new Node[n - mid];
            Array.copy(nodes, mid, left);
            Array.copyToStart(nodes, mid, n - mid, right);
            return DeepTree.get(left, right, size);
        }
        int k = Math.min((n - 4) / 2, 4);
        Node[] left = new Node[k];
        Node[] right = new Node[k];
        Array.copy(nodes, k, left);
        Array.copyToStart(nodes, n - k, k, right);
        long leftSize = DeepTree.size((Node[])left);
        long rightSize = DeepTree.size((Node[])right);
        Node<N, E>[] outNodes = nodes;
        int remaining = n - 2 * k;
        int ns = (remaining + 4 - 1) / 4;
        int j = 0;
        for (int i = 0; i < ns; ++i) {
            int rem = ns - i;
            int sz = (remaining - j + rem - 1) / rem;
            Node[] ch = new Node[sz];
            Array.copyToStart(nodes, j, sz, ch);
            outNodes[i] = new InnerNode(ch);
            j += sz;
        }
        FingerTree<N, E> middle = FingerTree.buildTree(outNodes, ns, size - leftSize - rightSize);
        return new DeepTree(left, leftSize, middle, right, size);
    }

    abstract FingerTree<N, E> addAll(Node<N, E>[] var1, long var2, boolean var4);

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    abstract void toString(StringBuilder var1, int var2);

    public abstract long checkInvariants();

    public final ListIterator<E> listIterator(long start) {
        return FingerTreeIterator.get(this, start);
    }

    @Override
    public final ListIterator<E> iterator() {
        return this.listIterator(0L);
    }

    static void toString(Object obj, StringBuilder sb, int indent) {
        if (obj instanceof InnerNode) {
            ((InnerNode)obj).toString(sb, indent);
        } else if (obj instanceof PartialInnerNode) {
            ((PartialInnerNode)obj).toString(sb, indent);
        } else {
            boolean fst = true;
            for (String line : obj.toString().split("\r\n?|\n")) {
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ').append(' ');
                }
                sb.append(line);
                if (fst) {
                    fst = false;
                    continue;
                }
                sb.append('\n');
            }
        }
    }
}

