/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.atomic;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.query.up.atomic.BasicUpdate;
import org.basex.query.up.atomic.Rename;
import org.basex.query.up.atomic.StructuralUpdate;
import org.basex.query.up.atomic.UpdateValue;
import org.basex.util.Token;

final class Replace
extends StructuralUpdate {
    private final DataClip clip;

    Replace(int location, int shifts, int acc, int first, DataClip clip, int parent) {
        super(location, shifts, acc, first, parent);
        this.clip = clip;
    }

    static Replace getInstance(Data data, int pre, DataClip clip) {
        int kind = data.kind(pre);
        int parent = data.parent(pre, kind);
        int oldsize = data.size(pre, kind);
        int sh = clip.size() - oldsize;
        return new Replace(pre, sh, sh, pre + oldsize, clip, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void apply(Data data) {
        try {
            if (data.nspaces.isEmpty() && this.clip.data.nspaces.isEmpty()) {
                if (this.lazyReplace(data)) {
                    return;
                }
                data.replace(this.location, this.clip);
            } else {
                int kind = data.kind(this.location);
                int par = data.parent(this.location, kind);
                data.delete(this.location);
                if (kind == 3) {
                    data.insertAttr(this.location, par, this.clip);
                } else {
                    data.insert(this.location, par, this.clip);
                }
            }
        }
        finally {
            this.clip.finish();
        }
    }

    private boolean lazyReplace(Data data) {
        Data src = this.clip.data;
        int srcSize = this.clip.size();
        if (srcSize != data.size(this.location, data.kind(this.location))) {
            return false;
        }
        ArrayList<BasicUpdate> valueUpdates = new ArrayList<BasicUpdate>();
        block5: for (int c = 0; c < srcSize; ++c) {
            byte[] trgName;
            int tk;
            int s = this.clip.start + c;
            int t = this.location + c;
            int sk = src.kind(s);
            if (sk != (tk = data.kind(t))) {
                return false;
            }
            if (c > 0 && src.dist(s, sk) != data.dist(t, tk)) {
                return false;
            }
            if (sk == 2 || sk == 4 || sk == 0) {
                byte[] srcText = src.text(s, true);
                if (Token.eq(data.text(t, true), srcText)) continue;
                valueUpdates.add(UpdateValue.getInstance(data, t, srcText));
                continue;
            }
            byte[] srcName = src.name(s, sk);
            if (!Token.eq(srcName, trgName = data.name(t, tk))) {
                valueUpdates.add(Rename.getInstance(data, t, srcName, Token.EMPTY));
            }
            switch (sk) {
                case 1: {
                    if (src.attSize(s, sk) == data.attSize(t, tk) && src.size(s, sk) == data.size(t, tk)) continue block5;
                    return false;
                }
                case 3: {
                    byte[] av = src.text(s, false);
                    if (Token.eq(data.text(t, false), av)) continue block5;
                    valueUpdates.add(UpdateValue.getInstance(data, t, av));
                    continue block5;
                }
                case 5: {
                    byte[] srcText = src.text(s, true);
                    byte[] trgText = data.text(t, true);
                    int i = Token.indexOf(srcText, 32);
                    byte[] pv = i == -1 ? Token.EMPTY : Token.substring(srcText, i + 1);
                    if (Token.eq(pv, Token.indexOf(trgText, 32) == -1 ? Token.EMPTY : Token.substring(trgText, i + 1))) continue block5;
                    valueUpdates.add(UpdateValue.getInstance(data, t, pv));
                }
            }
        }
        for (BasicUpdate update : valueUpdates) {
            update.apply(data);
        }
        return true;
    }

    @Override
    DataClip getInsertionData() {
        return this.clip;
    }

    @Override
    boolean destructive() {
        return true;
    }

    @Override
    public String toString() {
        return "\nReplace: " + super.toString();
    }
}

