/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Optimize;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnTrace;
import org.basex.query.up.NamePool;
import org.basex.query.up.NodeUpdateComparator;
import org.basex.query.up.NodeUpdates;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.query.up.primitives.DataUpdate;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.query.up.primitives.db.Put;
import org.basex.query.up.primitives.node.NodeUpdate;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.NodeType;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.IntSet;
import org.basex.util.list.IntList;

final class DataUpdates {
    private final Data data;
    private final boolean writeback;
    private IntObjMap<NodeUpdates> nodeUpdates = new IntObjMap();
    private final List<DBUpdate> dbUpdates = new LinkedList<DBUpdate>();
    private final IntObjMap<Put> puts = new IntObjMap();
    private IntList nodes = new IntList(0L);
    private AtomicUpdateCache auc;
    private int size;

    DataUpdates(Data data, QueryContext qc) {
        this.data = data;
        this.writeback = qc.context.options.get(MainOptions.WRITEBACK);
    }

    void add(DataUpdate up, MemData tmp) throws QueryException {
        if (up instanceof NodeUpdate) {
            for (NodeUpdate nodeUp : ((NodeUpdate)up).substitute(tmp)) {
                this.nodeUpdates.computeIfAbsent(nodeUp.pre, NodeUpdates::new).add(nodeUp);
            }
        } else if (up instanceof Put) {
            Put p = (Put)up;
            int id = p.id;
            Put old = this.puts.get(id);
            if (old == null) {
                this.puts.put(id, p);
            } else {
                old.merge(p);
            }
        } else {
            DBUpdate dbUp = (DBUpdate)up;
            for (DBUpdate o : this.dbUpdates) {
                if (o.type != dbUp.type) continue;
                o.merge(dbUp);
                return;
            }
            this.dbUpdates.add(dbUp);
        }
    }

    void prepare(MemData memData, QueryContext qc) throws QueryException {
        int pre;
        int i;
        for (DBUpdate update : this.dbUpdates) {
            update.prepare();
        }
        int sz = this.nodeUpdates.size();
        this.nodes = new IntList(sz);
        for (i = 1; i <= sz; ++i) {
            this.nodes.add(this.nodeUpdates.key(i));
        }
        this.nodes.sort();
        for (i = 0; i < sz; ++i) {
            NodeUpdates updates = this.nodeUpdates.get(this.nodes.get(i));
            for (NodeUpdate update : updates.updates) {
                update.prepare(memData, qc);
            }
        }
        int p = this.nodes.size() - 1;
        int par = -1;
        while (p >= 0 && (par != this.nodes.get(p) || --p >= 0) && (pre = this.nodes.get(p)) != -1) {
            int k = this.data.kind(pre);
            if (k == 3) {
                par = this.data.parent(pre, 3);
                IntList il = new IntList();
                while (p >= 0 && (pre = this.nodes.get(p)) > par) {
                    il.add(pre);
                    --p;
                }
                if (par != -1) {
                    il.add(par);
                }
                this.checkNames(il.finish());
                continue;
            }
            if (k == 1) {
                this.checkNames(pre);
            }
            --p;
        }
        this.auc = this.createAtomicUpdates(this.preparePrimitives());
    }

    Data data() {
        return this.data;
    }

    void apply(QueryContext qc) throws QueryException {
        this.auc.execute(true);
        this.auc = null;
        Collections.sort(this.dbUpdates);
        int sz = this.dbUpdates.size();
        for (int i = 0; i < sz; ++i) {
            this.dbUpdates.get(i).apply();
            this.dbUpdates.set(i, null);
        }
        for (Put put : this.puts.values()) {
            put.apply();
        }
        try {
            Optimize.finish(this.data);
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(null, ex);
        }
        String original = this.data.meta.original;
        if (!original.isEmpty() && !Strings.startsWith(original, '~') && this.data.inMemory()) {
            if (this.writeback) {
                try {
                    Export.export(this.data, original, qc.context.options, null);
                }
                catch (IOException ex) {
                    throw QueryError.UPDBERROR_X.get(null, ex);
                }
            } else {
                FnTrace.trace(Token.token(original + ": Updates are not written back."), null, qc);
            }
        }
    }

    private List<NodeUpdate> preparePrimitives() {
        int i;
        ArrayList<NodeUpdate> upd = new ArrayList<NodeUpdate>();
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            int pre = this.nodes.get(i);
            NodeUpdates n = this.nodeUpdates.get(pre);
            for (NodeUpdate p : n.finish()) {
                upd.add(p);
                this.size += p.size();
            }
        }
        for (i = this.dbUpdates.size() - 1; i >= 0; --i) {
            this.size += this.dbUpdates.get(i).size();
        }
        this.nodeUpdates = null;
        this.nodes = null;
        upd.sort(new NodeUpdateComparator());
        return upd;
    }

    private AtomicUpdateCache createAtomicUpdates(List<NodeUpdate> l) {
        AtomicUpdateCache ac = new AtomicUpdateCache(this.data);
        int sz = l.size();
        for (int i = 0; i < sz; ++i) {
            NodeUpdate u = l.get(i);
            u.addAtomics(ac);
            l.set(i, null);
        }
        return ac;
    }

    int size() {
        return this.size;
    }

    private void checkNames(int ... pres) throws QueryException {
        NamePool names = new NamePool();
        for (int pre : pres) {
            NodeUpdates ups = this.nodeUpdates.get(pre);
            if (ups == null) continue;
            for (NodeUpdate up : ups.updates) {
                up.update(names);
            }
        }
        byte[][] ns = names.nsOK();
        if (ns != null) {
            throw QueryError.UPNSCONFL2_X_X.get(null, ns[0], ns[1]);
        }
        IntSet set = new IntSet();
        for (int pre : pres) {
            if (this.data.kind(pre) == 3) {
                this.addToPool(pre, names);
                set.add(pre);
                continue;
            }
            int ps = pre + this.data.attSize(pre, 1);
            for (int p = pre + 1; p < ps; ++p) {
                if (set.contains(p)) continue;
                this.addToPool(p, names);
            }
        }
        QNm dup = names.duplicate();
        if (dup != null) {
            throw QueryError.UPATTDUPL_X.get(null, dup);
        }
    }

    private void addToPool(int pre, NamePool names) {
        int uriId;
        byte[] nm = this.data.name(pre, 3);
        QNm name = new QNm(nm);
        if (name.hasPrefix() && (uriId = this.data.nspaces.uriIdForPrefix(Token.prefix(nm), pre, this.data)) != 0) {
            name.uri(this.data.nspaces.uri(uriId));
        }
        names.add(name, NodeType.ATTRIBUTE);
    }
}

