/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOStream;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.validate.ErrorInfo;
import org.basex.query.func.validate.ValidateFn;
import org.basex.query.func.validate.Validation;
import org.basex.query.func.validate.ValidationHandler;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.options.Options;
import org.xml.sax.SAXException;

public class ValidateXsd
extends ValidateFn {
    private static final String FACTORY = "http://www.w3.org/2001/XMLSchema";
    private static final String SAXON_VERSION_URI = "http://saxon.sf.net/feature/xsd-version";
    static final String[] IMPL = new String[]{"com.saxonica.ee.jaxp.SchemaFactoryImpl", "Saxon EE", "1.1", "org.apache.xerces.jaxp.validation.XMLSchema11Factory", "Xerces", "1.1", "org.apache.xerces.jaxp.validation.XMLSchemaFactory", "Xerces", "1.0", "", "Java", "1.0"};
    static final int OFFSET;
    static final boolean SAXON;
    static final boolean JAVA;

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.check(qc);
    }

    @Override
    public ArrayList<ErrorInfo> errors(final QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        return this.process(new Validation(){

            @Override
            void process(ValidationHandler handler) throws IOException, SAXException, QueryException {
                SchemaFactory sf;
                IO in = ValidateXsd.this.read(ValidateXsd.this.toNodeOrAtomItem(0, qc), null);
                Item schema = ValidateXsd.this.exprs.length > 1 ? ValidateXsd.this.toNodeOrAtomItem(1, qc) : null;
                HashMap<String, String> options = ValidateXsd.this.toOptions(2, new Options(), qc).free();
                SchemaFactory schemaFactory = sf = JAVA ? SchemaFactory.newInstance(ValidateXsd.FACTORY) : (SchemaFactory)Reflect.get(Reflect.find(IMPL[OFFSET]));
                if (SAXON) {
                    sf.setProperty(ValidateXsd.SAXON_VERSION_URI, IMPL[OFFSET + 2]);
                }
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    sf.setFeature(entry.getKey(), Strings.toBoolean(entry.getValue()));
                }
                Schema s = schema == null ? sf.newSchema() : sf.newSchema(new URL(this.prepare(ValidateXsd.this.read(schema, null), handler).url()));
                Validator v = s.newValidator();
                v.setErrorHandler(handler);
                v.validate(in instanceof IOContent || in instanceof IOStream ? new StreamSource(in.inputStream()) : new StreamSource(in.url()));
            }
        });
    }

    static {
        int i = 0;
        while (i + 3 < IMPL.length && Reflect.find(IMPL[i]) == null) {
            i += 3;
        }
        OFFSET = i;
        SAXON = i == 0;
        JAVA = i == 9;
    }
}

